/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.ajp.AjpClientConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class AjpClientProvider
implements ClientProvider {
    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("ajp"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, final URI uri, XnioWorker worker, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        ChannelListener<StreamConnection> openListener = new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection connection) {
                AjpClientProvider.this.handleConnected(connection, listener, uri, ssl, bufferPool, options);
            }
        };
        IoFuture.Notifier<StreamConnection, Object> notifier = new IoFuture.Notifier<StreamConnection, Object>(){

            @Override
            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
        if (bindAddress == null) {
            worker.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener<? super StreamConnection>)openListener, options).addNotifier(notifier, null);
        } else {
            worker.openStreamConnection(bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener<? super StreamConnection>)openListener, null, options).addNotifier(notifier, null);
        }
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, final URI uri, XnioIoThread ioThread, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        ChannelListener<StreamConnection> openListener = new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection connection) {
                AjpClientProvider.this.handleConnected(connection, listener, uri, ssl, bufferPool, options);
            }
        };
        IoFuture.Notifier<StreamConnection, Object> notifier = new IoFuture.Notifier<StreamConnection, Object>(){

            @Override
            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
        if (bindAddress == null) {
            ioThread.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener<? super StreamConnection>)openListener, options).addNotifier(notifier, null);
        } else {
            ioThread.openStreamConnection(bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener<? super StreamConnection>)openListener, null, options).addNotifier(notifier, null);
        }
    }

    private void handleConnected(StreamConnection connection, ClientCallback<ClientConnection> listener, URI uri, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        listener.completed(new AjpClientConnection(connection, options, bufferPool));
    }
}

