/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyStreamSourceChannel;
import io.undertow.spdy.SpdySynReplyStreamSinkChannel;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.Deflater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

public class SpdySynStreamStreamSourceChannel
extends SpdyStreamSourceChannel {
    private boolean rst = false;
    private final Deflater deflater;
    private final HeaderMap headers;
    private final int streamId;
    private HeaderMap newHeaders = null;
    private SpdySynReplyStreamSinkChannel synResponse;
    private int flowControlWindow;
    private ChannelListener<SpdySynStreamStreamSourceChannel> completionListener;

    SpdySynStreamStreamSourceChannel(SpdyChannel framedChannel, Pooled<ByteBuffer> data, long frameDataRemaining, Deflater deflater, HeaderMap headers, int streamId) {
        super(framedChannel, data, frameDataRemaining);
        this.deflater = deflater;
        this.headers = headers;
        this.streamId = streamId;
    }

    public SpdySynReplyStreamSinkChannel getResponseChannel() {
        if (this.synResponse != null) {
            return this.synResponse;
        }
        this.synResponse = new SpdySynReplyStreamSinkChannel(this.getSpdyChannel(), this.streamId, this.deflater);
        this.getSpdyChannel().registerStreamSink(this.synResponse);
        return this.synResponse;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.handleNewHeaders();
        int read = super.read(dst);
        this.updateFlowControlWindow(read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.handleNewHeaders();
        long read = super.read(dsts, offset, length);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        this.handleNewHeaders();
        long read = super.read(dsts);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel streamSinkChannel) throws IOException {
        this.handleNewHeaders();
        long read = super.transferTo(count, throughBuffer, streamSinkChannel);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        this.handleNewHeaders();
        long read = super.transferTo(position, count, target);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    private synchronized void handleNewHeaders() {
        if (this.newHeaders != null) {
            for (HeaderValues header : this.newHeaders) {
                this.headers.addAll(header.getHeaderName(), header);
            }
            this.newHeaders = null;
        }
    }

    synchronized void addNewHeaders(HeaderMap headers) {
        if (this.newHeaders != null) {
            this.newHeaders = headers;
        } else {
            for (HeaderValues header : headers) {
                this.newHeaders.addAll(header.getHeaderName(), header);
            }
        }
    }

    private void updateFlowControlWindow(int read) {
        if (read <= 0) {
            return;
        }
        this.flowControlWindow -= read;
        SpdyChannel spdyChannel = this.getSpdyChannel();
        spdyChannel.updateReceiveFlowControlWindow(read);
        int initialWindowSize = spdyChannel.getInitialWindowSize();
        if (this.flowControlWindow < initialWindowSize / 2) {
            int delta = initialWindowSize - this.flowControlWindow;
            this.flowControlWindow += delta;
            spdyChannel.sendUpdateWindowSize(this.streamId, delta);
        }
    }

    @Override
    protected void complete() throws IOException {
        super.complete();
        if (this.completionListener != null) {
            ChannelListeners.invokeChannelListener(this, this.completionListener);
        }
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    public ChannelListener<SpdySynStreamStreamSourceChannel> getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(ChannelListener<SpdySynStreamStreamSourceChannel> completionListener) {
        this.completionListener = completionListener;
    }

    @Override
    void rstStream() {
        if (this.rst) {
            return;
        }
        this.rst = true;
        this.markStreamBroken();
        this.getSpdyChannel().sendRstStream(this.streamId, 5);
    }

    @Override
    protected void channelForciblyClosed() {
        if (this.completionListener != null) {
            this.completionListener.handleEvent(this);
        }
        this.rstStream();
    }
}

