/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.protocols.http2.Http2Channel;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.protocol.http2.Http2ReceiveListener;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.nio.ByteBuffer;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;

public class Http2UpgradeHandler
implements HttpHandler {
    private final HttpHandler next;

    public Http2UpgradeHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String settings;
        String upgrade = exchange.getRequestHeaders().getFirst(Headers.UPGRADE);
        if (upgrade != null && upgrade.equals("h2c-14") && (settings = exchange.getRequestHeaders().getFirst("HTTP2-Settings")) != null) {
            final ByteBuffer settingsFrame = FlexBase64.decode(settings);
            exchange.upgradeChannel(new HttpUpgradeListener(){

                @Override
                public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                    OptionMap undertowOptions = exchange.getConnection().getUndertowOptions();
                    Http2Channel channel = new Http2Channel(streamConnection, exchange.getConnection().getBufferPool(), null, false, true, settingsFrame, undertowOptions);
                    Http2ReceiveListener receiveListener = new Http2ReceiveListener(new HttpHandler(){

                        @Override
                        public void handleRequest(HttpServerExchange exchange) throws Exception {
                            if (exchange.getRequestHeaders().contains("X-HTTP2-connect-only")) {
                                exchange.endExchange();
                                return;
                            }
                            Http2UpgradeHandler.this.next.handleRequest(exchange);
                        }
                    }, undertowOptions, exchange.getConnection().getBufferSize());
                    channel.getReceiveSetter().set(receiveListener);
                    receiveListener.handleInitialRequest(exchange, channel);
                    channel.resumeReceives();
                }
            });
            return;
        }
        this.next.handleRequest(exchange);
    }
}

