/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.UndertowMessages;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyProtocolUtils;
import io.undertow.protocols.spdy.SpdyStreamSinkChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.xnio.IoUtils;
import org.xnio.Pooled;

public abstract class SpdyStreamStreamSinkChannel
extends SpdyStreamSinkChannel {
    private final int streamId;
    private volatile boolean reset = false;
    private int flowControlWindow;
    private int initialWindowSize;
    private SendFrameHeader header;

    SpdyStreamStreamSinkChannel(SpdyChannel channel, int streamId) {
        super(channel);
        this.streamId = streamId;
        this.initialWindowSize = this.flowControlWindow = channel.getInitialWindowSize();
    }

    public int getStreamId() {
        return this.streamId;
    }

    SendFrameHeader generateSendFrameHeader() {
        this.header = this.createFrameHeaderImpl();
        return this.header;
    }

    void clearHeader() {
        this.header = null;
    }

    @Override
    protected void channelForciblyClosed() throws IOException {
        ((SpdyChannel)this.getChannel()).removeStreamSink(this.getStreamId());
        if (this.reset) {
            return;
        }
        this.reset = true;
        if (this.streamId % 2 == (((SpdyChannel)this.getChannel()).isClient() ? 1 : 0)) {
            if (this.isFirstDataWritten()) {
                ((SpdyChannel)this.getChannel()).sendRstStream(this.streamId, 5);
            }
        } else {
            ((SpdyChannel)this.getChannel()).sendRstStream(this.streamId, 6);
        }
    }

    @Override
    protected final SendFrameHeader createFrameHeader() {
        SendFrameHeader header = this.header;
        this.header = null;
        return header;
    }

    @Override
    protected void handleFlushComplete(boolean finalFrame) {
        if (finalFrame) {
            ((SpdyChannel)this.getChannel()).removeStreamSink(this.getStreamId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pooled<ByteBuffer>[] createHeaderBlock(Pooled<ByteBuffer> firstHeaderBuffer, Pooled<ByteBuffer>[] allHeaderBuffers, ByteBuffer firstBuffer, HeaderMap headers) {
        Pooled<ByteBuffer> outPooled = ((SpdyChannel)this.getChannel()).getHeapBufferPool().allocate();
        Pooled<ByteBuffer> inPooled = ((SpdyChannel)this.getChannel()).getHeapBufferPool().allocate();
        try {
            int totalLength;
            Pooled<ByteBuffer> currentPooled = firstHeaderBuffer;
            ByteBuffer inputBuffer = inPooled.getResource();
            ByteBuffer outputBuffer = outPooled.getResource();
            SpdyProtocolUtils.putInt(inputBuffer, headers.size());
            long fiCookie = headers.fastIterateNonEmpty();
            while (fiCookie != -1L) {
                int i;
                HeaderValues headerValues = headers.fiCurrent(fiCookie);
                int valueSize = headerValues.size() - 1;
                for (int i2 = 0; i2 < headerValues.size(); ++i2) {
                    String val = headerValues.get(i2);
                    valueSize += val.length();
                }
                int totalSize = 8 + headerValues.getHeaderName().length() + valueSize;
                if (totalSize > inputBuffer.limit()) {
                    throw UndertowMessages.MESSAGES.headersTooLargeToFitInHeapBuffer();
                }
                if (totalSize > inputBuffer.remaining()) {
                    if ((allHeaderBuffers = this.doDeflate(inputBuffer, outputBuffer, currentPooled, allHeaderBuffers)) != null) {
                        currentPooled = allHeaderBuffers[allHeaderBuffers.length - 1];
                    }
                    inputBuffer.clear();
                    outputBuffer.clear();
                }
                SpdyProtocolUtils.putInt(inputBuffer, headerValues.getHeaderName().length());
                for (i = 0; i < headerValues.getHeaderName().length(); ++i) {
                    inputBuffer.put((byte)Character.toLowerCase((char)headerValues.getHeaderName().byteAt(i)));
                }
                SpdyProtocolUtils.putInt(inputBuffer, valueSize);
                for (i = 0; i < headerValues.size(); ++i) {
                    String val = headerValues.get(i);
                    for (int j = 0; j < val.length(); ++j) {
                        inputBuffer.put((byte)val.charAt(j));
                    }
                    if (i == headerValues.size() - 1) continue;
                    inputBuffer.put((byte)0);
                }
                fiCookie = headers.fiNext(fiCookie);
            }
            if ((allHeaderBuffers = this.doDeflate(inputBuffer, outputBuffer, currentPooled, allHeaderBuffers)) != null) {
                totalLength = -8;
                for (Pooled<ByteBuffer> b : allHeaderBuffers) {
                    totalLength += b.getResource().position();
                }
            } else {
                totalLength = firstBuffer.position() - 8;
            }
            SpdyProtocolUtils.putInt(firstBuffer, (this.isWritesShutdown() && !this.getBuffer().hasRemaining() ? 1 : 0) << 24 | totalLength, 4);
        }
        finally {
            inPooled.free();
            outPooled.free();
        }
        return allHeaderBuffers;
    }

    protected abstract SendFrameHeader createFrameHeaderImpl();

    protected synchronized int grabFlowControlBytes(int toSend) {
        if (toSend == 0) {
            return 0;
        }
        int newWindowSize = ((SpdyChannel)this.getChannel()).getInitialWindowSize();
        int settingsDelta = newWindowSize - this.initialWindowSize;
        this.initialWindowSize = newWindowSize;
        this.flowControlWindow += settingsDelta;
        int min = Math.min(toSend, this.flowControlWindow);
        int actualBytes = ((SpdyChannel)this.getChannel()).grabFlowControlBytes(min);
        this.flowControlWindow -= actualBytes;
        return actualBytes;
    }

    synchronized void updateFlowControlWindow(int delta) throws IOException {
        boolean exhausted = this.flowControlWindow == 0;
        this.flowControlWindow += delta;
        if (exhausted) {
            ((SpdyChannel)this.getChannel()).notifyFlowControlAllowed();
            if (this.isWriteResumed()) {
                this.resumeWritesInternal(true);
            }
        }
    }

    private Pooled[] doDeflate(ByteBuffer inputBuffer, ByteBuffer outputBuffer, Pooled<ByteBuffer> currentPooled, Pooled<ByteBuffer>[] allHeaderBuffers) {
        Deflater deflater = this.getDeflater();
        deflater.setInput(inputBuffer.array(), inputBuffer.arrayOffset(), inputBuffer.position());
        do {
            int deflated;
            if ((deflated = deflater.deflate(outputBuffer.array(), outputBuffer.arrayOffset(), outputBuffer.remaining(), 2)) <= currentPooled.getResource().remaining()) {
                currentPooled.getResource().put(outputBuffer.array(), outputBuffer.arrayOffset(), deflated);
                continue;
            }
            int pos = outputBuffer.arrayOffset();
            int remaining = deflated;
            ByteBuffer current = currentPooled.getResource();
            do {
                int toPut = Math.min(current.remaining(), remaining);
                current.put(outputBuffer.array(), pos, toPut);
                pos += toPut;
                if ((remaining -= toPut) <= 0) continue;
                allHeaderBuffers = this.allocateAll(allHeaderBuffers, currentPooled);
                currentPooled = allHeaderBuffers[allHeaderBuffers.length - 1];
                current = currentPooled.getResource();
            } while (remaining > 0);
        } while (!deflater.needsInput());
        return allHeaderBuffers;
    }

    protected abstract Deflater getDeflater();

    protected Pooled<ByteBuffer>[] allocateAll(Pooled<ByteBuffer>[] allHeaderBuffers, Pooled<ByteBuffer> currentBuffer) {
        Pooled[] ret;
        if (allHeaderBuffers == null) {
            ret = new Pooled[]{currentBuffer, ((SpdyChannel)this.getChannel()).getBufferPool().allocate()};
        } else {
            ret = new Pooled[allHeaderBuffers.length + 1];
            System.arraycopy(allHeaderBuffers, 0, ret, 0, allHeaderBuffers.length);
            ret[ret.length - 1] = ((SpdyChannel)this.getChannel()).getBufferPool().allocate();
        }
        return ret;
    }

    void rstStream() {
        if (this.reset) {
            return;
        }
        this.reset = true;
        IoUtils.safeClose((Closeable)this);
        ((SpdyChannel)this.getChannel()).removeStreamSink(this.getStreamId());
    }
}

