/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyPingStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyStreamStreamSourceChannel;
import io.undertow.protocols.spdy.SpdySynReplyStreamSinkChannel;
import io.undertow.protocols.spdy.SpdySynStreamStreamSourceChannel;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.spdy.SpdyServerConnection;
import io.undertow.server.protocol.spdy.SpdySslSessionInfo;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class SpdyReceiveListener
implements ChannelListener<SpdyChannel> {
    private static final HttpString METHOD = new HttpString(":method");
    private static final HttpString PATH = new HttpString(":path");
    private static final HttpString SCHEME = new HttpString(":scheme");
    private static final HttpString VERSION = new HttpString(":version");
    private static final HttpString HOST = new HttpString(":host");
    private final HttpHandler rootHandler;
    private final long maxEntitySize;
    private final OptionMap undertowOptions;
    private final String encoding;
    private final boolean decode;
    private final StringBuilder decodeBuffer = new StringBuilder();
    private final boolean allowEncodingSlash;
    private final int bufferSize;

    public SpdyReceiveListener(HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.maxEntitySize = undertowOptions.get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.allowEncodingSlash = undertowOptions.get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
        this.decode = undertowOptions.get(UndertowOptions.DECODE_URL, true);
        this.encoding = undertowOptions.get(UndertowOptions.DECODE_URL, true) ? undertowOptions.get(UndertowOptions.URL_CHARSET, "UTF-8") : null;
    }

    @Override
    public void handleEvent(SpdyChannel channel) {
        try {
            SpdyStreamSourceChannel frame = (SpdyStreamSourceChannel)channel.receive();
            if (frame == null) {
                return;
            }
            if (frame instanceof SpdyPingStreamSourceChannel) {
                this.handlePing((SpdyPingStreamSourceChannel)frame);
            } else if (frame instanceof SpdySynStreamStreamSourceChannel) {
                SpdySynStreamStreamSourceChannel dataChannel = (SpdySynStreamStreamSourceChannel)frame;
                SpdyServerConnection connection = new SpdyServerConnection(channel, dataChannel, this.undertowOptions, this.bufferSize);
                final HttpServerExchange exchange = new HttpServerExchange(connection, dataChannel.getHeaders(), dataChannel.getResponseChannel().getHeaders(), this.maxEntitySize);
                dataChannel.setMaxStreamSize(this.maxEntitySize);
                exchange.setRequestScheme(exchange.getRequestHeaders().getFirst(SCHEME));
                exchange.setProtocol(new HttpString(exchange.getRequestHeaders().getFirst(VERSION)));
                exchange.setRequestMethod(new HttpString(exchange.getRequestHeaders().getFirst(METHOD)));
                exchange.getRequestHeaders().put(Headers.HOST, exchange.getRequestHeaders().getFirst(HOST));
                String path = exchange.getRequestHeaders().getFirst(PATH);
                Connectors.setExchangeRequestPath(exchange, path, this.encoding, this.decode, this.allowEncodingSlash, this.decodeBuffer);
                SSLSession session = channel.getSslSession();
                if (session != null) {
                    connection.setSslSessionInfo(new SpdySslSessionInfo(channel));
                }
                dataChannel.getResponseChannel().setCompletionListener(new ChannelListener<SpdySynReplyStreamSinkChannel>(){

                    @Override
                    public void handleEvent(SpdySynReplyStreamSinkChannel channel) {
                        Connectors.terminateResponse(exchange);
                    }
                });
                if (!dataChannel.isOpen()) {
                    Connectors.terminateRequest(exchange);
                } else {
                    dataChannel.setCompletionListener(new ChannelListener<SpdyStreamStreamSourceChannel>(){

                        @Override
                        public void handleEvent(SpdyStreamStreamSourceChannel channel) {
                            Connectors.terminateRequest(exchange);
                        }
                    });
                }
                Connectors.executeRootHandler(this.rootHandler, exchange);
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)channel);
        }
    }

    private void handlePing(SpdyPingStreamSourceChannel frame) {
        int id = frame.getId();
        if (id % 2 == 1) {
            frame.getSpdyChannel().sendPing(id);
        }
    }
}

