/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.BytesReceivedStreamSourceConduit;
import io.undertow.conduits.BytesSentStreamSinkConduit;
import io.undertow.conduits.ReadTimeoutStreamSourceConduit;
import io.undertow.conduits.WriteTimeoutStreamSinkConduit;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.ajp.AjpReadListener;
import io.undertow.server.protocol.ajp.AjpRequestParser;
import io.undertow.server.protocol.ajp.AjpServerConnection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;

public class AjpOpenListener
implements OpenListener {
    public static final String UTF_8 = "UTF-8";
    private final Pool<ByteBuffer> bufferPool;
    private final int bufferSize;
    private volatile String scheme;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private final AjpRequestParser parser;
    private volatile boolean statisticsEnabled;
    private final ConnectorStatisticsImpl connectorStatistics;

    @Deprecated
    public AjpOpenListener(Pool<ByteBuffer> pool, int bufferSize) {
        this(pool, OptionMap.EMPTY);
    }

    @Deprecated
    public AjpOpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions, int bufferSize) {
        this(pool, undertowOptions);
    }

    public AjpOpenListener(Pool<ByteBuffer> pool) {
        this(pool, OptionMap.EMPTY);
    }

    public AjpOpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        Pooled<ByteBuffer> buf = pool.allocate();
        this.bufferSize = buf.getResource().remaining();
        buf.free();
        this.parser = new AjpRequestParser(undertowOptions.get(UndertowOptions.URL_CHARSET, UTF_8), undertowOptions.get(UndertowOptions.DECODE_URL, true));
        this.connectorStatistics = new ConnectorStatisticsImpl();
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public void handleEvent(StreamConnection channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        try {
            Integer writeTimeout;
            Integer readTimeout = channel.getOption(Options.READ_TIMEOUT);
            Integer idleTimeout = this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
            if ((readTimeout == null || readTimeout <= 0) && idleTimeout != null) {
                readTimeout = idleTimeout;
            } else if (readTimeout != null && idleTimeout != null && idleTimeout > 0) {
                readTimeout = Math.min(readTimeout, idleTimeout);
            }
            if (readTimeout != null && readTimeout > 0) {
                channel.getSourceChannel().setConduit(new ReadTimeoutStreamSourceConduit(channel.getSourceChannel().getConduit(), channel, this));
            }
            if (((writeTimeout = channel.getOption(Options.WRITE_TIMEOUT)) == null || writeTimeout <= 0) && idleTimeout != null) {
                writeTimeout = idleTimeout;
            } else if (writeTimeout != null && idleTimeout != null && idleTimeout > 0) {
                writeTimeout = Math.min(writeTimeout, idleTimeout);
            }
            if (writeTimeout != null && writeTimeout > 0) {
                channel.getSinkChannel().setConduit(new WriteTimeoutStreamSinkConduit(channel.getSinkChannel().getConduit(), channel, this));
            }
        }
        catch (IOException e) {
            IoUtils.safeClose((Closeable)channel);
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        }
        if (this.statisticsEnabled) {
            channel.getSinkChannel().setConduit(new BytesSentStreamSinkConduit(channel.getSinkChannel().getConduit(), this.connectorStatistics.sentAccumulator()));
            channel.getSourceChannel().setConduit(new BytesReceivedStreamSourceConduit(channel.getSourceChannel().getConduit(), this.connectorStatistics.sentAccumulator()));
        }
        AjpServerConnection connection = new AjpServerConnection(channel, this.bufferPool, this.rootHandler, this.undertowOptions, this.bufferSize);
        AjpReadListener readListener = new AjpReadListener(connection, this.scheme, this.parser, this.statisticsEnabled ? this.connectorStatistics : null);
        connection.setAjpReadListener(readListener);
        readListener.startRequest();
        channel.getSourceChannel().setReadListener(readListener);
        readListener.handleEvent(channel.getSourceChannel());
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            return this.connectorStatistics;
        }
        return null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }
}

