/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

public class AsyncSenderImpl
implements Sender {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private StreamSinkChannel channel;
    private final HttpServerExchange exchange;
    private ByteBuffer[] buffer;
    private Pooled[] pooledBuffers = null;
    private FileChannel fileChannel;
    private IoCallback callback;
    private boolean inCallback;
    private final ChannelListener<StreamSinkChannel> writeListener = new ChannelListener<StreamSinkChannel>(){

        @Override
        public void handleEvent(StreamSinkChannel streamSinkChannel) {
            try {
                long res;
                long toWrite = Buffers.remaining(AsyncSenderImpl.this.buffer);
                for (long written = 0L; written < toWrite; written += res) {
                    res = streamSinkChannel.write(AsyncSenderImpl.this.buffer, 0, AsyncSenderImpl.this.buffer.length);
                    if (res != 0L) continue;
                    return;
                }
                streamSinkChannel.suspendWrites();
                AsyncSenderImpl.this.invokeOnComplete();
            }
            catch (IOException e) {
                streamSinkChannel.suspendWrites();
                AsyncSenderImpl.this.invokeOnException(AsyncSenderImpl.this.callback, e);
            }
        }
    };
    private final TransferTask transferTask = new TransferTask();

    public AsyncSenderImpl(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.buffer != null || this.fileChannel != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        StreamSinkChannel channel = this.channel;
        if (channel == null) {
            if (callback == IoCallback.END_EXCHANGE && this.exchange.getResponseContentLength() == -1L) {
                this.exchange.setResponseContentLength(buffer.remaining());
            }
            this.channel = channel = this.exchange.getResponseChannel();
            if (channel == null) {
                throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
            }
        }
        this.callback = callback;
        if (this.inCallback) {
            this.buffer = new ByteBuffer[]{buffer};
            return;
        }
        try {
            do {
                if (buffer.remaining() == 0) {
                    callback.onComplete(this.exchange, this);
                    return;
                }
                int res = channel.write(buffer);
                if (res != 0) continue;
                this.buffer = new ByteBuffer[]{buffer};
                this.callback = callback;
                channel.getWriteSetter().set(this.writeListener);
                channel.resumeWrites();
                return;
            } while (buffer.hasRemaining());
            this.invokeOnComplete();
        }
        catch (IOException e) {
            this.invokeOnException(callback, e);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.buffer != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.callback = callback;
        if (this.inCallback) {
            this.buffer = buffer;
            return;
        }
        long totalToWrite = Buffers.remaining(buffer);
        StreamSinkChannel channel = this.channel;
        if (channel == null) {
            if (callback == IoCallback.END_EXCHANGE && this.exchange.getResponseContentLength() == -1L) {
                this.exchange.setResponseContentLength(totalToWrite);
            }
            this.channel = channel = this.exchange.getResponseChannel();
            if (channel == null) {
                throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
            }
        }
        long total = totalToWrite;
        long written = 0L;
        try {
            do {
                long res = channel.write(buffer);
                written += res;
                if (res != 0L) continue;
                this.buffer = buffer;
                this.callback = callback;
                channel.getWriteSetter().set(this.writeListener);
                channel.resumeWrites();
                return;
            } while (written < total);
            this.invokeOnComplete();
        }
        catch (IOException e) {
            this.invokeOnException(callback, e);
        }
    }

    @Override
    public void transferFrom(FileChannel source, IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.fileChannel != null || this.buffer != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.callback = callback;
        this.fileChannel = source;
        if (this.inCallback) {
            return;
        }
        if (this.exchange.isInIoThread()) {
            this.exchange.dispatch(this.transferTask);
            return;
        }
        this.transferTask.run();
    }

    @Override
    public void send(ByteBuffer buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(ByteBuffer[] buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, IoCallback callback) {
        this.send(data, utf8, callback);
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        ByteBuffer bytes = ByteBuffer.wrap(data.getBytes(charset));
        if (bytes.remaining() == 0) {
            callback.onComplete(this.exchange, this);
        } else {
            int i = 0;
            ByteBuffer[] bufs = null;
            while (bytes.hasRemaining()) {
                Pooled<ByteBuffer> pooled = this.exchange.getConnection().getBufferPool().allocate();
                if (bufs == null) {
                    int noBufs = (bytes.remaining() + pooled.getResource().remaining() - 1) / pooled.getResource().remaining();
                    this.pooledBuffers = new Pooled[noBufs];
                    bufs = new ByteBuffer[noBufs];
                }
                this.pooledBuffers[i] = pooled;
                bufs[i] = pooled.getResource();
                Buffers.copy(pooled.getResource(), bytes);
                pooled.getResource().flip();
                ++i;
            }
            this.send(bufs, callback);
        }
    }

    @Override
    public void send(String data) {
        this.send(data, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, Charset charset) {
        this.send(data, charset, IoCallback.END_EXCHANGE);
    }

    @Override
    public void close(final IoCallback callback) {
        block8: {
            try {
                StreamSinkChannel channel = this.channel;
                if (channel == null) {
                    if (this.exchange.getResponseContentLength() == -1L) {
                        this.exchange.setResponseContentLength(0L);
                    }
                    this.channel = channel = this.exchange.getResponseChannel();
                    if (channel == null) {
                        throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
                    }
                }
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            if (callback != null) {
                                callback.onComplete(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this);
                            }
                        }
                    }, new ChannelExceptionHandler<StreamSinkChannel>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            try {
                                if (callback != null) {
                                    AsyncSenderImpl.this.invokeOnException(callback, exception);
                                }
                            }
                            finally {
                                IoUtils.safeClose((Closeable)channel);
                            }
                        }
                    }));
                    channel.resumeWrites();
                } else if (callback != null) {
                    callback.onComplete(this.exchange, this);
                }
            }
            catch (IOException e) {
                if (callback == null) break block8;
                this.invokeOnException(callback, e);
            }
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnComplete() {
        block11: {
            while (true) {
                if (this.pooledBuffers != null) {
                    for (Pooled buffer : this.pooledBuffers) {
                        buffer.free();
                    }
                    this.pooledBuffers = null;
                }
                IoCallback callback = this.callback;
                this.buffer = null;
                this.fileChannel = null;
                this.callback = null;
                this.inCallback = true;
                try {
                    callback.onComplete(this.exchange, this);
                }
                finally {
                    this.inCallback = false;
                }
                StreamSinkChannel channel = this.channel;
                if (this.buffer != null) {
                    long t;
                    long total = t = Buffers.remaining(this.buffer);
                    long written = 0L;
                    try {
                        do {
                            long res = channel.write(this.buffer);
                            written += res;
                            if (res != 0L) continue;
                            channel.getWriteSetter().set(this.writeListener);
                            channel.resumeWrites();
                            return;
                        } while (written < total);
                    }
                    catch (IOException e) {
                        this.invokeOnException(callback, e);
                    }
                    continue;
                }
                if (this.fileChannel == null) break block11;
                if (!this.transferTask.run(false)) break;
            }
            return;
        }
    }

    private void invokeOnException(IoCallback callback, IOException e) {
        if (this.pooledBuffers != null) {
            for (Pooled buffer : this.pooledBuffers) {
                buffer.free();
            }
            this.pooledBuffers = null;
        }
        callback.onException(this.exchange, this, e);
    }

    public class TransferTask
    implements Runnable,
    ChannelListener<StreamSinkChannel> {
        public boolean run(boolean complete) {
            try {
                FileChannel source = AsyncSenderImpl.this.fileChannel;
                long pos = source.position();
                long size = source.size();
                StreamSinkChannel dest = AsyncSenderImpl.this.channel;
                if (dest == null) {
                    if (AsyncSenderImpl.this.callback == IoCallback.END_EXCHANGE && AsyncSenderImpl.this.exchange.getResponseContentLength() == -1L) {
                        AsyncSenderImpl.this.exchange.setResponseContentLength(size);
                    }
                    dest = AsyncSenderImpl.this.exchange.getResponseChannel();
                    AsyncSenderImpl.this.channel = dest;
                    if (dest == null) {
                        throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
                    }
                }
                while (size - pos > 0L) {
                    long ret = dest.transferFrom(source, pos, size - pos);
                    pos += ret;
                    if (ret != 0L) continue;
                    source.position(pos);
                    dest.getWriteSetter().set(this);
                    dest.resumeWrites();
                    return false;
                }
                if (complete) {
                    AsyncSenderImpl.this.invokeOnComplete();
                }
            }
            catch (IOException e) {
                AsyncSenderImpl.this.invokeOnException(AsyncSenderImpl.this.callback, e);
            }
            return true;
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            channel.suspendWrites();
            channel.getWriteSetter().set(null);
            AsyncSenderImpl.this.exchange.dispatch(this);
        }

        @Override
        public void run() {
            this.run(true);
        }
    }
}

