/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.core.BinaryOutputStream;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.SendHandlerAdapter;
import io.undertow.websockets.jsr.SendResultFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import org.xnio.channels.Channels;

final class WebSocketSessionRemoteEndpoint
implements RemoteEndpoint {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final WebSocketChannel webSocketChannel;
    private final EndpointConfig config;
    private final RemoteEndpoint.Async async = new AsyncWebSocketSessionRemoteEndpoint();
    private final RemoteEndpoint.Basic basic = new BasicWebSocketSessionRemoteEndpoint();
    private final Encoding encoding;

    public WebSocketSessionRemoteEndpoint(WebSocketChannel webSocketChannel, EndpointConfig config, Encoding encoding) {
        this.webSocketChannel = webSocketChannel;
        this.config = config;
        this.encoding = encoding;
    }

    public RemoteEndpoint.Async getAsync() {
        return this.async;
    }

    public RemoteEndpoint.Basic getBasic() {
        return this.basic;
    }

    @Override
    public void flushBatch() {
    }

    @Override
    public void setBatchingAllowed(boolean allowed) throws IOException {
    }

    @Override
    public boolean getBatchingAllowed() {
        return false;
    }

    @Override
    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        WebSockets.sendPing(applicationData, this.webSocketChannel, null);
    }

    @Override
    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        WebSockets.sendPong(applicationData, this.webSocketChannel, null);
    }

    class BasicWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Basic {
        private StreamSinkFrameChannel binaryFrameSender;
        private StreamSinkFrameChannel textFrameSender;

        BasicWebSocketSessionRemoteEndpoint() {
        }

        public void assertNotInFragment() {
            if (this.textFrameSender != null || this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
        }

        @Override
        public void sendText(String text) throws IOException {
            this.assertNotInFragment();
            WebSockets.sendTextBlocking(text, WebSocketSessionRemoteEndpoint.this.webSocketChannel);
        }

        @Override
        public void sendBinary(ByteBuffer data) throws IOException {
            this.assertNotInFragment();
            WebSockets.sendBinaryBlocking(data, WebSocketSessionRemoteEndpoint.this.webSocketChannel);
            data.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendText(String partialMessage, boolean isLast) throws IOException {
            if (this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.textFrameSender == null) {
                this.textFrameSender = WebSocketSessionRemoteEndpoint.this.webSocketChannel.send(WebSocketFrameType.TEXT);
            }
            try {
                Channels.writeBlocking(this.textFrameSender, WebSocketUtils.fromUtf8String(partialMessage));
                if (isLast) {
                    this.textFrameSender.shutdownWrites();
                }
                Channels.flushBlocking(this.textFrameSender);
            }
            finally {
                if (isLast) {
                    this.textFrameSender = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            if (this.textFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.binaryFrameSender == null) {
                this.binaryFrameSender = WebSocketSessionRemoteEndpoint.this.webSocketChannel.send(WebSocketFrameType.BINARY);
            }
            try {
                Channels.writeBlocking(this.binaryFrameSender, partialByte);
                if (isLast) {
                    this.binaryFrameSender.shutdownWrites();
                }
                Channels.flushBlocking(this.binaryFrameSender);
            }
            finally {
                if (isLast) {
                    this.binaryFrameSender = null;
                }
            }
            partialByte.clear();
        }

        @Override
        public OutputStream getSendStream() throws IOException {
            this.assertNotInFragment();
            return new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.webSocketChannel.send(WebSocketFrameType.BINARY));
        }

        @Override
        public Writer getSendWriter() throws IOException {
            this.assertNotInFragment();
            return new OutputStreamWriter((OutputStream)new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.webSocketChannel.send(WebSocketFrameType.TEXT)), UTF_8);
        }

        @Override
        public void sendObject(Object data) throws IOException, EncodeException {
            this.sendObjectImpl(data);
        }

        private void sendObjectImpl(Object o) throws IOException {
            block4: {
                try {
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                        WebSockets.sendTextBlocking(WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), WebSocketSessionRemoteEndpoint.this.webSocketChannel);
                        break block4;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                        WebSockets.sendBinaryBlocking(WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), WebSocketSessionRemoteEndpoint.this.webSocketChannel);
                        break block4;
                    }
                    throw new EncodeException(o, "No suitable encoder found");
                }
                catch (EncodeException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        @Override
        public boolean getBatchingAllowed() {
            return false;
        }

        @Override
        public void flushBatch() throws IOException {
        }

        @Override
        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSockets.sendPingBlocking(applicationData, WebSocketSessionRemoteEndpoint.this.webSocketChannel);
        }

        @Override
        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSockets.sendPongBlocking(applicationData, WebSocketSessionRemoteEndpoint.this.webSocketChannel);
        }
    }

    class AsyncWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Async {
        AsyncWebSocketSessionRemoteEndpoint() {
        }

        @Override
        public long getSendTimeout() {
            return 0L;
        }

        @Override
        public void setSendTimeout(long timeoutmillis) {
        }

        @Override
        public void sendText(String text, SendHandler handler) {
            WebSockets.sendText(text, WebSocketSessionRemoteEndpoint.this.webSocketChannel, (WebSocketCallback<Void>)new SendHandlerAdapter(handler));
        }

        @Override
        public Future<Void> sendText(String text) {
            SendResultFuture<Void> future = new SendResultFuture<Void>();
            WebSockets.sendText(text, WebSocketSessionRemoteEndpoint.this.webSocketChannel, future);
            return future;
        }

        @Override
        public Future<Void> sendBinary(ByteBuffer data) {
            SendResultFuture<Void> future = new SendResultFuture<Void>();
            WebSockets.sendBinary(data, WebSocketSessionRemoteEndpoint.this.webSocketChannel, future);
            return future;
        }

        @Override
        public void sendBinary(ByteBuffer data, SendHandler completion) {
            WebSockets.sendBinary(data, WebSocketSessionRemoteEndpoint.this.webSocketChannel, (WebSocketCallback<Void>)new SendHandlerAdapter(completion));
        }

        @Override
        public Future<Void> sendObject(Object o) {
            SendResultFuture future = new SendResultFuture();
            this.sendObjectImpl(o, future);
            return future;
        }

        @Override
        public void sendObject(Object data, SendHandler handler) {
            this.sendObjectImpl(data, new SendHandlerAdapter(handler));
        }

        private void sendObjectImpl(Object o, WebSocketCallback callback) {
            block4: {
                try {
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                        WebSockets.sendText(WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), WebSocketSessionRemoteEndpoint.this.webSocketChannel, (WebSocketCallback<Void>)callback);
                        break block4;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                        WebSockets.sendBinary(WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), WebSocketSessionRemoteEndpoint.this.webSocketChannel, (WebSocketCallback<Void>)callback);
                        break block4;
                    }
                    throw new EncodeException(o, "No suitable encoder found");
                }
                catch (EncodeException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        @Override
        public boolean getBatchingAllowed() {
            return false;
        }

        @Override
        public void flushBatch() throws IOException {
        }

        @Override
        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSockets.sendPing(applicationData, WebSocketSessionRemoteEndpoint.this.webSocketChannel, null);
        }

        @Override
        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSockets.sendPong(applicationData, WebSocketSessionRemoteEndpoint.this.webSocketChannel, null);
        }
    }
}

