/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.handshake;

import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.websocket.server.HandshakeRequest;

public final class ExchangeHandshakeRequest
implements HandshakeRequest {
    private final WebSocketHttpExchange exchange;
    private Map<String, List<String>> headers;

    public ExchangeHandshakeRequest(WebSocketHttpExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            this.headers = this.exchange.getRequestHeaders();
        }
        return this.headers;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.exchange.getUserPrincipal();
    }

    @Override
    public URI getRequestURI() {
        return URI.create(this.exchange.getRequestURI());
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.exchange.isUserInRole(role);
    }

    @Override
    public Object getHttpSession() {
        return this.exchange.getSession();
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.exchange.getRequestParameters();
    }

    @Override
    public String getQueryString() {
        return this.exchange.getQueryString();
    }
}

