/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http2;

import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.http2.Http2ClientConnection;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.util.FlexBase64;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.BoundChannel;
import org.xnio.http.HttpUpgrade;
import org.xnio.ssl.XnioSsl;

public class Http2ClearClientProvider
implements ClientProvider {
    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("h2c"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        Map<String, String> headers = this.createHeaders(options, bufferPool, uri);
        HttpUpgrade.performUpgrade(worker, bindAddress, uri, headers, (ChannelListener<? super StreamConnection>)new Http2ClearOpenListener(bufferPool, options, listener), null, options, null).addNotifier(new FailedNotifier(listener), null);
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, final URI uri, XnioIoThread ioThread, XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        if (bindAddress != null) {
            ioThread.openStreamConnection(bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort()), (ChannelListener<? super StreamConnection>)new ChannelListener<StreamConnection>(){

                @Override
                public void handleEvent(StreamConnection channel) {
                    Map headers = Http2ClearClientProvider.this.createHeaders(options, bufferPool, uri);
                    HttpUpgrade.performUpgrade(channel, uri, headers, (ChannelListener<? super StreamConnection>)new Http2ClearOpenListener(bufferPool, options, listener), null).addNotifier(new FailedNotifier(listener), null);
                }
            }, (ChannelListener<? super BoundChannel>)new ChannelListener<BoundChannel>(){

                @Override
                public void handleEvent(BoundChannel channel) {
                }
            }, options).addNotifier(new FailedNotifier(listener), null);
        } else {
            ioThread.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort()), (ChannelListener<? super StreamConnection>)new ChannelListener<StreamConnection>(){

                @Override
                public void handleEvent(StreamConnection channel) {
                    Map headers = Http2ClearClientProvider.this.createHeaders(options, bufferPool, uri);
                    HttpUpgrade.performUpgrade(channel, uri, headers, (ChannelListener<? super StreamConnection>)new Http2ClearOpenListener(bufferPool, options, listener), null).addNotifier(new FailedNotifier(listener), null);
                }
            }, (ChannelListener<? super BoundChannel>)new ChannelListener<BoundChannel>(){

                @Override
                public void handleEvent(BoundChannel channel) {
                }
            }, options).addNotifier(new FailedNotifier(listener), null);
        }
    }

    private Map<String, String> createHeaders(OptionMap options, Pool<ByteBuffer> bufferPool, URI uri) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("HTTP2-Settings", this.createSettingsFrame(options, bufferPool));
        headers.put("Upgrade", "h2c-14");
        headers.put("Connection", "Upgrade, HTTP2-Settings");
        headers.put("Host", uri.getHost());
        headers.put("X-HTTP2-connect-only", "connect");
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createSettingsFrame(OptionMap options, Pool<ByteBuffer> bufferPool) {
        Pooled<ByteBuffer> b = bufferPool.allocate();
        try {
            ByteBuffer currentBuffer = b.getResource();
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 1, options.get(UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE));
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 2, options.get(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH) != false ? 1 : 0);
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 3, options.get(UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS));
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 4, options.get(UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE));
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 5, options.get(UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE));
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_MAX_HEADER_LIST_SIZE)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 6, options.get(UndertowOptions.HTTP2_SETTINGS_MAX_HEADER_LIST_SIZE));
            }
            currentBuffer.flip();
            String string = FlexBase64.encodeString(currentBuffer, false);
            return string;
        }
        finally {
            b.free();
        }
    }

    private static void pushOption(ByteBuffer currentBuffer, int id, int value) {
        currentBuffer.put((byte)(id >> 8 & 0xFF));
        currentBuffer.put((byte)(id & 0xFF));
        currentBuffer.put((byte)(value >> 24 & 0xFF));
        currentBuffer.put((byte)(value >> 16 & 0xFF));
        currentBuffer.put((byte)(value >> 8 & 0xFF));
        currentBuffer.put((byte)(value & 0xFF));
    }

    private static class FailedNotifier
    implements IoFuture.Notifier<StreamConnection, Object> {
        private final ClientCallback<ClientConnection> listener;

        public FailedNotifier(ClientCallback<ClientConnection> listener) {
            this.listener = listener;
        }

        @Override
        public void notify(IoFuture<? extends StreamConnection> ioFuture, Object attachment) {
            if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                this.listener.failed(ioFuture.getException());
            }
        }
    }

    private static class Http2ClearOpenListener
    implements ChannelListener<StreamConnection> {
        private final Pool<ByteBuffer> bufferPool;
        private final OptionMap options;
        private final ClientCallback<ClientConnection> listener;

        public Http2ClearOpenListener(Pool<ByteBuffer> bufferPool, OptionMap options, ClientCallback<ClientConnection> listener) {
            this.bufferPool = bufferPool;
            this.options = options;
            this.listener = listener;
        }

        @Override
        public void handleEvent(StreamConnection channel) {
            Http2Channel http2Channel = new Http2Channel(channel, this.bufferPool, null, true, true, this.options);
            Http2ClientConnection http2ClientConnection = new Http2ClientConnection(http2Channel, true);
            this.listener.completed(http2ClientConnection);
        }
    }
}

