/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.util;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Iterator;
import javax.servlet.http.HttpSession;

public class SavedRequest
implements Serializable {
    private static final String SESSION_KEY = SavedRequest.class.getName();
    private final byte[] data;
    private final int dataLength;
    private final HttpString method;
    private final String requestUri;
    private final HeaderMap headerMap;

    public SavedRequest(byte[] data, int dataLength, HttpString method, String requestUri, HeaderMap headerMap) {
        this.data = data;
        this.dataLength = dataLength;
        this.method = method;
        this.requestUri = requestUri;
        this.headerMap = headerMap;
    }

    public static void trySaveRequest(HttpServerExchange exchange) {
        int maxSize = exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, 16384);
        if (maxSize > 0 && !exchange.isRequestComplete()) {
            long requestContentLength = exchange.getRequestContentLength();
            if (requestContentLength > (long)maxSize) {
                UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange.getRequestURI());
                return;
            }
            byte[] buffer = new byte[maxSize];
            int read = 0;
            int res = 0;
            InputStream in = exchange.getInputStream();
            try {
                while ((res = in.read(buffer, read, buffer.length - read)) > 0) {
                    if ((read += res) != maxSize) continue;
                    UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange.getRequestURI());
                    return;
                }
                HeaderMap headers = new HeaderMap();
                for (HeaderValues entry : exchange.getRequestHeaders()) {
                    if (entry.getHeaderName().equals(Headers.CONTENT_LENGTH) || entry.getHeaderName().equals(Headers.TRANSFER_ENCODING) || entry.getHeaderName().equals(Headers.CONNECTION)) continue;
                    headers.putAll(entry.getHeaderName(), entry);
                }
                SavedRequest request = new SavedRequest(buffer, read, exchange.getRequestMethod(), exchange.getRequestURI(), exchange.getRequestHeaders());
                ServletRequestContext sc = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                HttpSessionImpl session = sc.getCurrentServletContext().getSession(exchange, true);
                Session underlyingSession = System.getSecurityManager() == null ? session.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(session));
                underlyingSession.setAttribute(SESSION_KEY, request);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            }
        }
    }

    public static void tryRestoreRequest(HttpServerExchange exchange, HttpSession session) {
        Session underlyingSession;
        SavedRequest request;
        if (session instanceof HttpSessionImpl && (request = (SavedRequest)(underlyingSession = System.getSecurityManager() == null ? ((HttpSessionImpl)session).getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(session))).getAttribute(SESSION_KEY)) != null && request.requestUri.equals(exchange.getRequestURI()) && exchange.isRequestComplete()) {
            UndertowLogger.REQUEST_LOGGER.debugf("restoring request body for request to %s", (Object)request.requestUri);
            exchange.setRequestMethod(request.method);
            Connectors.ungetRequestBytes(exchange, new ImmediatePooled<ByteBuffer>(ByteBuffer.wrap(request.data, 0, request.dataLength)));
            underlyingSession.removeAttribute(SESSION_KEY);
            Iterator<HeaderValues> headerIterator = exchange.getRequestHeaders().iterator();
            while (headerIterator.hasNext()) {
                HeaderValues header = headerIterator.next();
                if (header.getHeaderName().equals(Headers.CONNECTION)) continue;
                headerIterator.remove();
            }
            for (HeaderValues header : request.headerMap) {
                exchange.getRequestHeaders().putAll(header.getHeaderName(), header);
            }
        }
    }
}

