/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2ProtocolUtils;
import io.undertow.protocols.http2.Http2PushBackParser;
import java.nio.ByteBuffer;

class Http2PriorityParser
extends Http2PushBackParser {
    private int streamDependency;
    private int weight;

    public Http2PriorityParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser frameHeaderParser) {
        if (resource.remaining() < 5) {
            return;
        }
        this.streamDependency = Http2ProtocolUtils.readInt(resource);
        this.weight = resource.get();
    }

    public int getWeight() {
        return this.weight;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }
}

