/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ContinueNotification;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.client.PushCallback;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Certificates;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.Transfer;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;

public final class ProxyHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(ProxyHandler.class);
    public static final String UTF_8 = "UTF-8";
    private final ProxyClient proxyClient;
    private final int maxRequestTime;
    private static final AttachmentKey<ProxyConnection> CONNECTION = AttachmentKey.create(ProxyConnection.class);
    private static final AttachmentKey<HttpServerExchange> EXCHANGE = AttachmentKey.create(HttpServerExchange.class);
    private static final AttachmentKey<XnioExecutor.Key> TIMEOUT_KEY = AttachmentKey.create(XnioExecutor.Key.class);
    private final Map<HttpString, ExchangeAttribute> requestHeaders = new CopyOnWriteMap<HttpString, ExchangeAttribute>();
    private final HttpHandler next;
    private final boolean rewriteHostHeader;
    private final boolean reuseXForwarded;

    public ProxyHandler(ProxyClient proxyClient, int maxRequestTime, HttpHandler next) {
        this(proxyClient, maxRequestTime, next, false, false);
    }

    public ProxyHandler(ProxyClient proxyClient, int maxRequestTime, HttpHandler next, boolean rewriteHostHeader, boolean reuseXForwarded) {
        this.proxyClient = proxyClient;
        this.maxRequestTime = maxRequestTime;
        this.next = next;
        this.rewriteHostHeader = rewriteHostHeader;
        this.reuseXForwarded = reuseXForwarded;
    }

    public ProxyHandler(ProxyClient proxyClient, HttpHandler next) {
        this(proxyClient, -1, next);
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        ProxyClient.ProxyTarget target = this.proxyClient.findTarget(exchange);
        if (target == null) {
            log.debugf("No proxy target for request to %s", (Object)exchange.getRequestURL());
            this.next.handleRequest(exchange);
            return;
        }
        boolean maxRetryAttempts = false;
        long timeout = this.maxRequestTime > 0 ? System.currentTimeMillis() + (long)this.maxRequestTime : 0L;
        final ProxyClientHandler clientHandler = new ProxyClientHandler(exchange, target, timeout, 0);
        if (timeout > 0L) {
            final XnioExecutor.Key key = exchange.getIoThread().executeAfter(new Runnable(){

                @Override
                public void run() {
                    clientHandler.cancel(exchange);
                }
            }, this.maxRequestTime, TimeUnit.MILLISECONDS);
            exchange.putAttachment(TIMEOUT_KEY, key);
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    key.remove();
                    nextListener.proceed();
                }
            });
        }
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : exchange.getIoThread(), clientHandler);
    }

    public ProxyHandler addRequestHeader(HttpString header, ExchangeAttribute attribute) {
        this.requestHeaders.put(header, attribute);
        return this;
    }

    public ProxyHandler addRequestHeader(HttpString header, String value) {
        this.requestHeaders.put(header, ExchangeAttributes.constant(value));
        return this;
    }

    public ProxyHandler addRequestHeader(HttpString header, String attribute, ClassLoader classLoader) {
        this.requestHeaders.put(header, ExchangeAttributes.parser(classLoader).parse(attribute));
        return this;
    }

    public ProxyHandler removeRequestHeader(HttpString header) {
        this.requestHeaders.remove(header);
        return this;
    }

    static void copyHeaders(HeaderMap to, HeaderMap from) {
        long f = from.fastIterateNonEmpty();
        while (f != -1L) {
            HeaderValues values = from.fiCurrent(f);
            if (!to.contains(values.getHeaderName())) {
                to.putAll(values.getHeaderName(), values);
            }
            f = from.fiNextNonEmpty(f);
        }
    }

    public ProxyClient getProxyClient() {
        return this.proxyClient;
    }

    private static String encodeUrlPart(String part, HttpServerExchange exchange) throws UnsupportedEncodingException {
        StringBuilder sb = null;
        Charset charset = null;
        for (int i = 0; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '*' || c == '_' || c == '/') {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(part.substring(0, i));
                charset = Charset.forName(exchange.getConnection().getUndertowOptions().get(UndertowOptions.URL_CHARSET, UTF_8));
            }
            if (c < '\u007f' && charset.name().equals(UTF_8)) {
                sb.append('%');
                sb.append(Integer.toHexString(c));
                continue;
            }
            ByteBuffer bytes = charset.encode(Character.toString(c));
            while (bytes.hasRemaining()) {
                byte b = bytes.get();
                sb.append('%');
                sb.append(Integer.toHexString(b & 0xFF));
            }
        }
        return sb == null ? part : sb.toString();
    }

    private static String realEncode(String part, int startPos) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(part.substring(0, startPos));
        int pos = startPos;
        for (int i = startPos; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (c != '/' || pos == i) continue;
            String original = part.substring(pos, i - 1);
            String encoded = URLEncoder.encode(original, UTF_8);
            sb.append(encoded);
            sb.append('/');
            pos = i + 1;
        }
        String original = part.substring(pos);
        String encoded = URLEncoder.encode(original, UTF_8);
        sb.append(encoded);
        return sb.toString();
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final List<URI> uris;

        private Wrapper(List<URI> uris) {
            this.uris = uris;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            LoadBalancingProxyClient loadBalancingProxyClient = new LoadBalancingProxyClient();
            for (URI url : this.uris) {
                loadBalancingProxyClient.addHost(url);
            }
            return new ProxyHandler(loadBalancingProxyClient, handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "reverse-proxy";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("hosts", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("hosts");
        }

        @Override
        public String defaultParameter() {
            return "hosts";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            String[] hosts = (String[])config.get("hosts");
            ArrayList<URI> uris = new ArrayList<URI>();
            for (String host : hosts) {
                try {
                    uris.add(new URI(host));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Wrapper(uris);
        }
    }

    private static final class ClosingExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final Closeable[] toClose;

        private ClosingExceptionHandler(Closeable ... toClose) {
            this.toClose = toClose;
        }

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)channel);
            IoUtils.safeClose(this.toClose);
        }
    }

    private static final class IoExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final HttpServerExchange exchange;
        private final ClientConnection clientConnection;

        private IoExceptionHandler(HttpServerExchange exchange, ClientConnection clientConnection) {
            this.exchange = exchange;
            this.clientConnection = clientConnection;
        }

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)channel);
            if (this.exchange.isResponseStarted()) {
                IoUtils.safeClose((Closeable)this.clientConnection);
                UndertowLogger.REQUEST_IO_LOGGER.debug("Exception reading from target server", exception);
                if (!this.exchange.isResponseStarted()) {
                    this.exchange.setResponseCode(500);
                    this.exchange.endExchange();
                } else {
                    IoUtils.safeClose((Closeable)this.exchange.getConnection());
                }
            } else {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
            }
        }
    }

    private static final class HTTPTrailerChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private final Attachable source;
        private final Attachable target;

        private HTTPTrailerChannelListener(Attachable source, Attachable target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            HeaderMap trailers = this.source.getAttachment(HttpAttachments.REQUEST_TRAILERS);
            if (trailers != null) {
                this.target.putAttachment(HttpAttachments.RESPONSE_TRAILERS, trailers);
            }
            try {
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            channel.suspendWrites();
                            channel.getWriteSetter().set(null);
                        }
                    }, ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeWrites();
                } else {
                    channel.getWriteSetter().set(null);
                    channel.shutdownWrites();
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    private static final class ResponseCallback
    implements ClientCallback<ClientExchange> {
        private final HttpServerExchange exchange;

        private ResponseCallback(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void completed(final ClientExchange result) {
            ClientResponse response = result.getResponse();
            HeaderMap inboundResponseHeaders = response.getResponseHeaders();
            HeaderMap outboundResponseHeaders = this.exchange.getResponseHeaders();
            this.exchange.setResponseCode(response.getResponseCode());
            ProxyHandler.copyHeaders(outboundResponseHeaders, inboundResponseHeaders);
            if (this.exchange.isUpgrade()) {
                this.exchange.upgradeChannel(new HttpUpgradeListener(){

                    @Override
                    public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                        StreamConnection clientChannel = null;
                        try {
                            clientChannel = result.getConnection().performUpgrade();
                            ClosingExceptionHandler handler = new ClosingExceptionHandler(new Closeable[]{streamConnection, clientChannel});
                            Transfer.initiateTransfer(clientChannel.getSourceChannel(), streamConnection.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.flushingChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler()), handler, handler, result.getConnection().getBufferPool());
                            Transfer.initiateTransfer(streamConnection.getSourceChannel(), clientChannel.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.flushingChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler()), handler, handler, result.getConnection().getBufferPool());
                        }
                        catch (IOException e) {
                            IoUtils.safeClose(streamConnection, clientChannel);
                        }
                    }
                });
            }
            IoExceptionHandler handler = new IoExceptionHandler(this.exchange, result.getConnection());
            Transfer.initiateTransfer(result.getResponseChannel(), this.exchange.getResponseChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(result, this.exchange), handler, handler, this.exchange.getConnection().getBufferPool());
        }

        @Override
        public void failed(IOException e) {
            UndertowLogger.PROXY_REQUEST_LOGGER.proxyRequestFailed(this.exchange.getRequestURI(), e);
            if (!this.exchange.isResponseStarted()) {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
            } else {
                IoUtils.safeClose((Closeable)this.exchange.getConnection());
            }
        }
    }

    private static class ProxyAction
    implements Runnable {
        private final ProxyConnection clientConnection;
        private final HttpServerExchange exchange;
        private final Map<HttpString, ExchangeAttribute> requestHeaders;
        private final boolean rewriteHostHeader;
        private final boolean reuseXForwarded;

        public ProxyAction(ProxyConnection clientConnection, HttpServerExchange exchange, Map<HttpString, ExchangeAttribute> requestHeaders, boolean rewriteHostHeader, boolean reuseXForwarded) {
            this.clientConnection = clientConnection;
            this.exchange = exchange;
            this.requestHeaders = requestHeaders;
            this.rewriteHostHeader = rewriteHostHeader;
            this.reuseXForwarded = reuseXForwarded;
        }

        @Override
        public void run() {
            ClientRequest request = new ClientRequest();
            StringBuilder requestURI = new StringBuilder();
            try {
                String qs;
                if (this.exchange.getRelativePath().isEmpty()) {
                    requestURI.append(ProxyHandler.encodeUrlPart(this.clientConnection.getTargetPath(), this.exchange));
                } else if (this.clientConnection.getTargetPath().endsWith("/")) {
                    requestURI.append(this.clientConnection.getTargetPath().substring(0, this.clientConnection.getTargetPath().length() - 1));
                    requestURI.append(ProxyHandler.encodeUrlPart(this.exchange.getRelativePath(), this.exchange));
                } else {
                    requestURI = requestURI.append(this.clientConnection.getTargetPath());
                    requestURI.append(ProxyHandler.encodeUrlPart(this.exchange.getRelativePath(), this.exchange));
                }
                boolean first = true;
                if (!this.exchange.getPathParameters().isEmpty()) {
                    requestURI.append(';');
                    for (Map.Entry<String, Deque<String>> entry : this.exchange.getPathParameters().entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            requestURI.append('&');
                        }
                        for (String val : entry.getValue()) {
                            requestURI.append(URLEncoder.encode(entry.getKey(), ProxyHandler.UTF_8));
                            requestURI.append('=');
                            requestURI.append(URLEncoder.encode(val, ProxyHandler.UTF_8));
                        }
                    }
                }
                if ((qs = this.exchange.getQueryString()) != null && !qs.isEmpty()) {
                    requestURI.append('?');
                    requestURI.append(qs);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
                return;
            }
            request.setPath(requestURI.toString()).setMethod(this.exchange.getRequestMethod());
            HeaderMap inboundRequestHeaders = this.exchange.getRequestHeaders();
            HeaderMap outboundRequestHeaders = request.getRequestHeaders();
            ProxyHandler.copyHeaders(outboundRequestHeaders, inboundRequestHeaders);
            if (!this.exchange.isPersistent()) {
                outboundRequestHeaders.put(Headers.CONNECTION, "keep-alive");
            }
            for (Map.Entry<HttpString, ExchangeAttribute> entry : this.requestHeaders.entrySet()) {
                String headerValue = entry.getValue().readAttribute(this.exchange);
                if (headerValue == null || headerValue.isEmpty()) {
                    outboundRequestHeaders.remove(entry.getKey());
                    continue;
                }
                outboundRequestHeaders.put(entry.getKey(), headerValue.replace('\n', ' '));
            }
            SocketAddress address = this.exchange.getConnection().getPeerAddress();
            String remoteHost = address != null && address instanceof InetSocketAddress ? ((InetSocketAddress)address).getHostString() : "localhost";
            request.putAttachment(ProxiedRequestAttachments.REMOTE_HOST, remoteHost);
            if (this.reuseXForwarded && request.getRequestHeaders().contains(Headers.X_FORWARDED_FOR)) {
                String current = request.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR);
                if (current == null || current.isEmpty()) {
                    request.getRequestHeaders().put(Headers.X_FORWARDED_FOR, remoteHost);
                } else {
                    request.getRequestHeaders().put(Headers.X_FORWARDED_FOR, current + "," + remoteHost);
                }
            } else {
                request.getRequestHeaders().put(Headers.X_FORWARDED_FOR, remoteHost);
            }
            if (!this.exchange.getConnection().isPushSupported() && this.clientConnection.getConnection().isPushSupported()) {
                request.getRequestHeaders().put(Headers.X_DISABLE_PUSH, "true");
            }
            String proto = this.exchange.getRequestScheme().equals("https") ? "https" : "http";
            request.getRequestHeaders().put(Headers.X_FORWARDED_PROTO, proto);
            request.putAttachment(ProxiedRequestAttachments.IS_SSL, proto.equals("https"));
            String hostName = this.exchange.getHostName();
            request.getRequestHeaders().put(Headers.X_FORWARDED_HOST, hostName);
            request.putAttachment(ProxiedRequestAttachments.SERVER_NAME, hostName);
            int port = this.exchange.getConnection().getLocalAddress(InetSocketAddress.class).getPort();
            request.getRequestHeaders().put(Headers.X_FORWARDED_PORT, port);
            request.putAttachment(ProxiedRequestAttachments.SERVER_PORT, port);
            SSLSessionInfo sslSessionInfo = this.exchange.getConnection().getSslSessionInfo();
            if (sslSessionInfo != null) {
                try {
                    X509Certificate[] peerCertificates = sslSessionInfo.getPeerCertificateChain();
                    if (peerCertificates.length > 0) {
                        request.putAttachment(ProxiedRequestAttachments.SSL_CERT, Certificates.toPem(peerCertificates[0]));
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                }
                catch (CertificateEncodingException e) {
                }
                catch (RenegotiationRequiredException e) {
                    // empty catch block
                }
                request.putAttachment(ProxiedRequestAttachments.SSL_CYPHER, sslSessionInfo.getCipherSuite());
                request.putAttachment(ProxiedRequestAttachments.SSL_SESSION_ID, sslSessionInfo.getSessionId());
            }
            if (this.rewriteHostHeader) {
                InetSocketAddress targetAddress = this.clientConnection.getConnection().getPeerAddress(InetSocketAddress.class);
                request.getRequestHeaders().put(Headers.HOST, targetAddress.getHostString() + ":" + targetAddress.getPort());
                request.getRequestHeaders().put(Headers.X_FORWARDED_HOST, this.exchange.getRequestHeaders().getFirst(Headers.HOST));
            }
            this.clientConnection.getConnection().sendRequest(request, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(final ClientExchange result) {
                    result.putAttachment(EXCHANGE, ProxyAction.this.exchange);
                    boolean requiresContinueResponse = HttpContinue.requiresContinueResponse(ProxyAction.this.exchange);
                    if (requiresContinueResponse) {
                        result.setContinueHandler(new ContinueNotification(){

                            @Override
                            public void handleContinue(ClientExchange clientExchange) {
                                HttpContinue.sendContinueResponse(ProxyAction.this.exchange, new IoCallback(){

                                    @Override
                                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                                    }

                                    @Override
                                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                        IoUtils.safeClose((Closeable)ProxyAction.this.clientConnection.getConnection());
                                        exchange.endExchange();
                                    }
                                });
                            }
                        });
                    }
                    if (ProxyAction.this.exchange.getConnection().isPushSupported() && result.getConnection().isPushSupported()) {
                        result.setPushHandler(new PushCallback(){

                            @Override
                            public boolean handlePush(ClientExchange originalRequest, final ClientExchange pushedRequest) {
                                final ClientRequest request = pushedRequest.getRequest();
                                ProxyAction.this.exchange.getConnection().pushResource(request.getPath(), request.getMethod(), request.getRequestHeaders(), new HttpHandler(){

                                    @Override
                                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                                        String path = request.getPath();
                                        int i = path.indexOf("?");
                                        if (i > 0) {
                                            path = path.substring(0, i);
                                        }
                                        exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(new ProxyConnection(pushedRequest.getConnection(), path), exchange, ProxyAction.this.requestHeaders, ProxyAction.this.rewriteHostHeader, ProxyAction.this.reuseXForwarded));
                                    }
                                });
                                return true;
                            }
                        });
                    }
                    result.setResponseListener(new ResponseCallback(ProxyAction.this.exchange));
                    final IoExceptionHandler handler = new IoExceptionHandler(ProxyAction.this.exchange, ProxyAction.this.clientConnection.getConnection());
                    if (requiresContinueResponse) {
                        try {
                            if (!result.getRequestChannel().flush()) {
                                result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                                    @Override
                                    public void handleEvent(StreamSinkChannel channel) {
                                        Transfer.initiateTransfer(ProxyAction.this.exchange.getRequestChannel(), result.getRequestChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(ProxyAction.this.exchange, result), handler, handler, ProxyAction.this.exchange.getConnection().getBufferPool());
                                    }
                                }, handler));
                                result.getRequestChannel().resumeWrites();
                                return;
                            }
                        }
                        catch (IOException e) {
                            handler.handleException(result.getRequestChannel(), e);
                        }
                    }
                    Transfer.initiateTransfer(ProxyAction.this.exchange.getRequestChannel(), result.getRequestChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(ProxyAction.this.exchange, result), handler, handler, ProxyAction.this.exchange.getConnection().getBufferPool());
                }

                @Override
                public void failed(IOException e) {
                    UndertowLogger.PROXY_REQUEST_LOGGER.proxyRequestFailed(ProxyAction.this.exchange.getRequestURI(), e);
                    if (!ProxyAction.this.exchange.isResponseStarted()) {
                        ProxyAction.this.exchange.setResponseCode(503);
                        ProxyAction.this.exchange.endExchange();
                    } else {
                        IoUtils.safeClose((Closeable)ProxyAction.this.exchange.getConnection());
                    }
                }
            });
        }
    }

    private final class ProxyClientHandler
    implements ProxyCallback<ProxyConnection>,
    Runnable {
        private int tries;
        private final long timeout;
        private final int maxRetryAttempts;
        private final HttpServerExchange exchange;
        private ProxyClient.ProxyTarget target;

        ProxyClientHandler(HttpServerExchange exchange, ProxyClient.ProxyTarget target, long timeout, int maxRetryAttempts) {
            this.exchange = exchange;
            this.timeout = timeout;
            this.maxRetryAttempts = maxRetryAttempts;
            this.target = target;
        }

        @Override
        public void run() {
            ProxyHandler.this.proxyClient.getConnection(this.target, this.exchange, this, -1L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void completed(HttpServerExchange exchange, ProxyConnection connection) {
            exchange.putAttachment(CONNECTION, connection);
            exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(connection, exchange, ProxyHandler.this.requestHeaders, ProxyHandler.this.rewriteHostHeader, ProxyHandler.this.reuseXForwarded));
        }

        @Override
        public void failed(HttpServerExchange exchange) {
            long time = System.currentTimeMillis();
            if (this.tries++ < this.maxRetryAttempts) {
                if (this.timeout > 0L && time > this.timeout) {
                    this.cancel(exchange);
                } else {
                    this.target = ProxyHandler.this.proxyClient.findTarget(exchange);
                    if (this.target != null) {
                        long remaining = this.timeout > 0L ? this.timeout - time : -1L;
                        ProxyHandler.this.proxyClient.getConnection(this.target, exchange, this, remaining, TimeUnit.MILLISECONDS);
                    } else {
                        this.couldNotResolveBackend(exchange);
                    }
                }
            } else {
                this.couldNotResolveBackend(exchange);
            }
        }

        @Override
        public void queuedRequestFailed(HttpServerExchange exchange) {
            this.failed(exchange);
        }

        @Override
        public void couldNotResolveBackend(HttpServerExchange exchange) {
            if (exchange.isResponseStarted()) {
                IoUtils.safeClose((Closeable)exchange.getConnection());
            } else {
                exchange.setResponseCode(503);
                exchange.endExchange();
            }
        }

        void cancel(HttpServerExchange exchange) {
            ProxyConnection connectionAttachment = (ProxyConnection)exchange.getAttachment(CONNECTION);
            if (connectionAttachment != null) {
                ClientConnection clientConnection = connectionAttachment.getConnection();
                UndertowLogger.REQUEST_LOGGER.timingOutRequest(clientConnection.getPeerAddress() + "" + exchange.getRequestURI());
                IoUtils.safeClose((Closeable)clientConnection);
            } else {
                UndertowLogger.REQUEST_LOGGER.timingOutRequest(exchange.getRequestURI());
            }
            if (exchange.isResponseStarted()) {
                IoUtils.safeClose((Closeable)exchange.getConnection());
            } else {
                exchange.setResponseCode(503);
                exchange.endExchange();
            }
        }
    }
}

