/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterProxyClient;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterProxyTarget;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodeHealthChecker;
import io.undertow.server.handlers.proxy.mod_cluster.VirtualHost;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Headers;
import io.undertow.util.PathMatcher;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.xnio.Pool;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.ssl.XnioSsl;

class ModClusterContainer {
    private final ConcurrentMap<String, Balancer> balancers = new CopyOnWriteMap<String, Balancer>();
    private final ConcurrentMap<String, Node> nodes = new CopyOnWriteMap<String, Node>();
    private final ConcurrentMap<String, VirtualHost> hosts = new CopyOnWriteMap<String, VirtualHost>();
    private final LRUCache<String, String> failoverDomains = new LRUCache(100, 300000);
    private final ConcurrentMap<XnioIoThread, HealthCheckTask> healthChecks = new CopyOnWriteMap<XnioIoThread, HealthCheckTask>();
    private final UpdateLoadTask updateLoadTask = new UpdateLoadTask();
    private final XnioSsl xnioSsl;
    private final UndertowClient client;
    private final ProxyClient proxyClient;
    private final ModCluster modCluster;
    private final NodeHealthChecker healthChecker;
    private final long removeBrokenNodesThreshold;

    ModClusterContainer(ModCluster modCluster, XnioSsl xnioSsl, UndertowClient client) {
        this.xnioSsl = xnioSsl;
        this.client = client;
        this.modCluster = modCluster;
        this.healthChecker = modCluster.getHealthChecker();
        this.proxyClient = new ModClusterProxyClient(null, this);
        this.removeBrokenNodesThreshold = ModClusterContainer.removeThreshold(modCluster.getHealthCheckInterval(), modCluster.getRemoveBrokenNodes());
    }

    String getServerID() {
        return this.modCluster.getServerID();
    }

    UndertowClient getClient() {
        return this.client;
    }

    XnioSsl getXnioSsl() {
        return this.xnioSsl;
    }

    public ProxyClient getProxyClient() {
        return this.proxyClient;
    }

    Collection<Balancer> getBalancers() {
        return Collections.unmodifiableCollection(this.balancers.values());
    }

    Collection<Node> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    Node getNode(String jvmRoute) {
        return (Node)this.nodes.get(jvmRoute);
    }

    public ModClusterProxyTarget findTarget(HttpServerExchange exchange) {
        PathMatcher.PathMatch<VirtualHost.HostEntry> entry = this.mapVirtualHost(exchange);
        if (entry == null) {
            return null;
        }
        for (Balancer balancer : this.balancers.values()) {
            String id;
            String jvmRoute;
            String jvmRoute2;
            Map<String, Cookie> cookies = exchange.getRequestCookies();
            if (!balancer.isStickySession()) continue;
            if (cookies.containsKey(balancer.getStickySessionCookie()) && (jvmRoute2 = ModClusterContainer.getJVMRoute(cookies.get(balancer.getStickySessionCookie()).getValue())) != null) {
                return new ModClusterProxyTarget.ExistingSessionTarget(jvmRoute2, entry.getValue(), this, balancer.isStickySessionForce());
            }
            if (!exchange.getPathParameters().containsKey(balancer.getStickySessionPath()) || (jvmRoute = ModClusterContainer.getJVMRoute(id = exchange.getPathParameters().get(balancer.getStickySessionPath()).getFirst())) == null) continue;
            return new ModClusterProxyTarget.ExistingSessionTarget(jvmRoute, entry.getValue(), this, balancer.isStickySessionForce());
        }
        return new ModClusterProxyTarget.BasicTarget(entry.getValue(), this);
    }

    public synchronized boolean addNode(NodeConfig config, Balancer.BalancerBuilder balancerConfig, XnioIoThread ioThread, Pool<ByteBuffer> bufferPool) {
        String balancerRef;
        Balancer balancer;
        String jvmRoute = config.getJvmRoute();
        Node existing = (Node)this.nodes.get(jvmRoute);
        if (existing != null) {
            if (config.getConnectionURI().equals(existing.getNodeConfig().getConnectionURI())) {
                existing.resetState();
                return true;
            }
            existing.markRemoved();
            this.removeNode(existing);
            if (!existing.isInErrorState()) {
                return false;
            }
        }
        if ((balancer = (Balancer)this.balancers.get(balancerRef = config.getBalancer())) == null) {
            balancer = balancerConfig.build();
            this.balancers.put(balancerRef, balancer);
        }
        Node node = new Node(config, balancer, ioThread, bufferPool, this);
        this.nodes.put(jvmRoute, node);
        this.scheduleHealthCheck(node, ioThread);
        if (this.updateLoadTask.cancelKey == null) {
            this.updateLoadTask.cancelKey = ioThread.executeAtInterval(this.updateLoadTask, this.modCluster.getHealthCheckInterval(), TimeUnit.MILLISECONDS);
        }
        this.failoverDomains.remove(node.getJvmRoute());
        UndertowLogger.ROOT_LOGGER.infof("registering node %s, connection: %s", (Object)jvmRoute, (Object)config.getConnectionURI());
        return true;
    }

    public synchronized boolean enableNode(String jvmRoute) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            for (Context context : node.getContexts()) {
                context.enable();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean disableNode(String jvmRoute) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            for (Context context : node.getContexts()) {
                context.disable();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean stopNode(String jvmRoute) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            for (Context context : node.getContexts()) {
                context.stop();
            }
            return true;
        }
        return false;
    }

    public synchronized Node removeNode(String jvmRoute) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            this.removeNode(node);
        }
        return node;
    }

    protected void removeNode(Node node) {
        this.removeNode(node, false);
    }

    protected synchronized void removeNode(Node node, boolean onlyInError) {
        if (onlyInError && !node.isInErrorState()) {
            return;
        }
        String jvmRoute = node.getJvmRoute();
        node.markRemoved();
        if (this.nodes.remove(jvmRoute, node)) {
            UndertowLogger.ROOT_LOGGER.infof("removing node %s", (Object)jvmRoute);
            node.markRemoved();
            this.removeHealthCheck(node, node.getIoThread());
            for (Context context : node.getContexts()) {
                this.removeContext(context.getPath(), node, context.getVirtualHosts());
            }
            String domain = node.getNodeConfig().getDomain();
            if (domain != null) {
                this.failoverDomains.add(node.getJvmRoute(), domain);
            }
            String balancerName = node.getBalancer().getName();
            for (Node other : this.nodes.values()) {
                if (!other.getBalancer().getName().equals(balancerName)) continue;
                return;
            }
            this.balancers.remove(balancerName);
        }
        if (this.nodes.size() == 0) {
            this.updateLoadTask.cancelKey.remove();
            this.updateLoadTask.cancelKey = null;
        }
    }

    public synchronized boolean enableContext(String contextPath, String jvmRoute, List<String> aliases) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            Context context = node.getContext(contextPath, aliases);
            if (context == null) {
                context = node.registerContext(contextPath, aliases);
                UndertowLogger.ROOT_LOGGER.infof("registering context %s, for node %s, with aliases %s", (Object)contextPath, (Object)jvmRoute, (Object)aliases);
                for (String alias : aliases) {
                    VirtualHost virtualHost = (VirtualHost)this.hosts.get(alias);
                    if (virtualHost == null) {
                        virtualHost = new VirtualHost();
                        this.hosts.put(alias, virtualHost);
                    }
                    virtualHost.registerContext(contextPath, jvmRoute, context);
                }
            }
            context.enable();
            return true;
        }
        return false;
    }

    synchronized boolean disableContext(String contextPath, String jvmRoute, List<String> aliases) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            node.disableContext(contextPath, aliases);
            return true;
        }
        return false;
    }

    synchronized int stopContext(String contextPath, String jvmRoute, List<String> aliases) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            return node.stopContext(contextPath, aliases);
        }
        return -1;
    }

    synchronized boolean removeContext(String contextPath, String jvmRoute, List<String> aliases) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            return this.removeContext(contextPath, node, aliases);
        }
        return false;
    }

    public synchronized boolean removeContext(String contextPath, Node node, List<String> aliases) {
        if (node == null) {
            return false;
        }
        String jvmRoute = node.getJvmRoute();
        UndertowLogger.ROOT_LOGGER.infof("unregistering context '%s' from node '%s'", (Object)contextPath, (Object)jvmRoute);
        Context context = node.removeContext(contextPath, aliases);
        if (context == null) {
            return false;
        }
        context.stop();
        for (String alias : context.getVirtualHosts()) {
            VirtualHost virtualHost = (VirtualHost)this.hosts.get(alias);
            if (virtualHost == null) continue;
            virtualHost.removeContext(contextPath, jvmRoute, context);
            if (!virtualHost.isEmpty()) continue;
            this.hosts.remove(alias);
        }
        return true;
    }

    Context findNewNode(VirtualHost.HostEntry entry) {
        return ModClusterContainer.electNode(entry.getContexts(), false, null);
    }

    Context findFailoverNode(VirtualHost.HostEntry entry, String domain, String jvmRoute, boolean forceStickySession) {
        Context context;
        String failOverDomain = null;
        if (domain == null) {
            Node node = (Node)this.nodes.get(jvmRoute);
            if (node != null) {
                failOverDomain = node.getNodeConfig().getDomain();
            }
            if (failOverDomain == null) {
                failOverDomain = this.failoverDomains.get(jvmRoute);
            }
        } else {
            failOverDomain = domain;
        }
        Collection<Context> contexts = entry.getContexts();
        if (failOverDomain != null && (context = ModClusterContainer.electNode(contexts, true, failOverDomain)) != null) {
            return context;
        }
        if (forceStickySession) {
            return null;
        }
        return ModClusterContainer.electNode(contexts, false, null);
    }

    private PathMatcher.PathMatch<VirtualHost.HostEntry> mapVirtualHost(HttpServerExchange exchange) {
        String hostName = exchange.getRequestHeaders().getFirst(Headers.HOST);
        if (hostName != null) {
            VirtualHost host;
            String context = exchange.getRelativePath();
            int i = hostName.indexOf(":");
            if (i > 0) {
                host = (VirtualHost)this.hosts.get(hostName.substring(0, i));
                if (host == null) {
                    host = (VirtualHost)this.hosts.get(hostName);
                }
            } else {
                host = (VirtualHost)this.hosts.get(hostName);
            }
            if (host == null) {
                return null;
            }
            PathMatcher.PathMatch<VirtualHost.HostEntry> result = host.match(context);
            if (result.getValue() == null) {
                return null;
            }
            return result;
        }
        return null;
    }

    static String getJVMRoute(String sessionId) {
        int index = sessionId.indexOf(46);
        if (index == -1) {
            return null;
        }
        String route = sessionId.substring(index + 1);
        if ((index = route.indexOf(46)) != -1) {
            route = route.substring(0, index);
        }
        return route;
    }

    static Context electNode(Iterable<Context> contexts, boolean existingSession, String domain) {
        Context elected = null;
        Node candidate = null;
        boolean candidateHotStandby = false;
        for (Context context : contexts) {
            if (!context.checkAvailable(existingSession)) continue;
            Node node = context.getNode();
            boolean hotStandby = node.isHotStandby();
            if (domain != null && !domain.equals(node.getNodeConfig().getDomain())) continue;
            if (candidate != null) {
                int lbStatus2;
                int lbStatus1;
                if (candidateHotStandby) {
                    if (hotStandby) {
                        if (candidate.getElectedDiff() <= node.getElectedDiff()) continue;
                        candidate = node;
                        elected = context;
                        continue;
                    }
                    candidate = node;
                    elected = context;
                    candidateHotStandby = hotStandby;
                    continue;
                }
                if (hotStandby || (lbStatus1 = candidate.getLoadStatus()) <= (lbStatus2 = node.getLoadStatus())) continue;
                candidate = node;
                elected = context;
                candidateHotStandby = false;
                continue;
            }
            candidate = node;
            elected = context;
            candidateHotStandby = hotStandby;
        }
        if (candidate != null) {
            candidate.elected();
        }
        return elected;
    }

    void scheduleHealthCheck(Node node, XnioIoThread ioThread) {
        assert (Thread.holdsLock(this));
        HealthCheckTask task = (HealthCheckTask)this.healthChecks.get(ioThread);
        if (task == null) {
            task = new HealthCheckTask(this.removeBrokenNodesThreshold, this.healthChecker);
            this.healthChecks.put(ioThread, task);
            task.cancelKey = ioThread.executeAtInterval(task, this.modCluster.getHealthCheckInterval(), TimeUnit.MILLISECONDS);
        }
        task.nodes.add(node);
    }

    void removeHealthCheck(Node node, XnioIoThread ioThread) {
        assert (Thread.holdsLock(this));
        HealthCheckTask task = (HealthCheckTask)this.healthChecks.get(ioThread);
        if (task == null) {
            return;
        }
        task.nodes.remove(node);
        if (task.nodes.size() == 0) {
            this.healthChecks.remove(ioThread);
            task.cancelKey.remove();
        }
    }

    static long removeThreshold(long healthChecks, long removeBrokenNodes) {
        if (healthChecks > 0L && removeBrokenNodes > 0L) {
            long threshold = removeBrokenNodes / healthChecks;
            if (threshold > 1000L) {
                return 1000L;
            }
            if (threshold < 1L) {
                return 1L;
            }
            return threshold;
        }
        return -1L;
    }

    class UpdateLoadTask
    implements Runnable {
        private volatile XnioExecutor.Key cancelKey;

        UpdateLoadTask() {
        }

        @Override
        public void run() {
            for (Node node : ModClusterContainer.this.nodes.values()) {
                node.resetLbStatus();
            }
        }
    }

    static class HealthCheckTask
    implements Runnable {
        private final long threshold;
        private final NodeHealthChecker healthChecker;
        private final ArrayList<Node> nodes = new ArrayList();
        private volatile XnioExecutor.Key cancelKey;

        HealthCheckTask(long threshold, NodeHealthChecker healthChecker) {
            this.threshold = threshold;
            this.healthChecker = healthChecker;
        }

        @Override
        public void run() {
            for (Node node : this.nodes) {
                node.checkHealth(this.threshold, this.healthChecker);
            }
        }
    }
}

