/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ParseTimeoutUpdater;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.protocol.http.HttpTransferEncoding;
import io.undertow.server.protocol.http.ParseState;
import io.undertow.server.protocol.http2.Http2ReceiveListener;
import io.undertow.util.ClosingChannelExceptionHandler;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;

final class HttpReadListener
implements ChannelListener<ConduitStreamSourceChannel>,
Runnable {
    private static final HttpString PRI = new HttpString("PRI");
    private static final byte[] PRI_EXPECTED = new byte[]{83, 77, 13, 10, 13, 10};
    private static final String BAD_REQUEST = "HTTP/1.1 400 Bad Request\r\nContent-Length: 0\r\nConnection: close\r\n\r\n";
    private final HttpServerConnection connection;
    private final ParseState state = new ParseState();
    private final HttpRequestParser parser;
    private HttpServerExchange httpServerExchange;
    private int read = 0;
    private final int maxRequestSize;
    private final long maxEntitySize;
    private final boolean recordRequestStartTime;
    private volatile int requestState;
    private static final AtomicIntegerFieldUpdater<HttpReadListener> requestStateUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpReadListener.class, "requestState");
    private final ConnectorStatisticsImpl connectorStatistics;
    private ParseTimeoutUpdater parseTimeoutUpdater;

    HttpReadListener(HttpServerConnection connection, HttpRequestParser parser, ConnectorStatisticsImpl connectorStatistics) {
        this.connection = connection;
        this.parser = parser;
        this.connectorStatistics = connectorStatistics;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 0x100000);
        this.maxEntitySize = connection.getUndertowOptions().get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.recordRequestStartTime = connection.getUndertowOptions().get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
        int requestParseTimeout = connection.getUndertowOptions().get(UndertowOptions.REQUEST_PARSE_TIMEOUT, -1);
        int requestIdleTimeout = connection.getUndertowOptions().get(UndertowOptions.NO_REQUEST_TIMEOUT, -1);
        if (requestIdleTimeout < 0 && requestParseTimeout < 0) {
            this.parseTimeoutUpdater = null;
        } else {
            this.parseTimeoutUpdater = new ParseTimeoutUpdater(connection, requestParseTimeout, requestIdleTimeout);
            connection.addCloseListener(this.parseTimeoutUpdater);
        }
    }

    public void newRequest() {
        this.state.reset();
        this.read = 0;
        this.httpServerExchange = new HttpServerExchange(this.connection, this.maxEntitySize);
        if (this.parseTimeoutUpdater != null) {
            this.parseTimeoutUpdater.connectionIdle();
        }
        this.connection.setCurrentExchange(null);
    }

    @Override
    public void handleEvent(ConduitStreamSourceChannel channel) {
        while (requestStateUpdater.get(this) != 0) {
            if (!requestStateUpdater.compareAndSet(this, 1, 2)) continue;
            channel.suspendReads();
            requestStateUpdater.set(this, 1);
            return;
        }
        this.handleEventWithNoRunningRequest(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEventWithNoRunningRequest(ConduitStreamSourceChannel channel) {
        Pooled<ByteBuffer> existing = this.connection.getExtraBytes();
        if (existing == null && this.connection.getOriginalSourceConduit().isReadShutdown() || this.connection.getOriginalSinkConduit().isWriteShutdown()) {
            IoUtils.safeClose((Closeable)this.connection);
            channel.suspendReads();
            return;
        }
        Pooled<ByteBuffer> pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = pooled.getResource();
        boolean free = true;
        try {
            boolean bytesRead = false;
            do {
                int total;
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.debug("Error reading request", e);
                        IoUtils.safeClose((Closeable)this.connection);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res <= 0) {
                    if (bytesRead && this.parseTimeoutUpdater != null) {
                        this.parseTimeoutUpdater.failedParse();
                    }
                    this.handleFailedRead(channel, res);
                    return;
                }
                bytesRead = true;
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                int begin = buffer.remaining();
                this.parser.handle(buffer, this.state, this.httpServerExchange);
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes(pooled);
                }
                this.read = total = this.read + (begin - buffer.remaining());
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)this.connection);
                return;
            } while (!this.state.isComplete());
            if (this.parseTimeoutUpdater != null) {
                this.parseTimeoutUpdater.requestStarted();
            }
            HttpServerExchange httpServerExchange = this.httpServerExchange;
            httpServerExchange.setRequestScheme(this.connection.getSslSession() != null ? "https" : "http");
            this.httpServerExchange = null;
            requestStateUpdater.set(this, 1);
            if (httpServerExchange.getProtocol() == Protocols.HTTP_2_0 && httpServerExchange.getRequestMethod().equals(PRI) && this.connection.getUndertowOptions().get(UndertowOptions.ENABLE_HTTP2, false)) {
                this.handleHttp2PriorKnowledge(this.connection.getChannel(), this.connection, pooled);
                free = false;
                return;
            }
            HttpTransferEncoding.setupRequest(httpServerExchange);
            if (this.recordRequestStartTime) {
                Connectors.setRequestStartTime(httpServerExchange);
            }
            this.connection.setCurrentExchange(httpServerExchange);
            if (this.connectorStatistics != null) {
                this.connectorStatistics.setup(httpServerExchange);
            }
            Connectors.executeRootHandler(this.connection.getRootHandler(), httpServerExchange);
        }
        catch (Exception e) {
            this.sendBadRequestAndClose(this.connection.getChannel(), e);
            return;
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private void handleFailedRead(ConduitStreamSourceChannel channel, int res) {
        if (res == 0) {
            channel.setReadListener(this);
            channel.resumeReads();
        } else if (res == -1) {
            IoUtils.safeClose((Closeable)this.connection);
        }
    }

    private void sendBadRequestAndClose(final StreamConnection connection, Exception exception) {
        UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(exception);
        connection.getSourceChannel().suspendReads();
        new StringWriteChannelListener(BAD_REQUEST){

            @Override
            protected void writeDone(StreamSinkChannel c) {
                super.writeDone(c);
                c.suspendWrites();
                IoUtils.safeClose((Closeable)connection);
            }

            @Override
            protected void handleError(StreamSinkChannel channel, IOException e) {
                IoUtils.safeClose((Closeable)connection);
            }
        }.setup(connection.getSinkChannel());
    }

    public void exchangeComplete(final HttpServerExchange exchange) {
        this.connection.clearChannel();
        final HttpServerConnection connection = this.connection;
        if (exchange.isPersistent() && !this.isUpgradeOrConnect(exchange)) {
            StreamConnection channel = connection.getChannel();
            if (connection.getExtraBytes() == null) {
                if (exchange.isInIoThread()) {
                    this.newRequest();
                    channel.getSourceChannel().setReadListener(this);
                    channel.getSourceChannel().resumeReads();
                    requestStateUpdater.set(this, 0);
                } else {
                    do {
                        if (!connection.getOriginalSourceConduit().isReadShutdown() && !connection.getOriginalSinkConduit().isWriteShutdown()) continue;
                        channel.getSourceChannel().suspendReads();
                        channel.getSinkChannel().suspendWrites();
                        IoUtils.safeClose((Closeable)connection);
                        return;
                    } while (!requestStateUpdater.compareAndSet(this, 1, 2));
                    this.newRequest();
                    channel.getSourceChannel().setReadListener(this);
                    requestStateUpdater.set(this, 0);
                    channel.getSourceChannel().resumeReads();
                }
            } else if (exchange.isInIoThread()) {
                requestStateUpdater.set(this, 0);
                this.newRequest();
                channel.getIoThread().execute(this);
            } else {
                do {
                    if (!connection.getOriginalSinkConduit().isWriteShutdown()) continue;
                    channel.getSourceChannel().suspendReads();
                    channel.getSinkChannel().suspendWrites();
                    IoUtils.safeClose((Closeable)connection);
                    return;
                } while (!requestStateUpdater.compareAndSet(this, 1, 2));
                this.newRequest();
                channel.getSourceChannel().suspendReads();
                requestStateUpdater.set(this, 0);
                Executor executor = exchange.getDispatchExecutor();
                if (executor == null) {
                    executor = exchange.getConnection().getWorker();
                }
                executor.execute(this);
            }
        } else if (!exchange.isPersistent()) {
            IoUtils.safeClose((Closeable)connection);
        } else {
            if (connection.getExtraBytes() != null) {
                connection.getChannel().getSourceChannel().setConduit(new ReadDataStreamSourceConduit(connection.getChannel().getSourceChannel().getConduit(), connection));
            }
            try {
                if (!connection.getChannel().getSinkChannel().flush()) {
                    connection.getChannel().getSinkChannel().setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)ChannelListeners.flushingChannelListener(new ChannelListener<ConduitStreamSinkChannel>(){

                        @Override
                        public void handleEvent(ConduitStreamSinkChannel conduitStreamSinkChannel) {
                            connection.getUpgradeListener().handleUpgrade(connection.getChannel(), exchange);
                        }
                    }, new ClosingChannelExceptionHandler(connection)));
                    connection.getChannel().getSinkChannel().resumeWrites();
                    return;
                }
                connection.getUpgradeListener().handleUpgrade(connection.getChannel(), exchange);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)connection);
            }
        }
    }

    private boolean isUpgradeOrConnect(HttpServerExchange exchange) {
        return exchange.isUpgrade() || exchange.getRequestMethod().equals(Methods.CONNECT) && ((HttpServerConnection)exchange.getConnection()).isConnectHandled();
    }

    @Override
    public void run() {
        this.handleEvent(this.connection.getChannel().getSourceChannel());
    }

    private void handleHttp2PriorKnowledge(final StreamConnection connection, final HttpServerConnection serverConnection, Pooled<ByteBuffer> readData) throws IOException {
        Pooled<ByteBuffer> extraData;
        ConduitStreamSourceChannel request = connection.getSourceChannel();
        byte[] data = new byte[PRI_EXPECTED.length];
        final ByteBuffer buffer = ByteBuffer.wrap(data);
        if (readData.getResource().hasRemaining()) {
            while (readData.getResource().hasRemaining() && buffer.hasRemaining()) {
                buffer.put(readData.getResource().get());
            }
        }
        if (readData.getResource().hasRemaining()) {
            extraData = readData;
        } else {
            readData.free();
            extraData = null;
        }
        if (!this.doHttp2PriRead(connection, buffer, serverConnection, extraData)) {
            request.getReadSetter().set((ChannelListener<ConduitStreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

                @Override
                public void handleEvent(StreamSourceChannel channel) {
                    try {
                        HttpReadListener.this.doHttp2PriRead(connection, buffer, serverConnection, extraData);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        IoUtils.safeClose((Closeable)connection);
                    }
                }
            });
            request.resumeReads();
        }
    }

    private boolean doHttp2PriRead(StreamConnection connection, ByteBuffer buffer, HttpServerConnection serverConnection, Pooled<ByteBuffer> extraData) throws IOException {
        if (buffer.hasRemaining()) {
            int res = connection.getSourceChannel().read(buffer);
            if (res == -1) {
                return true;
            }
            if (buffer.hasRemaining()) {
                return false;
            }
        }
        buffer.flip();
        for (int i = 0; i < PRI_EXPECTED.length; ++i) {
            if (buffer.get() == PRI_EXPECTED[i]) continue;
            throw UndertowMessages.MESSAGES.http2PriRequestFailed();
        }
        Http2Channel channel = new Http2Channel(connection, null, serverConnection.getBufferPool(), extraData, false, false, false, serverConnection.getUndertowOptions());
        Http2ReceiveListener receiveListener = new Http2ReceiveListener(serverConnection.getRootHandler(), serverConnection.getUndertowOptions(), serverConnection.getBufferSize(), null);
        channel.getReceiveSetter().set(receiveListener);
        channel.resumeReceives();
        return true;
    }
}

