/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.protocol.version07.Masker;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import io.undertow.websockets.extensions.ExtensionByteBuffer;
import io.undertow.websockets.extensions.ExtensionFunction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import org.xnio.Buffers;
import org.xnio.Pooled;

public abstract class WebSocket07FrameSinkChannel
extends StreamSinkFrameChannel {
    private int maskingKey;
    private final Masker masker;
    private long payloadSize;
    private boolean dataWritten = false;
    long toWrite;
    protected List<ExtensionFunction> extensions;
    protected boolean overflow = false;
    protected final int LAST_OVERFLOW = -13;
    protected ByteBuffer bufOverflow = null;
    protected Pooled<ByteBuffer> pooledOverflow = null;
    protected ExtensionByteBuffer extensionResult = null;

    protected WebSocket07FrameSinkChannel(WebSocket07Channel wsChannel, WebSocketFrameType type, long payloadSize) {
        super(wsChannel, type);
        this.payloadSize = payloadSize;
        this.toWrite = payloadSize;
        if (wsChannel.isClient()) {
            this.maskingKey = new Random().nextInt();
            this.masker = new Masker(this.maskingKey);
        } else {
            this.masker = null;
            this.maskingKey = 0;
        }
        this.extensions = wsChannel.getExtensions();
        int rsv = 0;
        if (wsChannel.areExtensionsSupported() && this.extensions != null && (type == WebSocketFrameType.TEXT || type == WebSocketFrameType.BINARY)) {
            for (ExtensionFunction ext : this.extensions) {
                rsv = ext.writeRsv(rsv);
            }
        }
        this.setRsv(rsv);
    }

    @Override
    protected void handleFlushComplete(boolean finalFrame) {
        this.dataWritten = true;
        if (this.masker != null) {
            this.masker.setMaskingKey(this.maskingKey);
        }
    }

    private byte opCode() {
        if (this.dataWritten) {
            return 0;
        }
        switch (this.getType()) {
            case CONTINUATION: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSE: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        throw WebSocketMessages.MESSAGES.unsupportedFrameType(this.getType());
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        long payloadSize;
        if (this.getRsv() == 0) {
            if (this.payloadSize >= 0L && this.dataWritten) {
                if (this.masker != null) {
                    ByteBuffer buf = this.getBuffer();
                    this.masker.beforeWrite(buf, buf.position(), buf.remaining());
                }
                return null;
            }
        } else {
            this.payloadSize = this.getBuffer().remaining();
        }
        Pooled<ByteBuffer> start = ((WebSocketChannel)this.getChannel()).getBufferPool().allocate();
        byte b0 = 0;
        if (this.isFinalFrameQueued() || this.getRsv() == 0 && this.payloadSize >= 0L) {
            b0 = (byte)(b0 | 0x80);
        }
        int rsv = this.opCode() == 0 ? 0 : this.getRsv();
        b0 = (byte)(b0 | (rsv & 7) << 4);
        b0 = (byte)(b0 | this.opCode() & 0xF);
        ByteBuffer header = start.getResource();
        int maskKey = 0;
        if (this.masker != null) {
            maskKey = (byte)(maskKey | 0x80);
        }
        if ((payloadSize = this.payloadSize >= 0L ? this.payloadSize : (long)this.getBuffer().remaining()) <= 125L) {
            header.put(b0);
            header.put((byte)((payloadSize | (long)maskKey) & 0xFFL));
        } else if (payloadSize <= 65535L) {
            header.put(b0);
            header.put((byte)((0x7E | maskKey) & 0xFF));
            header.put((byte)(payloadSize >>> 8 & 0xFFL));
            header.put((byte)(payloadSize & 0xFFL));
        } else {
            header.put(b0);
            header.put((byte)((0x7F | maskKey) & 0xFF));
            header.putLong(payloadSize);
        }
        if (this.masker != null) {
            this.maskingKey = new Random().nextInt();
            header.put((byte)(this.maskingKey >> 24 & 0xFF));
            header.put((byte)(this.maskingKey >> 16 & 0xFF));
            header.put((byte)(this.maskingKey >> 8 & 0xFF));
            header.put((byte)(this.maskingKey & 0xFF));
        }
        header.flip();
        if (this.masker != null) {
            this.masker.setMaskingKey(this.maskingKey);
            ByteBuffer buf = this.getBuffer();
            this.masker.beforeWrite(buf, buf.position(), buf.remaining());
        }
        return new SendFrameHeader(0, start);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.toWrite >= 0L && Buffers.remaining(srcs) > this.toWrite) {
            throw WebSocketMessages.MESSAGES.messageOverflow();
        }
        if (this.getRsv() == 0) {
            return this.writeNoExtensions(srcs, offset, length);
        }
        return this.writeExtensions(srcs, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.toWrite >= 0L && (long)src.remaining() > this.toWrite) {
            throw WebSocketMessages.MESSAGES.messageOverflow();
        }
        if (this.getRsv() == 0) {
            return this.writeNoExtensions(src);
        }
        return this.writeExtensions(src);
    }

    private int writeNoExtensions(ByteBuffer src) throws IOException {
        return super.write(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeExtensions(ByteBuffer src) throws IOException {
        if (!this.overflow) {
            Pooled<ByteBuffer> buffer = ((WebSocketChannel)this.getChannel()).getBufferPool().allocate();
            try {
                ByteBuffer copy = src.duplicate();
                Buffers.copy(buffer.getResource(), copy);
                buffer.getResource().flip();
                int remainingBeforeExtension = buffer.getResource().remaining();
                this.extensionResult = this.applyExtensions(buffer.getResource(), 0, buffer.getResource().remaining());
                int written = super.write(buffer.getResource());
                if (written == 0) {
                    int n = written;
                    return n;
                }
                if (buffer.getResource().hasRemaining()) {
                    this.overflow = true;
                    this.bufOverflow = buffer.getResource();
                    this.pooledOverflow = buffer;
                }
                if (!this.overflow && this.extensionResult != null) {
                    this.overflow = true;
                    this.bufOverflow = null;
                }
                if (src.position() + remainingBeforeExtension < src.capacity()) {
                    if (src.position() + remainingBeforeExtension < src.limit()) {
                        src.position(src.position() + remainingBeforeExtension);
                    } else {
                        src.limit(src.position() + remainingBeforeExtension);
                        src.position(src.limit());
                    }
                } else {
                    src.limit(src.capacity());
                    src.position(src.limit());
                }
                this.toWrite -= (long)remainingBeforeExtension;
                if (this.overflow && !src.hasRemaining()) {
                    if (src.limit() == 0) {
                        src.limit(1);
                        src.put(0, (byte)0);
                    } else if (src.limit() == src.position()) {
                        src.position(src.limit() - 1);
                    }
                    this.toWrite = -13L;
                }
                int n = remainingBeforeExtension;
                return n;
            }
            finally {
                if (!this.overflow) {
                    buffer.free();
                }
            }
        }
        if (this.bufOverflow != null) {
            try {
                int writtenOverflow = super.write(this.bufOverflow);
                if (writtenOverflow == 0) {
                    int copy = writtenOverflow;
                    return copy;
                }
                if (!this.bufOverflow.hasRemaining()) {
                    this.bufOverflow = null;
                    if (this.extensionResult == null) {
                        this.overflow = false;
                    }
                }
                if (this.toWrite == -13L && !this.overflow) {
                    if (src.limit() == 1) {
                        src.limit(0);
                    } else {
                        src.position(src.limit());
                    }
                    int copy = -1;
                    return copy;
                }
                int copy = writtenOverflow;
                return copy;
            }
            finally {
                if (this.bufOverflow == null && this.pooledOverflow != null) {
                    this.pooledOverflow.free();
                }
            }
        }
        try {
            ByteBuffer extraBuffer = this.extensionResult.getExtraRemainingBuffer();
            int writtenOverflow = super.write(extraBuffer);
            if (writtenOverflow == 0) {
                int n = writtenOverflow;
                return n;
            }
            if (!this.extensionResult.hasExtraRemaining()) {
                this.overflow = false;
            }
            if (this.toWrite == -13L && !this.overflow) {
                if (src.limit() == 1) {
                    src.limit(0);
                } else {
                    src.position(src.limit());
                }
                int n = -1;
                return n;
            }
            int n = writtenOverflow;
            return n;
        }
        finally {
            if (!this.overflow) {
                this.extensionResult.free();
                this.extensionResult = null;
            }
        }
    }

    private long writeNoExtensions(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return super.write(srcs, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeExtensions(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!this.overflow) {
            Pooled<ByteBuffer> buffer = ((WebSocketChannel)this.getChannel()).getBufferPool().allocate();
            try {
                ByteBuffer[] copy = new ByteBuffer[length];
                for (int i = 0; i < length; ++i) {
                    copy[i] = srcs[offset + i].duplicate();
                }
                Buffers.copy(buffer.getResource(), copy, 0, length);
                buffer.getResource().flip();
                int remainingBeforeExtension = buffer.getResource().remaining();
                this.extensionResult = this.applyExtensions(buffer.getResource(), 0, buffer.getResource().remaining());
                long written = super.write(buffer.getResource());
                if (written == 0L) {
                    long l = 0L;
                    return l;
                }
                if (buffer.getResource().hasRemaining()) {
                    this.overflow = true;
                    this.bufOverflow = buffer.getResource();
                    this.pooledOverflow = buffer;
                }
                if (!this.overflow && this.extensionResult != null) {
                    this.overflow = true;
                    this.bufOverflow = null;
                }
                long toAllocate = remainingBeforeExtension;
                for (int i = offset; i < length; ++i) {
                    ByteBuffer thisBuf = srcs[i];
                    if (toAllocate <= (long)thisBuf.remaining()) {
                        thisBuf.position((int)((long)thisBuf.position() + toAllocate));
                        break;
                    }
                    toAllocate -= (long)thisBuf.remaining();
                    thisBuf.position(thisBuf.limit());
                }
                this.toWrite -= toAllocate;
                if (this.overflow && !Buffers.hasRemaining(srcs)) {
                    ByteBuffer lastBuf = srcs[srcs.length - 1];
                    if (lastBuf.limit() == 0) {
                        lastBuf.limit(1);
                        lastBuf.put(0, (byte)0);
                    } else if (lastBuf.limit() == lastBuf.position()) {
                        lastBuf.position(lastBuf.position() - 1);
                    }
                    this.toWrite = -13L;
                }
                long l = toAllocate;
                return l;
            }
            finally {
                if (!this.overflow) {
                    buffer.free();
                }
            }
        }
        if (this.bufOverflow != null) {
            try {
                int writtenOverflow = super.write(this.bufOverflow);
                if (writtenOverflow == 0) {
                    long copy = writtenOverflow;
                    return copy;
                }
                if (!this.bufOverflow.hasRemaining()) {
                    this.bufOverflow = null;
                    if (this.extensionResult == null) {
                        this.overflow = false;
                    }
                }
                if (this.toWrite == -13L && !this.overflow) {
                    ByteBuffer lastBuf = srcs[srcs.length - 1];
                    if (lastBuf.limit() == 1) {
                        lastBuf.limit(0);
                    } else {
                        lastBuf.position(lastBuf.limit());
                    }
                    long remainingBeforeExtension = -1L;
                    return remainingBeforeExtension;
                }
                long lastBuf = writtenOverflow;
                return lastBuf;
            }
            finally {
                if (this.bufOverflow == null && this.pooledOverflow != null) {
                    this.pooledOverflow.free();
                }
            }
        }
        try {
            ByteBuffer extraBuffer = this.extensionResult.getExtraRemainingBuffer();
            int writtenOverflow = super.write(extraBuffer);
            if (writtenOverflow == 0) {
                long remainingBeforeExtension = writtenOverflow;
                return remainingBeforeExtension;
            }
            if (!this.extensionResult.hasExtraRemaining()) {
                this.overflow = false;
            }
            if (this.toWrite == -13L && !this.overflow) {
                ByteBuffer lastBuf = srcs[srcs.length - 1];
                if (lastBuf.limit() == 1) {
                    lastBuf.limit(0);
                } else {
                    lastBuf.position(lastBuf.limit());
                }
                long l = -1L;
                return l;
            }
            long l = writtenOverflow;
            return l;
        }
        finally {
            if (!this.overflow) {
                this.extensionResult.free();
                this.extensionResult = null;
            }
        }
    }

    protected ExtensionByteBuffer applyExtensions(ByteBuffer buffer, int position, int length) throws IOException {
        ExtensionByteBuffer extBuffer = new ExtensionByteBuffer(this.getWebSocketChannel(), buffer, position);
        int newLength = length;
        if (this.extensions != null) {
            for (ExtensionFunction ext : this.extensions) {
                ext.beforeWrite(this, extBuffer, position, newLength);
                if (extBuffer.getFilled() == 0) {
                    buffer.position(position);
                    newLength = 0;
                    continue;
                }
                if (extBuffer.getFilled() == newLength) continue;
                newLength = extBuffer.getFilled();
            }
        }
        buffer.flip();
        if (extBuffer.hasExtra()) {
            extBuffer.flipExtra();
            return extBuffer;
        }
        return null;
    }

    protected ExtensionByteBuffer applyExtensionsFlush(ByteBuffer buffer, int position, int length) throws IOException {
        ExtensionByteBuffer extBuffer = new ExtensionByteBuffer(this.getWebSocketChannel(), buffer, position);
        int newLength = length;
        if (this.extensions != null) {
            for (ExtensionFunction ext : this.extensions) {
                ext.beforeFlush(this, extBuffer, position, newLength);
                if (extBuffer.getFilled() == 0) {
                    buffer.position(position);
                    newLength = 0;
                    continue;
                }
                if (extBuffer.getFilled() == newLength) continue;
                newLength = extBuffer.getFilled();
            }
        }
        buffer.flip();
        if (extBuffer.hasExtra()) {
            extBuffer.flipExtra();
            return extBuffer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownWrites() throws IOException {
        if (this.getRsv() > 0 && this.isOpen()) {
            Pooled<ByteBuffer> pooledPadding = ((WebSocketChannel)this.getChannel()).getBufferPool().allocate();
            ByteBuffer buffer = pooledPadding.getResource();
            ExtensionByteBuffer extPadding = this.applyExtensionsFlush(buffer, 0, buffer.remaining());
            try {
                while (buffer.hasRemaining()) {
                    super.write(buffer);
                }
                if (extPadding != null) {
                    while (extPadding.hasExtraRemaining()) {
                        super.write(extPadding.getExtraRemainingBuffer());
                    }
                }
            }
            finally {
                pooledPadding.free();
                if (extPadding != null && extPadding.hasExtra()) {
                    extPadding.free();
                }
            }
        }
        super.shutdownWrites();
    }
}

