/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.UndertowMessages;
import io.undertow.conduits.IdleTimeoutConduit;
import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.server.protocol.framed.FramePriority;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ReferenceCountedPooled;
import io.undertow.websockets.core.WebSocketLogger;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableWriteChannel;

public abstract class AbstractFramedChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements ConnectedChannel {
    private final StreamConnection channel;
    private final IdleTimeoutConduit idleTimeoutConduit;
    private final ChannelListener.SimpleSetter<C> closeSetter;
    private final ChannelListener.SimpleSetter<C> receiveSetter;
    private final Pool<ByteBuffer> bufferPool;
    private final FramePriority<C, R, S> framePriority;
    private final List<S> pendingFrames = new LinkedList<S>();
    private final Deque<S> heldFrames = new ArrayDeque<S>();
    private final Deque<S> newFrames = new LinkedBlockingDeque<S>();
    private volatile long frameDataRemaining;
    private volatile R receiver;
    private boolean receivesSuspended = true;
    private volatile int readsBroken = 0;
    private volatile int writesBroken = 0;
    private static final AtomicIntegerFieldUpdater<AbstractFramedChannel> readsBrokenUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedChannel.class, "readsBroken");
    private static final AtomicIntegerFieldUpdater<AbstractFramedChannel> writesBrokenUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedChannel.class, "writesBroken");
    private ReferenceCountedPooled readData = null;
    private final List<ChannelListener<C>> closeTasks = new CopyOnWriteArrayList<ChannelListener<C>>();
    private boolean flushingSenders = false;
    private final Set<AbstractFramedStreamSourceChannel<C, R, S>> receivers = new HashSet<AbstractFramedStreamSourceChannel<C, R, S>>();

    protected AbstractFramedChannel(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, FramePriority<C, R, S> framePriority, Pooled<ByteBuffer> readData) {
        this.framePriority = framePriority;
        if (readData != null) {
            if (readData.getResource().hasRemaining()) {
                this.readData = new ReferenceCountedPooled(readData, 1);
            } else {
                readData.free();
            }
        }
        if (bufferPool == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("bufferPool");
        }
        if (connectedStreamChannel == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("connectedStreamChannel");
        }
        IdleTimeoutConduit idle = this.createIdleTimeoutChannel(connectedStreamChannel);
        connectedStreamChannel.getSourceChannel().setConduit(idle);
        connectedStreamChannel.getSinkChannel().setConduit(idle);
        this.idleTimeoutConduit = idle;
        this.channel = connectedStreamChannel;
        this.bufferPool = bufferPool;
        this.closeSetter = new ChannelListener.SimpleSetter();
        this.receiveSetter = new ChannelListener.SimpleSetter();
        this.channel.getSourceChannel().getReadSetter().set(null);
        this.channel.getSourceChannel().suspendReads();
        this.channel.getSourceChannel().getReadSetter().set(new FrameReadListener());
        connectedStreamChannel.getSinkChannel().getWriteSetter().set(new FrameWriteListener());
        FrameCloseListener closeListener = new FrameCloseListener();
        connectedStreamChannel.getSinkChannel().getCloseSetter().set(closeListener);
        connectedStreamChannel.getSourceChannel().getCloseSetter().set(closeListener);
    }

    protected IdleTimeoutConduit createIdleTimeoutChannel(StreamConnection connectedStreamChannel) {
        return new IdleTimeoutConduit(connectedStreamChannel.getSinkChannel().getConduit(), connectedStreamChannel.getSourceChannel().getConduit());
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.channel.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IOException {
        return this.channel.setOption(option, value);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.channel.getPeerAddress(type);
    }

    public InetSocketAddress getSourceAddress() {
        return this.getPeerAddress(InetSocketAddress.class);
    }

    public InetSocketAddress getDestinationAddress() {
        return this.getLocalAddress(InetSocketAddress.class);
    }

    public synchronized R receive() throws IOException {
        boolean hasData;
        Pooled<ByteBuffer> buf;
        if (this.isLastFrameReceived() && this.receiver == null) {
            this.channel.getSourceChannel().suspendReads();
            this.channel.getSourceChannel().shutdownReads();
            return null;
        }
        ReferenceCountedPooled pooled = this.readData;
        if (pooled == null) {
            buf = this.bufferPool.allocate();
            this.readData = pooled = new ReferenceCountedPooled(buf, 1);
            hasData = false;
        } else if (pooled.isFreed()) {
            if (!pooled.tryUnfree()) {
                buf = this.bufferPool.allocate();
                this.readData = pooled = new ReferenceCountedPooled(buf, 1);
            } else {
                pooled.getResource().limit(pooled.getResource().capacity());
            }
            hasData = false;
        } else {
            hasData = pooled.getResource().hasRemaining();
        }
        boolean forceFree = false;
        int read = 0;
        try {
            if (!hasData) {
                pooled.getResource().clear();
                read = this.channel.getSourceChannel().read(pooled.getResource());
                if (read == 0) {
                    forceFree = true;
                    R r = null;
                    return r;
                }
                if (read == -1) {
                    try {
                        this.channel.getSourceChannel().shutdownReads();
                    }
                    catch (IOException e) {
                        if (WebSocketLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            WebSocketLogger.REQUEST_LOGGER.debugf((Throwable)e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
                        throw e;
                    }
                    forceFree = true;
                    this.lastDataRead();
                    R e = null;
                    return e;
                }
                pooled.getResource().flip();
            }
            if (this.frameDataRemaining > 0L) {
                if (this.frameDataRemaining >= (long)pooled.getResource().remaining()) {
                    this.frameDataRemaining -= (long)pooled.getResource().remaining();
                    if (this.receiver != null) {
                        ((AbstractFramedStreamSourceChannel)this.receiver).dataReady(null, pooled);
                    } else {
                        pooled.free();
                    }
                    this.readData = null;
                    if (this.frameDataRemaining == 0L) {
                        this.receiver = null;
                    }
                    R e = null;
                    return e;
                }
                ByteBuffer buf2 = pooled.getResource().duplicate();
                buf2.limit((int)((long)buf2.position() + this.frameDataRemaining));
                pooled.getResource().position((int)((long)pooled.getResource().position() + this.frameDataRemaining));
                this.frameDataRemaining = 0L;
                Pooled<ByteBuffer> frameData = pooled.createView(buf2);
                if (this.receiver != null) {
                    ((AbstractFramedStreamSourceChannel)this.receiver).dataReady(null, frameData);
                } else {
                    frameData.free();
                }
                this.receiver = null;
                buf2 = null;
                return (R)buf2;
            }
            FrameHeaderData data = this.parseFrame(pooled.getResource());
            if (data != null) {
                Pooled<ByteBuffer> frameData;
                if (data.getFrameLength() >= (long)pooled.getResource().remaining()) {
                    this.frameDataRemaining = data.getFrameLength() - (long)pooled.getResource().remaining();
                    frameData = pooled.createView(pooled.getResource().duplicate());
                    pooled.getResource().position(pooled.getResource().limit());
                } else {
                    ByteBuffer buf3 = pooled.getResource().duplicate();
                    buf3.limit((int)((long)buf3.position() + data.getFrameLength()));
                    pooled.getResource().position((int)((long)pooled.getResource().position() + data.getFrameLength()));
                    frameData = pooled.createView(buf3);
                }
                AbstractFramedStreamSourceChannel<?, ?, ?> existing = data.getExistingChannel();
                if (existing != null) {
                    if (data.getFrameLength() > (long)frameData.getResource().remaining()) {
                        this.receiver = existing;
                    }
                    existing.dataReady(data, frameData);
                    R r = null;
                    return r;
                }
                boolean moreData = data.getFrameLength() > (long)frameData.getResource().remaining();
                R newChannel = this.createChannel(data, frameData);
                if (newChannel != null) {
                    if (!((AbstractFramedStreamSourceChannel)newChannel).isComplete()) {
                        this.receivers.add((AbstractFramedStreamSourceChannel<C, R, S>)newChannel);
                    }
                    if (moreData) {
                        this.receiver = newChannel;
                    }
                } else {
                    frameData.free();
                }
                R r = newChannel;
                return r;
            }
            R r = null;
            return r;
        }
        catch (IOException | RuntimeException e) {
            this.markReadsBroken(e);
            forceFree = true;
            throw e;
        }
        finally {
            if (this.readData != null && (!pooled.getResource().hasRemaining() || forceFree)) {
                if (pooled.getResource().limit() * 2 > pooled.getResource().capacity() || forceFree) {
                    this.readData = null;
                }
                pooled.free();
            }
        }
    }

    protected void lastDataRead() {
    }

    protected abstract R createChannel(FrameHeaderData var1, Pooled<ByteBuffer> var2) throws IOException;

    protected abstract FrameHeaderData parseFrame(ByteBuffer var1) throws IOException;

    protected synchronized void recalculateHeldFrames() throws IOException {
        if (!this.heldFrames.isEmpty()) {
            this.framePriority.frameAdded(null, this.pendingFrames, this.heldFrames);
            this.flushSenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void flushSenders() {
        ListIterator<S> it;
        boolean finalFrame;
        int toSend;
        block22: {
            AbstractFramedStreamSinkChannel sender;
            if (this.flushingSenders) {
                throw UndertowMessages.MESSAGES.recursiveCallToFlushingSenders();
            }
            this.flushingSenders = true;
            toSend = 0;
            while (!this.newFrames.isEmpty()) {
                AbstractFramedStreamSinkChannel frame = (AbstractFramedStreamSinkChannel)this.newFrames.poll();
                if (this.framePriority.insertFrame(frame, this.pendingFrames)) {
                    if (this.heldFrames.isEmpty()) continue;
                    this.framePriority.frameAdded(frame, this.pendingFrames, this.heldFrames);
                    continue;
                }
                this.heldFrames.add(frame);
            }
            finalFrame = false;
            it = this.pendingFrames.listIterator();
            while (it.hasNext() && (sender = (AbstractFramedStreamSinkChannel)it.next()).isReadyForFlush()) {
                ++toSend;
                if (!sender.isLastFrame()) continue;
                finalFrame = true;
            }
            if (toSend != 0) break block22;
            try {
                if (this.channel.getSinkChannel().flush()) {
                    this.channel.getSinkChannel().suspendWrites();
                }
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)this.channel);
                this.markWritesBroken(e);
            }
            this.flushingSenders = false;
            if (!this.newFrames.isEmpty()) {
                this.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFramedChannel.this.flushSenders();
                    }
                });
            }
            return;
        }
        try {
            Buffer[] data = new ByteBuffer[toSend * 3];
            it = this.pendingFrames.listIterator();
            try {
                AbstractFramedStreamSinkChannel sinkChannel;
                Pooled<ByteBuffer> frameHeaderByteBuffer;
                long res;
                for (int j = 0; j < toSend; ++j) {
                    AbstractFramedStreamSinkChannel next = (AbstractFramedStreamSinkChannel)it.next();
                    SendFrameHeader frameHeader = next.getFrameHeader();
                    Pooled<ByteBuffer> frameHeaderByteBuffer2 = frameHeader.getByteBuffer();
                    data[j * 3] = frameHeaderByteBuffer2 != null ? frameHeaderByteBuffer2.getResource() : Buffers.EMPTY_BYTE_BUFFER;
                    data[j * 3 + 1] = next.getBuffer() == null ? Buffers.EMPTY_BYTE_BUFFER : next.getBuffer();
                    data[j * 3 + 2] = next.getFrameFooter();
                }
                long toWrite = Buffers.remaining(data);
                while ((res = this.channel.getSinkChannel().write((ByteBuffer[])data)) > 0L && (toWrite -= res) > 0L) {
                }
                for (int max = toSend; !(max <= 0 || (frameHeaderByteBuffer = (sinkChannel = (AbstractFramedStreamSinkChannel)this.pendingFrames.get(0)).getFrameHeader().getByteBuffer()) != null && frameHeaderByteBuffer.getResource().hasRemaining() || sinkChannel.getBuffer() != null && sinkChannel.getBuffer().hasRemaining() || sinkChannel.getFrameFooter().hasRemaining()); --max) {
                    sinkChannel.flushComplete();
                    this.pendingFrames.remove(sinkChannel);
                }
                if (!this.pendingFrames.isEmpty() || !this.channel.getSinkChannel().flush()) {
                    this.channel.getSinkChannel().resumeWrites();
                } else {
                    this.channel.getSinkChannel().suspendWrites();
                }
                if (this.pendingFrames.isEmpty() && finalFrame) {
                    this.channel.getSinkChannel().shutdownWrites();
                    if (!this.channel.getSinkChannel().flush()) {
                        this.channel.getSinkChannel().setWriteListener(ChannelListeners.flushingChannelListener(null, null));
                        this.channel.getSinkChannel().resumeWrites();
                    }
                }
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)this.channel);
                this.markWritesBroken(e);
            }
            this.flushingSenders = false;
        }
        catch (Throwable throwable) {
            this.flushingSenders = false;
            if (!this.newFrames.isEmpty()) {
                this.getIoThread().execute(new /* invalid duplicate definition of identical inner class */);
            }
            throw throwable;
        }
        if (!this.newFrames.isEmpty()) {
            this.getIoThread().execute(new /* invalid duplicate definition of identical inner class */);
        }
    }

    void awaitWritable() throws IOException {
        this.channel.getSinkChannel().awaitWritable();
    }

    void awaitWritable(long time, TimeUnit unit) throws IOException {
        this.channel.getSinkChannel().awaitWritable(time, unit);
    }

    protected synchronized void queueFrame(S channel) throws IOException {
        assert (!this.newFrames.contains(channel));
        if (this.isWritesBroken() || !this.channel.getSinkChannel().isOpen() || ((AbstractFramedStreamSinkChannel)channel).isBroken() || !((AbstractFramedStreamSinkChannel)channel).isOpen()) {
            IoUtils.safeClose(channel);
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        this.newFrames.add(channel);
        if (!this.flushingSenders) {
            if (((AbstractFramedStreamSinkChannel)channel).getIoThread() == Thread.currentThread()) {
                this.flushSenders();
            } else {
                ((AbstractFramedStreamSinkChannel)channel).getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFramedChannel.this.flushSenders();
                    }
                });
            }
        }
    }

    protected abstract boolean isLastFrameReceived();

    protected abstract boolean isLastFrameSent();

    protected abstract void handleBrokenSourceChannel(Throwable var1);

    protected abstract void handleBrokenSinkChannel(Throwable var1);

    public ChannelListener.Setter<C> getReceiveSetter() {
        return this.receiveSetter;
    }

    public synchronized void suspendReceives() {
        this.receivesSuspended = true;
        if (this.receiver == null) {
            this.channel.getSourceChannel().suspendReads();
        }
    }

    public synchronized void resumeReceives() {
        this.receivesSuspended = false;
        if (this.readData != null && !this.readData.isFreed()) {
            this.channel.getSourceChannel().wakeupReads();
        } else {
            this.channel.getSourceChannel().resumeReads();
        }
    }

    public boolean isReceivesResumed() {
        return !this.receivesSuspended;
    }

    @Override
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)this.channel);
        if (this.readData != null) {
            this.readData.free();
            this.readData = null;
        }
    }

    public ChannelListener.Setter<? extends AbstractFramedChannel> getCloseSetter() {
        return this.closeSetter;
    }

    protected void markReadsBroken(Throwable cause) {
        if (readsBrokenUpdater.compareAndSet(this, 0, 1)) {
            this.handleBrokenSourceChannel(cause);
            IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
            this.closeSubChannels();
        }
    }

    protected abstract void closeSubChannels();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markWritesBroken(Throwable cause) {
        if (writesBrokenUpdater.compareAndSet(this, 0, 1)) {
            this.handleBrokenSinkChannel(cause);
            IoUtils.safeClose((Closeable)this.channel.getSinkChannel());
            AbstractFramedChannel abstractFramedChannel = this;
            synchronized (abstractFramedChannel) {
                for (AbstractFramedStreamSinkChannel channel : this.pendingFrames) {
                    channel.markBroken();
                }
                this.pendingFrames.clear();
                for (AbstractFramedStreamSinkChannel channel : this.newFrames) {
                    channel.markBroken();
                }
                this.newFrames.clear();
                for (AbstractFramedStreamSinkChannel channel : this.heldFrames) {
                    channel.markBroken();
                }
                this.heldFrames.clear();
            }
        }
    }

    protected boolean isWritesBroken() {
        return writesBrokenUpdater.get(this) != 0;
    }

    protected boolean isReadsBroken() {
        return readsBrokenUpdater.get(this) != 0;
    }

    void resumeWrites() {
        this.channel.getSinkChannel().resumeWrites();
    }

    void suspendWrites() {
        this.channel.getSinkChannel().suspendWrites();
    }

    void wakeupWrites() {
        this.channel.getSinkChannel().wakeupWrites();
    }

    StreamSourceChannel getSourceChannel() {
        return this.channel.getSourceChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFrameReadComplete(AbstractFramedStreamSourceChannel<C, R, S> channel) {
        AbstractFramedChannel abstractFramedChannel = this;
        synchronized (abstractFramedChannel) {
            if (this.isLastFrameReceived()) {
                IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyClosed(AbstractFramedStreamSourceChannel<C, R, S> channel) {
        AbstractFramedChannel abstractFramedChannel = this;
        synchronized (abstractFramedChannel) {
            this.receivers.remove(channel);
        }
    }

    public void setIdleTimeout(long timeout) {
        this.idleTimeoutConduit.setIdleTimeout(timeout);
    }

    public long getIdleTimeout() {
        return this.idleTimeoutConduit.getIdleTimeout();
    }

    protected FramePriority<C, R, S> getFramePriority() {
        return this.framePriority;
    }

    public void addCloseTask(ChannelListener<C> task) {
        this.closeTasks.add(task);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + (this.receiver == null ? "No Receiver" : this.receiver.toString()) + " " + this.pendingFrames.toString() + " -- " + this.heldFrames.toString() + " -- " + this.newFrames.toString() + "]";
    }

    protected StreamConnection getUnderlyingConnection() {
        return this.channel;
    }

    protected ChannelExceptionHandler<SuspendableWriteChannel> writeExceptionHandler() {
        return new ChannelExceptionHandler<SuspendableWriteChannel>(){

            @Override
            public void handleException(SuspendableWriteChannel channel, IOException exception) {
                AbstractFramedChannel.this.markWritesBroken(exception);
            }
        };
    }

    private class FrameCloseListener
    implements ChannelListener<CloseableChannel> {
        private boolean sinkClosed;
        private boolean sourceClosed;

        private FrameCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(final CloseableChannel c) {
            AbstractFramedChannel abstractFramedChannel;
            if (c instanceof StreamSinkChannel) {
                this.sinkClosed = true;
            } else if (c instanceof StreamSourceChannel) {
                this.sourceClosed = true;
            }
            if (!this.sourceClosed || !this.sinkClosed) {
                return;
            }
            if (AbstractFramedChannel.this.readData != null && !AbstractFramedChannel.this.readData.isFreed()) {
                ChannelListener listener = AbstractFramedChannel.this.receiveSetter.get();
                if (listener != null) {
                    AbstractFramedChannel.this.channel.getIoThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            while (AbstractFramedChannel.this.readData != null && !AbstractFramedChannel.this.readData.isFreed()) {
                                int rem = AbstractFramedChannel.this.readData.getResource().remaining();
                                ChannelListeners.invokeChannelListener(AbstractFramedChannel.this, AbstractFramedChannel.this.receiveSetter.get());
                                if (AbstractFramedChannel.this.readData == null || rem != AbstractFramedChannel.this.readData.getResource().remaining()) continue;
                                break;
                            }
                            FrameCloseListener.this.handleEvent(c);
                        }
                    });
                }
                return;
            }
            if (Thread.currentThread() != c.getIoThread()) {
                ChannelListeners.invokeChannelListener(c.getIoThread(), c, this);
                return;
            }
            AbstractFramedStreamSourceChannel receiver = AbstractFramedChannel.this.receiver;
            try {
                if (receiver != null && receiver.isOpen() && receiver.isReadResumed()) {
                    ChannelListeners.invokeChannelListener(receiver, ((ChannelListener.SimpleSetter)receiver.getReadSetter()).get());
                }
                abstractFramedChannel = AbstractFramedChannel.this;
                synchronized (abstractFramedChannel) {
                    for (AbstractFramedStreamSinkChannel channel : AbstractFramedChannel.this.pendingFrames) {
                        channel.markBroken();
                    }
                    for (AbstractFramedStreamSinkChannel channel : AbstractFramedChannel.this.newFrames) {
                        channel.markBroken();
                    }
                    for (AbstractFramedStreamSinkChannel channel : AbstractFramedChannel.this.heldFrames) {
                        channel.markBroken();
                    }
                    for (AbstractFramedStreamSourceChannel r : new ArrayList(AbstractFramedChannel.this.receivers)) {
                        IoUtils.safeClose((Closeable)r);
                    }
                }
            }
            finally {
                try {
                    for (ChannelListener task : AbstractFramedChannel.this.closeTasks) {
                        ChannelListeners.invokeChannelListener(AbstractFramedChannel.this, task);
                    }
                }
                finally {
                    abstractFramedChannel = AbstractFramedChannel.this;
                    synchronized (abstractFramedChannel) {
                        AbstractFramedChannel.this.closeSubChannels();
                        if (AbstractFramedChannel.this.readData != null) {
                            AbstractFramedChannel.this.readData.free();
                            AbstractFramedChannel.this.readData = null;
                        }
                    }
                    ChannelListeners.invokeChannelListener(AbstractFramedChannel.this, AbstractFramedChannel.this.closeSetter.get());
                }
            }
        }
    }

    private class FrameWriteListener
    implements ChannelListener<StreamSinkChannel> {
        private FrameWriteListener() {
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            AbstractFramedChannel.this.flushSenders();
        }
    }

    private final class FrameReadListener
    implements ChannelListener<StreamSourceChannel> {
        private FrameReadListener() {
        }

        @Override
        public void handleEvent(final StreamSourceChannel channel) {
            AbstractFramedStreamSourceChannel receiver = AbstractFramedChannel.this.receiver;
            if ((AbstractFramedChannel.this.isLastFrameReceived() || AbstractFramedChannel.this.receivesSuspended) && receiver == null) {
                channel.suspendReads();
                return;
            }
            ChannelListener listener = AbstractFramedChannel.this.receiveSetter.get();
            if (listener != null) {
                WebSocketLogger.REQUEST_LOGGER.tracef("Invoking receive listener", (Object)receiver);
                ChannelListeners.invokeChannelListener(AbstractFramedChannel.this, listener);
            } else {
                channel.suspendReads();
            }
            if (AbstractFramedChannel.this.readData != null && !AbstractFramedChannel.this.readData.isFreed() && channel.isOpen()) {
                try {
                    channel.getIoThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            ChannelListeners.invokeChannelListener(channel, FrameReadListener.this);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    IoUtils.safeClose((Closeable)AbstractFramedChannel.this);
                }
            }
        }
    }
}

