/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import io.undertow.util.StatusCodes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

final class HttpResponseConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final Pool<ByteBuffer> pool;
    private int state = 1;
    private long fiCookie = -1L;
    private String string;
    private HeaderValues headerValues;
    private int valueIdx;
    private int charIndex;
    private Pooled<ByteBuffer> pooledBuffer;
    private HttpServerExchange exchange;
    private ByteBuffer[] writevBuffer;
    private boolean done = false;
    private static final int STATE_BODY = 0;
    private static final int STATE_START = 1;
    private static final int STATE_HDR_NAME = 2;
    private static final int STATE_HDR_D = 3;
    private static final int STATE_HDR_DS = 4;
    private static final int STATE_HDR_VAL = 5;
    private static final int STATE_HDR_EOL_CR = 6;
    private static final int STATE_HDR_EOL_LF = 7;
    private static final int STATE_HDR_FINAL_CR = 8;
    private static final int STATE_HDR_FINAL_LF = 9;
    private static final int STATE_BUF_FLUSH = 10;
    private static final int MASK_STATE = 15;
    private static final int FLAG_SHUTDOWN = 16;

    HttpResponseConduit(StreamSinkConduit next, Pool<ByteBuffer> pool) {
        super(next);
        this.pool = pool;
    }

    HttpResponseConduit(StreamSinkConduit next, Pool<ByteBuffer> pool, HttpServerExchange exchange) {
        super(next);
        this.pool = pool;
        this.exchange = exchange;
    }

    void reset(HttpServerExchange exchange) {
        this.exchange = exchange;
        this.state = 1;
        this.fiCookie = -1L;
        this.string = null;
        this.headerValues = null;
        this.valueIdx = 0;
        this.charIndex = 0;
    }

    private int processWrite(int state, Object userData, int pos, int length) throws IOException {
        if (this.done) {
            throw new ClosedChannelException();
        }
        assert (state != 0);
        if (state == 10) {
            ByteBuffer byteBuffer = this.pooledBuffer.getResource();
            do {
                ByteBuffer[] data;
                long res = 0L;
                if (userData == null || length == 0) {
                    res = ((StreamSinkConduit)this.next).write(byteBuffer);
                } else if (userData instanceof ByteBuffer) {
                    data = this.writevBuffer;
                    if (data == null) {
                        this.writevBuffer = new ByteBuffer[2];
                        data = this.writevBuffer;
                    }
                    data[0] = byteBuffer;
                    data[1] = (ByteBuffer)userData;
                    res = ((StreamSinkConduit)this.next).write(data, 0, 2);
                } else {
                    data = this.writevBuffer;
                    if (data == null || data.length < length + 1) {
                        this.writevBuffer = new ByteBuffer[length + 1];
                        data = this.writevBuffer;
                    }
                    data[0] = byteBuffer;
                    System.arraycopy(userData, pos, data, 1, length);
                    res = ((StreamSinkConduit)this.next).write(data, 0, data.length);
                }
                if (res != 0L) continue;
                return 10;
            } while (byteBuffer.hasRemaining());
            this.bufferDone();
            return 0;
        }
        if (state != 1) {
            return this.processStatefulWrite(state, userData, pos, length);
        }
        Connectors.flattenCookies(this.exchange);
        if (this.pooledBuffer == null) {
            this.pooledBuffer = this.pool.allocate();
        }
        ByteBuffer buffer = this.pooledBuffer.getResource();
        assert (buffer.remaining() >= 50);
        this.exchange.getProtocol().appendTo(buffer);
        buffer.put((byte)32);
        int code = this.exchange.getResponseCode();
        assert (999 >= code && code >= 100);
        buffer.put((byte)(code / 100 + 48));
        buffer.put((byte)(code / 10 % 10 + 48));
        buffer.put((byte)(code % 10 + 48));
        buffer.put((byte)32);
        String string = StatusCodes.getReason(code);
        HttpResponseConduit.writeString(buffer, string);
        buffer.put((byte)13).put((byte)10);
        int remaining = buffer.remaining();
        HeaderMap headers = this.exchange.getResponseHeaders();
        long fiCookie = headers.fastIterateNonEmpty();
        while (fiCookie != -1L) {
            HeaderValues headerValues = headers.fiCurrent(fiCookie);
            HttpString header = headerValues.getHeaderName();
            int headerSize = header.length();
            int valueIdx = 0;
            while (valueIdx < headerValues.size()) {
                if ((remaining -= headerSize + 2) < 0) {
                    this.fiCookie = fiCookie;
                    this.string = string;
                    this.headerValues = headerValues;
                    this.valueIdx = valueIdx;
                    this.charIndex = 0;
                    this.state = 2;
                    buffer.flip();
                    return this.processStatefulWrite(2, userData, pos, length);
                }
                header.appendTo(buffer);
                buffer.put((byte)58).put((byte)32);
                string = headerValues.get(valueIdx++);
                if ((remaining -= string.length() + 2) < 2) {
                    this.fiCookie = fiCookie;
                    this.string = string;
                    this.headerValues = headerValues;
                    this.valueIdx = valueIdx;
                    this.charIndex = 0;
                    this.state = 5;
                    buffer.flip();
                    return this.processStatefulWrite(5, userData, pos, length);
                }
                HttpResponseConduit.writeString(buffer, string);
                buffer.put((byte)13).put((byte)10);
            }
            fiCookie = headers.fiNextNonEmpty(fiCookie);
        }
        buffer.put((byte)13).put((byte)10);
        buffer.flip();
        do {
            ByteBuffer[] data;
            long res = 0L;
            if (userData == null) {
                res = ((StreamSinkConduit)this.next).write(buffer);
            } else if (userData instanceof ByteBuffer) {
                data = this.writevBuffer;
                if (data == null) {
                    this.writevBuffer = new ByteBuffer[2];
                    data = this.writevBuffer;
                }
                data[0] = buffer;
                data[1] = (ByteBuffer)userData;
                res = ((StreamSinkConduit)this.next).write(data, 0, 2);
            } else {
                data = this.writevBuffer;
                if (data == null || data.length < length + 1) {
                    this.writevBuffer = new ByteBuffer[length + 1];
                    data = this.writevBuffer;
                }
                data[0] = buffer;
                System.arraycopy(userData, pos, data, 1, length);
                res = ((StreamSinkConduit)this.next).write(data, 0, data.length);
            }
            if (res != 0L) continue;
            return 10;
        } while (buffer.hasRemaining());
        this.bufferDone();
        return 0;
    }

    private void bufferDone() {
        HttpServerConnection connection = (HttpServerConnection)this.exchange.getConnection();
        if (connection.getExtraBytes() != null && connection.isOpen() && this.exchange.isRequestComplete()) {
            this.pooledBuffer.getResource().clear();
        } else {
            this.pooledBuffer.free();
            this.pooledBuffer = null;
        }
    }

    private static void writeString(ByteBuffer buffer, String string) {
        int length = string.length();
        for (int charIndex = 0; charIndex < length; ++charIndex) {
            buffer.put((byte)string.charAt(charIndex));
        }
    }

    /*
     * Unable to fully structure code
     */
    private int processStatefulWrite(int state, Object userData, int pos, int len) throws IOException {
        buffer = this.pooledBuffer.getResource();
        fiCookie = this.fiCookie;
        valueIdx = this.valueIdx;
        charIndex = this.charIndex;
        string = this.string;
        headerValues = this.headerValues;
        if (buffer.hasRemaining()) {
            do {
                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                return state;
            } while (buffer.hasRemaining());
        }
        buffer.clear();
        headers = this.exchange.getResponseHeaders();
        block12: while (true) {
            switch (state) {
                case 2: {
                    headerName = headerValues.getHeaderName();
                    length = headerName.length();
                    while (charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put(headerName.byteAt(charIndex++));
                            continue;
                        }
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerValues = headerValues;
                            this.charIndex = charIndex;
                            this.fiCookie = fiCookie;
                            this.valueIdx = valueIdx;
                            return 2;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                }
                case 3: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerValues = headerValues;
                            this.charIndex = charIndex;
                            this.fiCookie = fiCookie;
                            this.valueIdx = valueIdx;
                            return 3;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)58);
                }
                case 4: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerValues = headerValues;
                            this.charIndex = charIndex;
                            this.fiCookie = fiCookie;
                            this.valueIdx = valueIdx;
                            return 4;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)32);
                    string = headerValues.get(valueIdx++);
                    charIndex = 0;
                }
                case 5: {
                    length = string.length();
                    while (charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put((byte)string.charAt(charIndex++));
                            continue;
                        }
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerValues = headerValues;
                            this.charIndex = charIndex;
                            this.fiCookie = fiCookie;
                            this.valueIdx = valueIdx;
                            return 5;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    charIndex = 0;
                    if (valueIdx == headerValues.size()) {
                        if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer, string, headerValues, charIndex, fiCookie, valueIdx)) {
                            return 6;
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer, string, headerValues, charIndex, fiCookie, valueIdx)) {
                            return 7;
                        }
                        buffer.put((byte)10);
                        fiCookie = headers.fiNextNonEmpty(fiCookie);
                        if (fiCookie != -1L) {
                            headerValues = headers.fiCurrent(fiCookie);
                            valueIdx = 0;
                            state = 2;
                            continue block12;
                        }
                        if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer, string, headerValues, charIndex, fiCookie, valueIdx)) {
                            return 8;
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer, string, headerValues, charIndex, fiCookie, valueIdx)) {
                            return 9;
                        }
                        buffer.put((byte)10);
                        this.fiCookie = -1L;
                        this.valueIdx = 0;
                        this.string = null;
                        buffer.flip();
                        if (userData == null) {
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                return 10;
                            } while (buffer.hasRemaining());
                        } else if (userData instanceof ByteBuffer) {
                            b = new ByteBuffer[]{buffer, (ByteBuffer)userData};
                            do {
                                if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                                return 10;
                            } while (buffer.hasRemaining());
                        } else {
                            b = new ByteBuffer[1 + len];
                            b[0] = buffer;
                            System.arraycopy(userData, pos, b, 1, len);
                            do {
                                if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                                return 10;
                            } while (buffer.hasRemaining());
                        }
                        this.bufferDone();
                        return 0;
                    }
                }
                case 6: {
                    if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer, string, headerValues, charIndex, fiCookie, valueIdx)) {
                        return 6;
                    }
                    buffer.put((byte)13);
                }
                case 7: {
                    if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer, string, headerValues, charIndex, fiCookie, valueIdx)) {
                        return 7;
                    }
                    buffer.put((byte)10);
                    if (valueIdx < headerValues.size()) {
                        state = 2;
                        continue block12;
                    }
                    if ((fiCookie = headers.fiNextNonEmpty(fiCookie)) != -1L) {
                        headerValues = headers.fiCurrent(fiCookie);
                        valueIdx = 0;
                        state = 2;
                        continue block12;
                    }
                }
                case 8: {
                    if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer, string, headerValues, charIndex, fiCookie, valueIdx)) {
                        return 8;
                    }
                    buffer.put((byte)13);
                }
                case 9: {
                    if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer, string, headerValues, charIndex, fiCookie, valueIdx)) {
                        return 9;
                    }
                    buffer.put((byte)10);
                    this.fiCookie = -1L;
                    this.valueIdx = 0;
                    this.string = null;
                    buffer.flip();
                    if (userData != null) ** GOTO lbl186
                    do {
                        if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                        return 10;
                    } while (buffer.hasRemaining());
                    ** GOTO lbl200
lbl186:
                    // 1 sources

                    if (!(userData instanceof ByteBuffer)) ** GOTO lbl193
                    b = new ByteBuffer[]{buffer, (ByteBuffer)userData};
                    do {
                        if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                        return 10;
                    } while (buffer.hasRemaining());
                    ** GOTO lbl200
lbl193:
                    // 1 sources

                    b = new ByteBuffer[1 + len];
                    b[0] = buffer;
                    System.arraycopy(userData, pos, b, 1, len);
                    do {
                        if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                        return 10;
                    } while (buffer.hasRemaining());
                }
lbl200:
                // 4 sources

                case 10: {
                    this.bufferDone();
                    return 0;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private boolean flushHeaderBuffer(ByteBuffer buffer, String string, HeaderValues headerValues, int charIndex, long fiCookie, int valueIdx) throws IOException {
        buffer.flip();
        do {
            int res;
            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
            this.string = string;
            this.headerValues = headerValues;
            this.charIndex = charIndex;
            this.fiCookie = fiCookie;
            this.valueIdx = valueIdx;
            return true;
        } while (buffer.hasRemaining());
        buffer.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        int oldState = this.state;
        int state = oldState & 0xF;
        int alreadyWritten = 0;
        int originalRemaining = -1;
        try {
            if (state != 0) {
                originalRemaining = src.remaining();
                if ((state = this.processWrite(state, src, -1, -1)) != 0) {
                    int n = 0;
                    return n;
                }
                alreadyWritten = originalRemaining - src.remaining();
                if (Bits.allAreSet(oldState, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            if (alreadyWritten != originalRemaining) {
                int n = ((StreamSinkConduit)this.next).write(src) + alreadyWritten;
                return n;
            }
            int n = alreadyWritten;
            return n;
        }
        finally {
            this.state = oldState & 0xFFFFFFF0 | state;
        }
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                long rem = Buffers.remaining(srcs, offset, length);
                state = this.processWrite(state, srcs, offset, length);
                long ret = rem - Buffers.remaining(srcs, offset, length);
                if (state != 0) {
                    long l = ret;
                    return l;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
                long l = ret;
                return l;
            }
            long l = length == 1 ? (long)((StreamSinkConduit)this.next).write(srcs[offset]) : ((StreamSinkConduit)this.next).write(srcs, offset, length);
            return l;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (this.state != 0) {
            Pooled<ByteBuffer> pooled = this.exchange.getConnection().getBufferPool().allocate();
            ByteBuffer buffer = pooled.getResource();
            try {
                int res = src.read(buffer);
                if (res <= 0) {
                    long l = res;
                    return l;
                }
                buffer.flip();
                long l = this.write(buffer);
                return l;
            }
            finally {
                pooled.free();
            }
        }
        return ((StreamSinkConduit)this.next).transferFrom(src, position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (this.state != 0) {
            return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
        }
        return ((StreamSinkConduit)this.next).transferFrom(source, count, throughBuffer);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null, -1, -1)) != 0) {
                    boolean bl = false;
                    return bl;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                }
            }
            boolean bl = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    @Override
    public void terminateWrites() throws IOException {
        int oldVal = this.state;
        if (Bits.allAreClear(oldVal, 15)) {
            ((StreamSinkConduit)this.next).terminateWrites();
            return;
        }
        this.state = oldVal | 0x10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateWrites() throws IOException {
        try {
            ((StreamSinkConduit)this.next).truncateWrites();
        }
        finally {
            if (this.pooledBuffer != null) {
                this.bufferDone();
            }
        }
    }

    @Override
    public XnioWorker getWorker() {
        return ((StreamSinkConduit)this.next).getWorker();
    }

    void freeBuffers() {
        this.done = true;
        if (this.pooledBuffer != null) {
            this.bufferDone();
        }
    }
}

