/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.AsyncContextImpl;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;

public class FilterHandler
implements HttpHandler {
    private final Map<DispatcherType, List<ManagedFilter>> filters;
    private final Map<DispatcherType, Boolean> asyncSupported;
    private final boolean allowNonStandardWrappers;
    private final HttpHandler next;

    public FilterHandler(Map<DispatcherType, List<ManagedFilter>> filters, boolean allowNonStandardWrappers, HttpHandler next) {
        this.allowNonStandardWrappers = allowNonStandardWrappers;
        this.next = next;
        this.filters = new EnumMap<DispatcherType, List<ManagedFilter>>(filters);
        EnumMap<DispatcherType, Boolean> asyncSupported = new EnumMap<DispatcherType, Boolean>(DispatcherType.class);
        for (Map.Entry<DispatcherType, List<ManagedFilter>> entry : filters.entrySet()) {
            boolean supported = true;
            for (ManagedFilter i : entry.getValue()) {
                if (i.getFilterInfo().isAsyncSupported()) continue;
                supported = false;
                break;
            }
            asyncSupported.put(entry.getKey(), supported);
        }
        this.asyncSupported = asyncSupported;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        List<ManagedFilter> filters;
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest request = servletRequestContext.getServletRequest();
        ServletResponse response = servletRequestContext.getServletResponse();
        DispatcherType dispatcher = servletRequestContext.getDispatcherType();
        Boolean supported = this.asyncSupported.get((Object)dispatcher);
        if (supported != null && !supported.booleanValue()) {
            exchange.putAttachment(AsyncContextImpl.ASYNC_SUPPORTED, false);
        }
        if ((filters = this.filters.get((Object)dispatcher)) == null) {
            this.next.handleRequest(exchange);
        } else {
            FilterChainImpl filterChain = new FilterChainImpl(exchange, filters, this.next, this.allowNonStandardWrappers);
            filterChain.doFilter(request, response);
        }
    }

    private static class FilterChainImpl
    implements FilterChain {
        int location = 0;
        final HttpServerExchange exchange;
        final List<ManagedFilter> filters;
        final HttpHandler next;
        final boolean allowNonStandardWrappers;

        private FilterChainImpl(HttpServerExchange exchange, List<ManagedFilter> filters, HttpHandler next, boolean allowNonStandardWrappers) {
            this.exchange = exchange;
            this.filters = filters;
            this.next = next;
            this.allowNonStandardWrappers = allowNonStandardWrappers;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            ServletRequestContext servletRequestContext = this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            ServletRequest oldReq = servletRequestContext.getServletRequest();
            ServletResponse oldResp = servletRequestContext.getServletResponse();
            try {
                if (!this.allowNonStandardWrappers) {
                    if (oldReq != request && !(request instanceof ServletRequestWrapper)) {
                        throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
                    }
                    if (oldResp != response && !(response instanceof ServletResponseWrapper)) {
                        throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
                    }
                }
                servletRequestContext.setServletRequest(request);
                servletRequestContext.setServletResponse(response);
                int index = this.location++;
                if (index >= this.filters.size()) {
                    this.next.handleRequest(this.exchange);
                } else {
                    this.filters.get(index).doFilter(request, response, this);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                --this.location;
                servletRequestContext.setServletRequest(oldReq);
                servletRequestContext.setServletResponse(oldResp);
            }
        }
    }
}

