/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyControlFrameStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyProtocolUtils;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.nio.ByteBuffer;

class SpdyWindowUpdateStreamSinkChannel
extends SpdyControlFrameStreamSinkChannel {
    private final int streamId;
    private final int deltaWindowSize;

    protected SpdyWindowUpdateStreamSinkChannel(SpdyChannel channel, int streamId, int deltaWindowSize) {
        super(channel);
        this.streamId = streamId;
        this.deltaWindowSize = deltaWindowSize;
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 9;
        SpdyProtocolUtils.putInt(buf, firstInt);
        SpdyProtocolUtils.putInt(buf, 8);
        SpdyProtocolUtils.putInt(buf, this.streamId);
        SpdyProtocolUtils.putInt(buf, this.deltaWindowSize);
        buf.flip();
        return new SendFrameHeader(new ImmediatePooledByteBuffer(buf));
    }
}

