/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.Handlers;
import io.undertow.predicate.Predicates;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContextFactory;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.NotificationReceiverHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.CachedAuthenticatedSessionMechanism;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.security.impl.ExternalAuthenticationMechanism;
import io.undertow.security.impl.GenericHeaderAuthenticationMechanism;
import io.undertow.security.impl.SecurityContextFactoryImpl;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.HttpContinueReadHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MetricsCollector;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.core.DeploymentImpl;
import io.undertow.servlet.core.ErrorPages;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.MetricsChainHandler;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.core.ServletRequestContextThreadSetupAction;
import io.undertow.servlet.core.SessionListenerBridge;
import io.undertow.servlet.handlers.CrawlerSessionManagerHandler;
import io.undertow.servlet.handlers.ServletDispatchingHandler;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletInitialHandler;
import io.undertow.servlet.handlers.SessionRestoringHandler;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import io.undertow.servlet.handlers.security.SSLInformationAssociationHandler;
import io.undertow.servlet.handlers.security.SecurityPathMatches;
import io.undertow.servlet.handlers.security.ServletAuthenticationCallHandler;
import io.undertow.servlet.handlers.security.ServletAuthenticationConstraintHandler;
import io.undertow.servlet.handlers.security.ServletConfidentialityConstraintHandler;
import io.undertow.servlet.handlers.security.ServletFormAuthenticationMechanism;
import io.undertow.servlet.handlers.security.ServletSecurityConstraintHandler;
import io.undertow.servlet.predicate.DispatcherTypePredicate;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.spec.SessionCookieConfigImpl;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import javax.servlet.SessionTrackingMode;

public class DeploymentManagerImpl
implements DeploymentManager {
    private final DeploymentInfo originalDeployment;
    private final ServletContainer servletContainer;
    private volatile DeploymentImpl deployment;
    private volatile DeploymentManager.State state = DeploymentManager.State.UNDEPLOYED;

    public DeploymentManagerImpl(DeploymentInfo deployment, ServletContainer servletContainer) {
        this.originalDeployment = deployment;
        this.servletContainer = servletContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy() {
        DeploymentImpl deployment;
        DeploymentInfo deploymentInfo = this.originalDeployment.clone();
        if (deploymentInfo.getServletStackTraces() == ServletStackTraces.ALL) {
            UndertowServletLogger.REQUEST_LOGGER.servletStackTracesAll(deploymentInfo.getDeploymentName());
        }
        deploymentInfo.validate();
        this.deployment = deployment = new DeploymentImpl(this, deploymentInfo, this.servletContainer);
        ServletContextImpl servletContext = new ServletContextImpl(this.servletContainer, deployment);
        deployment.setServletContext(servletContext);
        this.handleExtensions(deploymentInfo, servletContext);
        deployment.getServletPaths().setWelcomePages(deploymentInfo.getWelcomePages());
        deployment.setDefaultCharset(Charset.forName(deploymentInfo.getDefaultEncoding()));
        this.handleDeploymentSessionConfig(deploymentInfo, servletContext);
        deployment.setSessionManager(deploymentInfo.getSessionManagerFactory().createSessionManager(deployment));
        deployment.getSessionManager().setDefaultSessionTimeout(deploymentInfo.getDefaultSessionTimeout());
        ArrayList<ThreadSetupAction> setup = new ArrayList<ThreadSetupAction>();
        setup.add(ServletRequestContextThreadSetupAction.INSTANCE);
        setup.add(new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()));
        setup.addAll(deploymentInfo.getThreadSetupActions());
        CompositeThreadSetupAction threadSetupAction = new CompositeThreadSetupAction(setup);
        deployment.setThreadSetupAction(threadSetupAction);
        ThreadSetupAction.Handle handle = threadSetupAction.setup(null);
        try {
            ApplicationListeners listeners = this.createListeners();
            listeners.start();
            deployment.setApplicationListeners(listeners);
            this.createServletsAndFilters(deployment, deploymentInfo);
            for (ServletContainerInitializerInfo sci : deploymentInfo.getServletContainerInitializers()) {
                InstanceHandle<? extends ServletContainerInitializer> instance = sci.getInstanceFactory().createInstance();
                try {
                    instance.getInstance().onStartup(sci.getHandlesTypes(), servletContext);
                }
                finally {
                    instance.release();
                }
            }
            deployment.getSessionManager().registerSessionListener(new SessionListenerBridge(threadSetupAction, listeners, servletContext));
            for (SessionListener listener : deploymentInfo.getSessionListeners()) {
                deployment.getSessionManager().registerSessionListener(listener);
            }
            this.initializeErrorPages(deployment, deploymentInfo);
            this.initializeMimeMappings(deployment, deploymentInfo);
            this.initializeTempDir(servletContext, deploymentInfo);
            listeners.contextInitialized();
            HttpHandler wrappedHandlers = ServletDispatchingHandler.INSTANCE;
            wrappedHandlers = DeploymentManagerImpl.wrapHandlers(wrappedHandlers, deploymentInfo.getInnerHandlerChainWrappers());
            if (!deploymentInfo.isSecurityDisabled()) {
                HttpHandler securityHandler = this.setupSecurityHandlers(wrappedHandlers);
                wrappedHandlers = new PredicateHandler(DispatcherTypePredicate.REQUEST, securityHandler, wrappedHandlers);
            }
            HttpHandler outerHandlers = DeploymentManagerImpl.wrapHandlers(wrappedHandlers, deploymentInfo.getOuterHandlerChainWrappers());
            wrappedHandlers = new PredicateHandler(DispatcherTypePredicate.REQUEST, outerHandlers, wrappedHandlers);
            wrappedHandlers = this.handleDevelopmentModePersistentSessions(wrappedHandlers, deploymentInfo, deployment.getSessionManager(), servletContext);
            MetricsCollector metrics = deploymentInfo.getMetricsCollector();
            if (metrics != null) {
                wrappedHandlers = new MetricsChainHandler(wrappedHandlers, metrics, deployment);
            }
            if (deploymentInfo.getCrawlerSessionManagerConfig() != null) {
                wrappedHandlers = new CrawlerSessionManagerHandler(deploymentInfo.getCrawlerSessionManagerConfig(), wrappedHandlers);
            }
            ServletInitialHandler servletInitialHandler = SecurityActions.createServletInitialHandler(deployment.getServletPaths(), wrappedHandlers, deployment.getThreadSetupAction(), servletContext);
            HttpHandler initialHandler = DeploymentManagerImpl.wrapHandlers(servletInitialHandler, deployment.getDeploymentInfo().getInitialHandlerChainWrappers());
            initialHandler = new HttpContinueReadHandler(initialHandler);
            if (deploymentInfo.getUrlEncoding() != null) {
                initialHandler = Handlers.urlDecodingHandler(deploymentInfo.getUrlEncoding(), initialHandler);
            }
            deployment.setInitialHandler(initialHandler);
            deployment.setServletHandler(servletInitialHandler);
            deployment.getServletPaths().invalidate();
            servletContext.initDone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            handle.tearDown();
        }
        this.state = DeploymentManager.State.DEPLOYED;
    }

    private void createServletsAndFilters(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        for (Map.Entry<String, ServletInfo> entry : deploymentInfo.getServlets().entrySet()) {
            deployment.getServlets().addServlet(entry.getValue());
        }
        for (Map.Entry<String, Cloneable> entry : deploymentInfo.getFilters().entrySet()) {
            deployment.getFilters().addFilter((FilterInfo)entry.getValue());
        }
    }

    private void handleExtensions(DeploymentInfo deploymentInfo, ServletContextImpl servletContext) {
        HashSet loadedExtensions = new HashSet();
        for (ServletExtension extension : ServiceLoader.load(ServletExtension.class, deploymentInfo.getClassLoader())) {
            loadedExtensions.add(extension.getClass());
            extension.handleDeployment(deploymentInfo, servletContext);
        }
        if (!ServletExtension.class.getClassLoader().equals(deploymentInfo.getClassLoader())) {
            for (ServletExtension extension : ServiceLoader.load(ServletExtension.class)) {
                if (loadedExtensions.contains(extension.getClass())) continue;
                extension.handleDeployment(deploymentInfo, servletContext);
            }
        }
        for (ServletExtension extension : deploymentInfo.getServletExtensions()) {
            extension.handleDeployment(deploymentInfo, servletContext);
        }
    }

    private HttpHandler setupSecurityHandlers(HttpHandler initialHandler) {
        SecurityContextFactory contextFactory;
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        HashMap<String, AuthenticationMechanismFactory> factoryMap = new HashMap<String, AuthenticationMechanismFactory>(deploymentInfo.getAuthenticationMechanisms());
        IdentityManager identityManager = deploymentInfo.getIdentityManager();
        if (!factoryMap.containsKey("BASIC")) {
            factoryMap.put("BASIC", new BasicAuthenticationMechanism.Factory(identityManager));
        }
        if (!factoryMap.containsKey("FORM")) {
            factoryMap.put("FORM", new ServletFormAuthenticationMechanism.Factory(identityManager));
        }
        if (!factoryMap.containsKey("DIGEST")) {
            factoryMap.put("DIGEST", new DigestAuthenticationMechanism.Factory(identityManager));
        }
        if (!factoryMap.containsKey("CLIENT_CERT")) {
            factoryMap.put("CLIENT_CERT", new ClientCertAuthenticationMechanism.Factory(identityManager));
        }
        if (!factoryMap.containsKey("EXTERNAL")) {
            factoryMap.put("EXTERNAL", new ExternalAuthenticationMechanism.Factory(identityManager));
        }
        if (!factoryMap.containsKey("GENERIC_HEADER")) {
            factoryMap.put("GENERIC_HEADER", new GenericHeaderAuthenticationMechanism.Factory(identityManager));
        }
        HttpHandler current = initialHandler;
        current = new SSLInformationAssociationHandler(current);
        SecurityPathMatches securityPathMatches = this.buildSecurityConstraints();
        current = new ServletAuthenticationCallHandler(current);
        for (HandlerWrapper wrapper : deploymentInfo.getSecurityWrappers()) {
            current = wrapper.wrap(current);
        }
        if (deploymentInfo.isDisableCachingForSecuredPages()) {
            current = Handlers.predicate(Predicates.authRequired(), Handlers.disableCache(current), current);
        }
        if (!securityPathMatches.isEmpty()) {
            current = new ServletAuthenticationConstraintHandler(current);
        }
        current = new ServletConfidentialityConstraintHandler(deploymentInfo.getConfidentialPortManager(), current);
        if (!securityPathMatches.isEmpty()) {
            current = new ServletSecurityConstraintHandler(securityPathMatches, current);
        }
        LinkedList<AuthenticationMechanism> authenticationMechanisms = new LinkedList<AuthenticationMechanism>();
        authenticationMechanisms.add(new CachedAuthenticatedSessionMechanism(identityManager));
        String mechName = null;
        if (loginConfig != null || deploymentInfo.getJaspiAuthenticationMechanism() != null) {
            FormParserFactory parser = FormParserFactory.builder(false).addParser(new FormEncodedDataDefinition().setDefaultEncoding(deploymentInfo.getDefaultEncoding())).build();
            List<Object> authMethods = Collections.emptyList();
            if (loginConfig != null) {
                authMethods = loginConfig.getAuthMethods();
            }
            for (AuthMethodConfig method : authMethods) {
                AuthenticationMechanismFactory factory = (AuthenticationMechanismFactory)factoryMap.get(method.getName());
                if (factory == null) {
                    throw UndertowServletMessages.MESSAGES.unknownAuthenticationMechanism(method.getName());
                }
                if (mechName == null) {
                    mechName = method.getName();
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("context_path", deploymentInfo.getContextPath());
                properties.put("realm", loginConfig.getRealmName());
                properties.put("error_page", loginConfig.getErrorPage());
                properties.put("login_page", loginConfig.getLoginPage());
                properties.putAll(method.getProperties());
                String name = method.getName().toUpperCase(Locale.US);
                name = name.equals("FORM") ? "FORM" : name;
                name = name.equals("BASIC") ? "BASIC" : name;
                name = name.equals("DIGEST") ? "DIGEST" : name;
                name = name.equals("CLIENT_CERT") ? "CLIENT_CERT" : name;
                authenticationMechanisms.add(factory.create(name, parser, properties));
            }
        }
        this.deployment.setAuthenticationMechanisms(authenticationMechanisms);
        current = deploymentInfo.getJaspiAuthenticationMechanism() == null ? new AuthenticationMechanismsHandler(current, authenticationMechanisms) : new AuthenticationMechanismsHandler(current, Collections.singletonList(deploymentInfo.getJaspiAuthenticationMechanism()));
        current = new CachedAuthenticatedSessionHandler(current, this.deployment.getServletContext());
        List<NotificationReceiver> notificationReceivers = deploymentInfo.getNotificationReceivers();
        if (!notificationReceivers.isEmpty()) {
            current = new NotificationReceiverHandler(current, notificationReceivers);
        }
        if ((contextFactory = deploymentInfo.getSecurityContextFactory()) == null) {
            contextFactory = SecurityContextFactoryImpl.INSTANCE;
        }
        current = new SecurityInitialHandler(deploymentInfo.getAuthenticationMode(), identityManager, mechName, contextFactory, current);
        return current;
    }

    private SecurityPathMatches buildSecurityConstraints() {
        SecurityPathMatches.Builder builder = SecurityPathMatches.builder(this.deployment.getDeploymentInfo());
        HashSet<String> urlPatterns = new HashSet<String>();
        for (SecurityConstraint constraint : this.deployment.getDeploymentInfo().getSecurityConstraints()) {
            builder.addSecurityConstraint(constraint);
            for (WebResourceCollection webResources : constraint.getWebResourceCollections()) {
                urlPatterns.addAll(webResources.getUrlPatterns());
            }
        }
        for (ServletInfo servlet : this.deployment.getDeploymentInfo().getServlets().values()) {
            ServletSecurityInfo securityInfo = servlet.getServletSecurityInfo();
            if (securityInfo == null) continue;
            HashSet<String> mappings = new HashSet<String>(servlet.getMappings());
            mappings.removeAll(urlPatterns);
            if (mappings.isEmpty()) continue;
            HashSet<String> methods = new HashSet<String>();
            for (HttpMethodSecurityInfo method : securityInfo.getHttpMethodSecurityInfo()) {
                methods.add(method.getMethod());
                if (method.getRolesAllowed().isEmpty() && method.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.PERMIT) continue;
                SecurityConstraint newConstraint = ((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addRolesAllowed(method.getRolesAllowed())).setTransportGuaranteeType(method.getTransportGuaranteeType())).addWebResourceCollection(new WebResourceCollection().addUrlPatterns(mappings).addHttpMethod(method.getMethod()));
                builder.addSecurityConstraint(newConstraint);
            }
            if (securityInfo.getRolesAllowed().isEmpty() && securityInfo.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.PERMIT && !methods.isEmpty()) continue;
            SecurityConstraint newConstraint = ((SecurityConstraint)((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().setEmptyRoleSemantic(securityInfo.getEmptyRoleSemantic())).addRolesAllowed(securityInfo.getRolesAllowed())).setTransportGuaranteeType(securityInfo.getTransportGuaranteeType())).addWebResourceCollection(new WebResourceCollection().addUrlPatterns(mappings).addHttpMethodOmissions(methods));
            builder.addSecurityConstraint(newConstraint);
        }
        return builder.build();
    }

    private void initializeTempDir(ServletContextImpl servletContext, DeploymentInfo deploymentInfo) {
        if (deploymentInfo.getTempDir() != null) {
            servletContext.setAttribute("javax.servlet.context.tempdir", deploymentInfo.getTempDir());
        } else {
            servletContext.setAttribute("javax.servlet.context.tempdir", new File(SecurityActions.getSystemProperty("java.io.tmpdir")));
        }
    }

    private void initializeMimeMappings(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        HashMap<String, String> mappings = new HashMap<String, String>(MimeMappings.DEFAULT_MIME_MAPPINGS);
        for (MimeMapping mapping : deploymentInfo.getMimeMappings()) {
            mappings.put(mapping.getExtension().toLowerCase(Locale.ENGLISH), mapping.getMimeType());
        }
        deployment.setMimeExtensionMappings(mappings);
    }

    private void initializeErrorPages(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        HashMap<Integer, String> codes = new HashMap<Integer, String>();
        HashMap<Class<? extends Throwable>, String> exceptions = new HashMap<Class<? extends Throwable>, String>();
        String defaultErrorPage = null;
        for (ErrorPage page : deploymentInfo.getErrorPages()) {
            if (page.getExceptionType() != null) {
                exceptions.put(page.getExceptionType(), page.getLocation());
                continue;
            }
            if (page.getErrorCode() != null) {
                codes.put(page.getErrorCode(), page.getLocation());
                continue;
            }
            if (defaultErrorPage != null) {
                throw UndertowServletMessages.MESSAGES.moreThanOneDefaultErrorPage(defaultErrorPage, page.getLocation());
            }
            defaultErrorPage = page.getLocation();
        }
        deployment.setErrorPages(new ErrorPages(codes, exceptions, defaultErrorPage));
    }

    private ApplicationListeners createListeners() {
        ArrayList<ManagedListener> managedListeners = new ArrayList<ManagedListener>();
        for (ListenerInfo listener : this.deployment.getDeploymentInfo().getListeners()) {
            managedListeners.add(new ManagedListener(listener, false));
        }
        return new ApplicationListeners(managedListeners, this.deployment.getServletContext());
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpHandler start() throws ServletException {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            this.deployment.getSessionManager().start();
            ArrayList<Lifecycle> lifecycles = new ArrayList<Lifecycle>(this.deployment.getLifecycleObjects());
            for (Lifecycle object : lifecycles) {
                object.start();
            }
            HttpHandler root = this.deployment.getHandler();
            TreeMap<Integer, ArrayList<ManagedServlet>> loadOnStartup = new TreeMap<Integer, ArrayList<ManagedServlet>>();
            for (Map.Entry<String, ServletHandler> entry : this.deployment.getServlets().getServletHandlers().entrySet()) {
                ManagedServlet servlet = entry.getValue().getManagedServlet();
                Integer loadOnStartupNumber = servlet.getServletInfo().getLoadOnStartup();
                if (loadOnStartupNumber == null || loadOnStartupNumber < 0) continue;
                ArrayList<ManagedServlet> list = (ArrayList<ManagedServlet>)loadOnStartup.get(loadOnStartupNumber);
                if (list == null) {
                    list = new ArrayList<ManagedServlet>();
                    loadOnStartup.put(loadOnStartupNumber, list);
                }
                list.add(servlet);
            }
            for (Map.Entry<String, ServletHandler> entry : loadOnStartup.entrySet()) {
                for (ManagedServlet servlet : (List)((Object)entry.getValue())) {
                    servlet.createServlet();
                }
            }
            if (this.deployment.getDeploymentInfo().isEagerFilterInit()) {
                for (ManagedFilter managedFilter : this.deployment.getFilters().getFilters().values()) {
                    managedFilter.createFilter();
                }
            }
            this.state = DeploymentManager.State.STARTED;
            Iterator<ManagedFilter> iterator = root;
            return iterator;
        }
        finally {
            handle.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ServletException {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            for (Lifecycle object : this.deployment.getLifecycleObjects()) {
                object.stop();
            }
            this.deployment.getSessionManager().stop();
        }
        finally {
            handle.tearDown();
        }
        this.state = DeploymentManager.State.DEPLOYED;
    }

    private HttpHandler handleDevelopmentModePersistentSessions(HttpHandler next, DeploymentInfo deploymentInfo, SessionManager sessionManager, ServletContextImpl servletContext) {
        SessionPersistenceManager sessionPersistenceManager = deploymentInfo.getSessionPersistenceManager();
        if (sessionPersistenceManager != null) {
            SessionRestoringHandler handler = new SessionRestoringHandler(this.deployment.getDeploymentInfo().getDeploymentName(), sessionManager, servletContext, next, sessionPersistenceManager);
            this.deployment.addLifecycleObjects(handler);
            return handler;
        }
        return next;
    }

    public void handleDeploymentSessionConfig(DeploymentInfo deploymentInfo, ServletContextImpl servletContext) {
        SessionCookieConfigImpl sessionCookieConfig = servletContext.getSessionCookieConfig();
        ServletSessionConfig sc = deploymentInfo.getServletSessionConfig();
        if (sc != null) {
            sessionCookieConfig.setName(sc.getName());
            sessionCookieConfig.setComment(sc.getComment());
            sessionCookieConfig.setDomain(sc.getDomain());
            sessionCookieConfig.setHttpOnly(sc.isHttpOnly());
            sessionCookieConfig.setMaxAge(sc.getMaxAge());
            if (sc.getPath() != null) {
                sessionCookieConfig.setPath(sc.getPath());
            } else {
                sessionCookieConfig.setPath(deploymentInfo.getContextPath());
            }
            sessionCookieConfig.setSecure(sc.isSecure());
            if (sc.getSessionTrackingModes() != null) {
                servletContext.setDefaultSessionTrackingModes(new HashSet<SessionTrackingMode>(sc.getSessionTrackingModes()));
            }
        }
    }

    @Override
    public void undeploy() {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            this.deployment.destroy();
            this.deployment = null;
        }
        finally {
            handle.tearDown();
        }
        this.state = DeploymentManager.State.UNDEPLOYED;
    }

    @Override
    public DeploymentManager.State getState() {
        return this.state;
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }
}

