/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.UndertowLogger;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ssl.UndertowSslConnection;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;

public class SslConduit
implements StreamSourceConduit,
StreamSinkConduit {
    private static final int FLAG_READ_REQUIRES_WRITE = 1;
    private static final int FLAG_WRITE_REQUIRES_READ = 2;
    private static final int FLAG_READS_RESUMED = 4;
    private static final int FLAG_WRITES_RESUMED = 8;
    private static final int FLAG_DATA_TO_UNWRAP = 16;
    private static final int FLAG_READ_SHUTDOWN = 32;
    private static final int FLAG_WRITE_SHUTDOWN = 64;
    private static final int FLAG_ENGINE_INBOUND_SHUTDOWN = 128;
    private static final int FLAG_ENGINE_OUTBOUND_SHUTDOWN = 256;
    private static final int FLAG_DELEGATE_SINK_SHUTDOWN = 512;
    private static final int FLAG_DELEGATE_SOURCE_SHUTDOWN = 1024;
    private static final int FLAG_IN_HANDSHAKE = 2048;
    private static final int FLAG_CLOSED = 4096;
    private static final int FLAG_WRITE_CLOSED = 8192;
    private static final int FLAG_READ_CLOSED = 16384;
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final UndertowSslConnection connection;
    private final StreamConnection delegate;
    private final SSLEngine engine;
    private final StreamSinkConduit sink;
    private final StreamSourceConduit source;
    private final ByteBufferPool bufferPool;
    private final Runnable handshakeCallback;
    private int state = 0;
    private volatile int outstandingTasks = 0;
    private PooledByteBuffer wrappedData;
    private PooledByteBuffer dataToUnwrap;
    private PooledByteBuffer unwrappedData;
    private SslWriteReadyHandler writeReadyHandler;
    private SslReadReadyHandler readReadyHandler;
    private boolean invokingReadListenerHandshake = false;

    SslConduit(UndertowSslConnection connection, StreamConnection delegate, SSLEngine engine, ByteBufferPool bufferPool, Runnable handshakeCallback) {
        this.connection = connection;
        this.delegate = delegate;
        this.handshakeCallback = handshakeCallback;
        this.sink = delegate.getSinkChannel().getConduit();
        this.source = delegate.getSourceChannel().getConduit();
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.readReadyHandler = new SslReadReadyHandler(null);
        delegate.getSourceChannel().getConduit().setReadReadyHandler(this.readReadyHandler);
        this.writeReadyHandler = new SslWriteReadyHandler(null);
        delegate.getSinkChannel().getConduit().setWriteReadyHandler(this.writeReadyHandler);
        this.state = engine.getUseClientMode() ? 2049 : 2050;
    }

    @Override
    public void terminateReads() throws IOException {
        this.state |= 0x20;
        this.notifyReadClosed();
    }

    @Override
    public boolean isReadShutdown() {
        return Bits.anyAreSet(this.state, 32);
    }

    @Override
    public void resumeReads() {
        if (Bits.anyAreSet(this.state, 4)) {
            return;
        }
        this.resumeReads(false);
    }

    @Override
    public void suspendReads() {
        this.state &= 0xFFFFFFFB;
        if (!Bits.allAreSet(this.state, 10)) {
            this.delegate.getSourceChannel().suspendReads();
        }
    }

    @Override
    public void wakeupReads() {
        this.resumeReads(true);
    }

    private void resumeReads(boolean wakeup) {
        this.state |= 4;
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.getSinkChannel().resumeWrites();
        } else if (Bits.anyAreSet(this.state, 16) || wakeup) {
            this.runReadListener(true);
        } else {
            this.delegate.getSourceChannel().resumeReads();
        }
    }

    private void runReadListener(final boolean resumeInListener) {
        try {
            this.delegate.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    if (resumeInListener && Bits.allAreSet(SslConduit.this.state, 4)) {
                        SslConduit.this.delegate.getSourceChannel().resumeReads();
                    }
                    SslConduit.this.readReadyHandler.readReady();
                }
            });
        }
        catch (Exception e) {
            IoUtils.safeClose(this.connection, this.delegate);
            UndertowLogger.REQUEST_IO_LOGGER.debugf((Throwable)e, "Failed to queue read listener invocation", new Object[0]);
        }
    }

    private void runWriteListener() {
        try {
            this.delegate.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    SslConduit.this.writeReadyHandler.writeReady();
                }
            });
        }
        catch (Exception e) {
            IoUtils.safeClose(this.connection, this.delegate);
            UndertowLogger.REQUEST_IO_LOGGER.debugf((Throwable)e, "Failed to queue read listener invocation", new Object[0]);
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.anyAreSet(this.state, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable() throws IOException {
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            if (this.outstandingTasks > 0) {
                try {
                    this.wait();
                    return;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
        if (this.unwrappedData != null) {
            return;
        }
        if (Bits.anyAreSet(this.state, 16)) {
            return;
        }
        if (Bits.anyAreSet(this.state, 1)) {
            this.awaitWritable();
            return;
        }
        this.source.awaitReadable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            if (this.outstandingTasks > 0) {
                try {
                    this.wait(timeUnit.toMillis(time));
                    return;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
        if (this.unwrappedData != null) {
            return;
        }
        if (Bits.anyAreSet(this.state, 16)) {
            return;
        }
        if (Bits.anyAreSet(this.state, 1)) {
            this.awaitWritable(time, timeUnit);
            return;
        }
        this.source.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioIoThread getReadThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = new SslReadReadyHandler(handler);
        this.delegate.getSourceChannel().getConduit().setReadReadyHandler(this.readReadyHandler);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 64)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(this.state, 64)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 64)) {
            throw new ClosedChannelException();
        }
        return (int)this.doWrap(new ByteBuffer[]{src}, 0, 1);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (Bits.anyAreSet(this.state, 64)) {
            throw new ClosedChannelException();
        }
        return this.doWrap(srcs, offs, len);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 64)) {
            throw new ClosedChannelException();
        }
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public void terminateWrites() throws IOException {
        this.state |= 0x40;
    }

    @Override
    public boolean isWriteShutdown() {
        return false;
    }

    @Override
    public void resumeWrites() {
        this.state |= 8;
        if (Bits.anyAreSet(this.state, 2)) {
            this.delegate.getSourceChannel().resumeReads();
        } else {
            this.delegate.getSinkChannel().resumeWrites();
        }
    }

    @Override
    public void suspendWrites() {
        this.state &= 0xFFFFFFF7;
        if (!Bits.allAreSet(this.state, 5)) {
            this.delegate.getSinkChannel().suspendWrites();
        }
    }

    @Override
    public void wakeupWrites() {
        this.state |= 8;
        this.getWriteThread().execute(new Runnable(){

            @Override
            public void run() {
                SslConduit.this.resumeWrites();
                SslConduit.this.writeReadyHandler.writeReady();
            }
        });
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.anyAreSet(this.state, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable() throws IOException {
        if (Bits.anyAreSet(this.state, 64)) {
            return;
        }
        if (this.outstandingTasks > 0) {
            SslConduit sslConduit = this;
            synchronized (sslConduit) {
                if (this.outstandingTasks > 0) {
                    try {
                        this.wait();
                        return;
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
        }
        if (Bits.anyAreSet(this.state, 2)) {
            this.awaitReadable();
            return;
        }
        this.sink.awaitWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet(this.state, 64)) {
            return;
        }
        if (this.outstandingTasks > 0) {
            SslConduit sslConduit = this;
            synchronized (sslConduit) {
                if (this.outstandingTasks > 0) {
                    try {
                        this.wait(timeUnit.toMillis(time));
                        return;
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
        }
        if (Bits.anyAreSet(this.state, 2)) {
            this.awaitReadable(time, timeUnit);
            return;
        }
        this.sink.awaitWritable();
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = new SslWriteReadyHandler(handler);
        this.delegate.getSinkChannel().getConduit().setWriteReadyHandler(this.writeReadyHandler);
    }

    @Override
    public void truncateWrites() throws IOException {
        try {
            this.notifyWriteClosed();
        }
        finally {
            this.delegate.getSinkChannel().close();
        }
    }

    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 512)) {
            return this.sink.flush();
        }
        if (this.wrappedData != null) {
            this.doWrap(null, 0, 0);
            if (this.wrappedData != null) {
                return false;
            }
        }
        if (Bits.allAreSet(this.state, 64)) {
            if (Bits.allAreClear(this.state, 256)) {
                this.state |= 0x100;
                this.engine.closeOutbound();
                this.doWrap(null, 0, 0);
                if (this.wrappedData != null) {
                    return false;
                }
            } else if (this.wrappedData != null && Bits.allAreClear(this.state, 512)) {
                this.doWrap(null, 0, 0);
                if (this.wrappedData != null) {
                    return false;
                }
            }
            if (Bits.allAreClear(this.state, 512)) {
                this.sink.terminateWrites();
                this.state |= 0x200;
            }
        }
        return this.sink.flush();
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        if (Bits.anyAreSet(this.state, 32)) {
            return -1L;
        }
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (Bits.anyAreSet(this.state, 32)) {
            return -1L;
        }
        return IoUtils.transfer(new ConduitReadableByteChannel(this), count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (Bits.anyAreSet(this.state, 32)) {
            return -1;
        }
        return (int)this.doUnwrap(new ByteBuffer[]{dst}, 0, 1);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        if (Bits.anyAreSet(this.state, 32)) {
            return -1L;
        }
        return this.doUnwrap(dsts, offs, len);
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    void notifyWriteClosed() {
        if (Bits.anyAreSet(this.state, 8192)) {
            return;
        }
        boolean runListener = this.isWriteResumed() && Bits.anyAreSet(this.state, 4096);
        this.connection.writeClosed();
        this.engine.closeOutbound();
        this.state |= 0x2100;
        if (Bits.anyAreSet(this.state, 16384)) {
            this.closed();
        }
        if (Bits.anyAreSet(this.state, 1)) {
            this.notifyReadClosed();
        }
        this.state &= 0xFFFFFFFD;
        if (runListener) {
            this.runWriteListener();
        }
    }

    void notifyReadClosed() {
        if (Bits.anyAreSet(this.state, 16384)) {
            return;
        }
        boolean runListener = this.isReadResumed() && Bits.anyAreSet(this.state, 4096);
        this.connection.readClosed();
        try {
            this.engine.closeInbound();
        }
        catch (SSLException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(e));
        }
        this.state |= 0x4080;
        if (Bits.anyAreSet(this.state, 8192)) {
            this.closed();
        }
        if (Bits.anyAreSet(this.state, 2)) {
            this.notifyWriteClosed();
        }
        if (runListener) {
            this.runReadListener(false);
        }
    }

    public void startHandshake() throws SSLException {
        this.state |= 1;
        this.engine.beginHandshake();
    }

    public SSLSession getSslSession() {
        return this.engine.getSession();
    }

    private void doHandshake() throws IOException {
        this.doUnwrap(null, 0, 0);
        this.doWrap(null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doUnwrap(ByteBuffer[] userBuffers, int off, int len) throws IOException {
        PooledByteBuffer unwrappedData;
        if (Bits.anyAreSet(this.state, 4096)) {
            throw new ClosedChannelException();
        }
        if (this.outstandingTasks > 0) {
            return 0L;
        }
        if (Bits.anyAreSet(this.state, 1)) {
            this.doWrap(null, 0, 0);
            if (Bits.allAreClear(this.state, 2)) {
                return 0L;
            }
        }
        if ((unwrappedData = this.unwrappedData) != null && userBuffers != null) {
            long copied = Buffers.copy(userBuffers, off, len, unwrappedData.getBuffer());
            if (!unwrappedData.getBuffer().hasRemaining()) {
                unwrappedData.close();
                this.unwrappedData = null;
            }
            return copied;
        }
        try {
            SSLEngineResult result;
            if (Bits.allAreClear(this.state, 16)) {
                int res;
                if (this.dataToUnwrap == null) {
                    this.dataToUnwrap = this.bufferPool.allocate();
                }
                try {
                    res = this.source.read(this.dataToUnwrap.getBuffer());
                }
                catch (IOException e) {
                    this.dataToUnwrap.close();
                    this.dataToUnwrap = null;
                    throw e;
                }
                this.dataToUnwrap.getBuffer().flip();
                if (res == -1) {
                    this.dataToUnwrap.close();
                    this.dataToUnwrap = null;
                    this.notifyReadClosed();
                    long l = -1L;
                    return l;
                }
                if (res == 0 && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                    long l = 0L;
                    return l;
                }
            }
            int dataToUnwrapLength = this.dataToUnwrap.getBuffer().remaining();
            long original = 0L;
            if (userBuffers != null) {
                original = Buffers.remaining(userBuffers);
            }
            boolean unwrapBufferUsed = false;
            try {
                if (userBuffers != null) {
                    result = this.engine.unwrap(this.dataToUnwrap.getBuffer(), userBuffers, off, len);
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        unwrappedData = this.bufferPool.allocate();
                        ByteBuffer[] d = new ByteBuffer[len + 1];
                        System.arraycopy(userBuffers, off, d, 0, len);
                        d[len] = unwrappedData.getBuffer();
                        result = this.engine.unwrap(this.dataToUnwrap.getBuffer(), d);
                        unwrapBufferUsed = true;
                    }
                } else {
                    unwrapBufferUsed = true;
                    if (unwrappedData == null) {
                        unwrappedData = this.bufferPool.allocate();
                    } else {
                        unwrappedData.getBuffer().compact();
                    }
                    result = this.engine.unwrap(this.dataToUnwrap.getBuffer(), unwrappedData.getBuffer());
                }
            }
            finally {
                if (unwrapBufferUsed) {
                    unwrappedData.getBuffer().flip();
                    if (!unwrappedData.getBuffer().hasRemaining()) {
                        unwrappedData.close();
                        unwrappedData = null;
                    }
                }
                this.unwrappedData = unwrappedData;
            }
            if (!this.handleHandshakeResult(result)) {
                if (this.dataToUnwrap.getBuffer().hasRemaining() && result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && this.dataToUnwrap.getBuffer().remaining() != dataToUnwrapLength) {
                    this.state |= 0x10;
                }
                long l = 0L;
                return l;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.notifyReadClosed();
                long l = -1L;
                return l;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.state &= 0xFFFFFFEF;
            } else {
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    throw new IOException("overflow");
                }
                this.state = this.dataToUnwrap.getBuffer().hasRemaining() && this.dataToUnwrap.getBuffer().remaining() != dataToUnwrapLength ? (this.state |= 0x10) : (this.state &= 0xFFFFFFEF);
            }
            if (userBuffers == null) {
                long l = 0L;
                return l;
            }
            long l = original - Buffers.remaining(userBuffers);
            return l;
        }
        finally {
            try {
                boolean requiresListenerInvocation = false;
                if (unwrappedData != null && unwrappedData.getBuffer().hasRemaining()) {
                    requiresListenerInvocation = true;
                }
                if (this.dataToUnwrap != null) {
                    if (!this.dataToUnwrap.getBuffer().hasRemaining()) {
                        this.dataToUnwrap.close();
                        this.dataToUnwrap = null;
                        this.state &= 0xFFFFFFEF;
                    } else if (Bits.allAreClear(this.state, 16)) {
                        this.dataToUnwrap.getBuffer().compact();
                    } else {
                        requiresListenerInvocation = true;
                    }
                }
                if (requiresListenerInvocation && Bits.anyAreSet(this.state, 4) && !this.invokingReadListenerHandshake) {
                    this.runReadListener(false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doWrap(ByteBuffer[] userBuffers, int off, int len) throws IOException {
        if (Bits.anyAreSet(this.state, 4096)) {
            throw new ClosedChannelException();
        }
        if (this.outstandingTasks > 0) {
            return 0L;
        }
        if (Bits.anyAreSet(this.state, 2)) {
            this.doUnwrap(null, 0, 0);
            if (Bits.allAreClear(this.state, 1)) {
                return 0L;
            }
        }
        if (this.wrappedData != null) {
            int res = this.sink.write(this.wrappedData.getBuffer());
            if (res == 0 || this.wrappedData.getBuffer().hasRemaining()) {
                return 0L;
            }
            this.wrappedData.getBuffer().clear();
        } else {
            this.wrappedData = this.bufferPool.allocate();
        }
        try {
            SSLEngineResult result = null;
            while (result == null || result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP && result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (userBuffers == null) {
                    result = this.engine.wrap(EMPTY_BUFFER, this.wrappedData.getBuffer());
                    continue;
                }
                result = this.engine.wrap(userBuffers, off, len, this.wrappedData.getBuffer());
            }
            this.wrappedData.getBuffer().flip();
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                throw new IOException("underflow");
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && !this.wrappedData.getBuffer().hasRemaining()) {
                throw new IOException("overflow");
            }
            if (this.wrappedData.getBuffer().hasRemaining()) {
                this.sink.write(this.wrappedData.getBuffer());
            }
            if (this.wrappedData.getBuffer().hasRemaining()) {
                long l = result.bytesConsumed();
                return l;
            }
            if (!this.handleHandshakeResult(result)) {
                long l = 0L;
                return l;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED && userBuffers != null) {
                this.notifyWriteClosed();
                throw new ClosedChannelException();
            }
            long l = result.bytesConsumed();
            return l;
        }
        finally {
            if (this.wrappedData != null && !this.wrappedData.getBuffer().hasRemaining()) {
                this.wrappedData.close();
                this.wrappedData = null;
            }
        }
    }

    private boolean handleHandshakeResult(SSLEngineResult result) throws IOException {
        switch (result.getHandshakeStatus()) {
            case NEED_TASK: {
                this.state |= 0x800;
                this.clearReadRequiresWrite();
                this.clearWriteRequiresRead();
                this.runTasks();
                return false;
            }
            case NEED_UNWRAP: {
                this.clearReadRequiresWrite();
                this.state |= 0x802;
                this.sink.suspendWrites();
                if (Bits.anyAreSet(this.state, 8)) {
                    this.source.resumeReads();
                }
                return false;
            }
            case NEED_WRAP: {
                this.clearWriteRequiresRead();
                this.state |= 0x801;
                this.source.suspendReads();
                if (Bits.anyAreSet(this.state, 4)) {
                    this.sink.resumeWrites();
                }
                return false;
            }
            case FINISHED: {
                if (!Bits.anyAreSet(this.state, 2048)) break;
                this.state &= 0xFFFFF7FF;
                this.handshakeCallback.run();
            }
        }
        this.clearReadRequiresWrite();
        this.clearWriteRequiresRead();
        return true;
    }

    private void clearReadRequiresWrite() {
        if (Bits.anyAreSet(this.state, 1)) {
            this.state &= 0xFFFFFFFE;
            if (Bits.anyAreSet(this.state, 4)) {
                this.resumeReads(false);
            }
            if (Bits.allAreClear(this.state, 8)) {
                this.sink.suspendWrites();
            }
        }
    }

    private void clearWriteRequiresRead() {
        if (Bits.anyAreSet(this.state, 2)) {
            this.state &= 0xFFFFFFFD;
            if (Bits.anyAreSet(this.state, 8)) {
                this.wakeupWrites();
            }
            if (Bits.allAreClear(this.state, 4)) {
                this.source.suspendReads();
            }
        }
    }

    private void closed() {
        if (Bits.anyAreSet(this.state, 4096)) {
            return;
        }
        this.state |= 0x1660;
        this.notifyReadClosed();
        this.notifyWriteClosed();
        if (this.dataToUnwrap != null) {
            this.dataToUnwrap.close();
            this.dataToUnwrap = null;
        }
        if (this.unwrappedData != null) {
            this.unwrappedData.close();
            this.unwrappedData = null;
        }
        if (this.wrappedData != null) {
            this.wrappedData.close();
            this.wrappedData = null;
        }
        if (Bits.allAreClear(this.state, 256)) {
            this.engine.closeOutbound();
        }
        if (Bits.allAreClear(this.state, 128)) {
            try {
                this.engine.closeInbound();
            }
            catch (SSLException e) {
                UndertowLogger.REQUEST_LOGGER.ioException(e);
            }
        }
        IoUtils.safeClose((Closeable)this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        this.delegate.getSinkChannel().suspendWrites();
        this.delegate.getSourceChannel().suspendReads();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        Runnable t = this.engine.getDelegatedTask();
        while (t != null) {
            tasks.add(t);
            t = this.engine.getDelegatedTask();
        }
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            this.outstandingTasks += tasks.size();
            for (final Runnable task : tasks) {
                this.getWorker().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SslConduit sslConduit;
                        try {
                            task.run();
                            sslConduit = SslConduit.this;
                        }
                        catch (Throwable throwable) {
                            SslConduit sslConduit2 = SslConduit.this;
                            synchronized (sslConduit2) {
                                if (SslConduit.this.outstandingTasks == 1) {
                                    SslConduit.this.getWriteThread().execute(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            SslConduit sslConduit = SslConduit.this;
                                            synchronized (sslConduit) {
                                                SslConduit.this.notifyAll();
                                                --SslConduit.this.outstandingTasks;
                                                try {
                                                    SslConduit.this.doHandshake();
                                                }
                                                catch (IOException e) {
                                                    IoUtils.safeClose((Closeable)SslConduit.this.connection);
                                                }
                                                if (Bits.anyAreSet(SslConduit.this.state, 4)) {
                                                    SslConduit.this.wakeupReads();
                                                }
                                                if (Bits.anyAreSet(SslConduit.this.state, 8)) {
                                                    SslConduit.this.resumeWrites();
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    SslConduit.this.outstandingTasks--;
                                }
                            }
                            throw throwable;
                        }
                        synchronized (sslConduit) {
                            if (SslConduit.this.outstandingTasks == 1) {
                                SslConduit.this.getWriteThread().execute(new /* invalid duplicate definition of identical inner class */);
                            } else {
                                SslConduit.this.outstandingTasks--;
                            }
                        }
                    }
                });
            }
        }
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    public void close() {
        this.closed();
    }

    public String toString() {
        return "SslConduit{state=" + this.state + ", outstandingTasks=" + this.outstandingTasks + ", wrappedData=" + this.wrappedData + ", dataToUnwrap=" + this.dataToUnwrap + ", unwrappedData=" + this.unwrappedData + '}';
    }

    private class SslWriteReadyHandler
    implements WriteReadyHandler {
        private final WriteReadyHandler delegateHandler;

        private SslWriteReadyHandler(WriteReadyHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        @Override
        public void forceTermination() {
            try {
                if (this.delegateHandler != null) {
                    this.delegateHandler.forceTermination();
                }
            }
            finally {
                IoUtils.safeClose((Closeable)SslConduit.this.delegate);
            }
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(SslConduit.this.connection.getSinkChannel(), SslConduit.this.connection.getSinkChannel().getCloseListener());
        }

        @Override
        public void writeReady() {
            if (Bits.anyAreSet(SslConduit.this.state, 1)) {
                if (Bits.anyAreSet(SslConduit.this.state, 4)) {
                    SslConduit.this.readReadyHandler.readReady();
                } else {
                    try {
                        SslConduit.this.doHandshake();
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_LOGGER.ioException(e);
                        IoUtils.safeClose((Closeable)SslConduit.this.delegate);
                    }
                }
            }
            if (Bits.anyAreSet(SslConduit.this.state, 8)) {
                if (this.delegateHandler == null) {
                    ChannelListener<? super ConduitStreamSinkChannel> writeListener = SslConduit.this.connection.getSinkChannel().getWriteListener();
                    if (writeListener == null) {
                        SslConduit.this.suspendWrites();
                    } else {
                        ChannelListeners.invokeChannelListener(SslConduit.this.connection.getSinkChannel(), writeListener);
                    }
                } else {
                    this.delegateHandler.writeReady();
                }
            }
            if (!Bits.anyAreSet(SslConduit.this.state, 9)) {
                SslConduit.this.delegate.getSinkChannel().suspendWrites();
            }
        }
    }

    private class SslReadReadyHandler
    implements ReadReadyHandler {
        private final ReadReadyHandler delegateHandler;

        private SslReadReadyHandler(ReadReadyHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        @Override
        public void readReady() {
            if (Bits.allAreSet(SslConduit.this.state, 10) && !Bits.anyAreSet(SslConduit.this.state, 128)) {
                try {
                    SslConduit.this.invokingReadListenerHandshake = true;
                    SslConduit.this.doHandshake();
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_LOGGER.ioException(e);
                    IoUtils.safeClose((Closeable)SslConduit.this.delegate);
                }
                finally {
                    SslConduit.this.invokingReadListenerHandshake = false;
                }
            }
            boolean noProgress = false;
            int initialUnwrapped = -1;
            if (Bits.anyAreSet(SslConduit.this.state, 4)) {
                if (this.delegateHandler == null) {
                    ChannelListener<? super ConduitStreamSourceChannel> readListener = SslConduit.this.connection.getSourceChannel().getReadListener();
                    if (readListener == null) {
                        SslConduit.this.suspendReads();
                    } else {
                        if (Bits.anyAreSet(SslConduit.this.state, 16)) {
                            initialUnwrapped = SslConduit.this.dataToUnwrap.getBuffer().remaining();
                        }
                        ChannelListeners.invokeChannelListener(SslConduit.this.connection.getSourceChannel(), readListener);
                        if (Bits.anyAreSet(SslConduit.this.state, 16) && initialUnwrapped == SslConduit.this.dataToUnwrap.getBuffer().remaining()) {
                            noProgress = true;
                        }
                    }
                } else {
                    this.delegateHandler.readReady();
                }
            }
            if (!Bits.anyAreSet(SslConduit.this.state, 6)) {
                SslConduit.this.delegate.getSourceChannel().suspendReads();
            } else if (Bits.anyAreSet(SslConduit.this.state, 4) && (SslConduit.this.unwrappedData != null || Bits.anyAreSet(SslConduit.this.state, 16))) {
                if (Bits.anyAreSet(SslConduit.this.state, 16384)) {
                    if (SslConduit.this.unwrappedData != null) {
                        SslConduit.this.unwrappedData.close();
                    }
                    if (SslConduit.this.dataToUnwrap != null) {
                        SslConduit.this.dataToUnwrap.close();
                    }
                    SslConduit.this.unwrappedData = null;
                    SslConduit.this.dataToUnwrap = null;
                } else if (!(Bits.anyAreSet(SslConduit.this.state, 1) && SslConduit.this.wrappedData != null || SslConduit.this.outstandingTasks != 0 || noProgress)) {
                    SslConduit.this.runReadListener(false);
                }
            }
        }

        @Override
        public void forceTermination() {
            try {
                if (this.delegateHandler != null) {
                    this.delegateHandler.forceTermination();
                }
            }
            finally {
                IoUtils.safeClose((Closeable)SslConduit.this.delegate);
            }
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(SslConduit.this.connection.getSourceChannel(), SslConduit.this.connection.getSourceChannel().getCloseListener());
        }
    }
}

