/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.handlers.ServletRequestContext;

class ServletRequestContextThreadSetupAction
implements ThreadSetupAction {
    static final ServletRequestContextThreadSetupAction INSTANCE = new ServletRequestContextThreadSetupAction();

    private ServletRequestContextThreadSetupAction() {
    }

    @Override
    public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
        if (exchange == null) {
            return null;
        }
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        final ServletRequestContext old = ServletRequestContext.current();
        SecurityActions.setCurrentRequestContext(servletRequestContext);
        return new ThreadSetupAction.Handle(){

            @Override
            public void tearDown() {
                ServletRequestContext.setCurrentRequestContext(old);
            }
        };
    }
}

