/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2Stream;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.HeaderMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

public class Http2StreamSourceChannel
extends AbstractHttp2StreamSourceChannel
implements Http2Stream {
    private boolean headersEndStream = false;
    private boolean rst = false;
    private final HeaderMap headers;
    private final int streamId;
    private Http2HeadersStreamSinkChannel response;
    private int flowControlWindow;
    private ChannelListener<Http2StreamSourceChannel> completionListener;
    private boolean ignoreForceClose = false;

    Http2StreamSourceChannel(Http2Channel framedChannel, PooledByteBuffer data, long frameDataRemaining, HeaderMap headers, int streamId) {
        super(framedChannel, data, frameDataRemaining);
        this.headers = headers;
        this.streamId = streamId;
        this.flowControlWindow = framedChannel.getInitialReceiveWindowSize();
    }

    @Override
    protected void handleHeaderData(FrameHeaderData headerData) {
        Http2FrameHeaderParser data = (Http2FrameHeaderParser)headerData;
        this.handleFinalFrame(data);
    }

    void handleFinalFrame(Http2FrameHeaderParser headerData) {
        Http2FrameHeaderParser data = headerData;
        if (data.type == 0) {
            if (Bits.anyAreSet(data.flags, 1)) {
                this.lastFrame();
            }
        } else if (data.type == 1) {
            if (Bits.allAreSet(data.flags, 1)) {
                if (Bits.allAreSet(data.flags, 4)) {
                    this.lastFrame();
                } else {
                    this.headersEndStream = true;
                }
            }
        } else if (this.headersEndStream && data.type == 9 && Bits.anyAreSet(data.flags, 4)) {
            this.lastFrame();
        }
    }

    public Http2HeadersStreamSinkChannel getResponseChannel() {
        if (this.response != null) {
            return this.response;
        }
        this.response = new Http2HeadersStreamSinkChannel(this.getHttp2Channel(), this.streamId);
        this.getHttp2Channel().registerStreamSink(this.response);
        return this.response;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = super.read(dst);
        this.updateFlowControlWindow(read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long read = super.read(dsts, offset, length);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        long read = super.read(dsts);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel streamSinkChannel) throws IOException {
        long read = super.transferTo(count, throughBuffer, streamSinkChannel);
        this.updateFlowControlWindow((int)read + throughBuffer.remaining());
        return read;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long read = super.transferTo(position, count, target);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    private void updateFlowControlWindow(int read) {
        if (read <= 0) {
            return;
        }
        this.flowControlWindow -= read;
        Http2Channel spdyChannel = this.getHttp2Channel();
        spdyChannel.updateReceiveFlowControlWindow(read);
        int initialWindowSize = spdyChannel.getInitialReceiveWindowSize();
        if (this.flowControlWindow < initialWindowSize / 2) {
            int delta = initialWindowSize - this.flowControlWindow;
            this.flowControlWindow += delta;
            spdyChannel.sendUpdateWindowSize(this.streamId, delta);
        }
    }

    @Override
    protected void complete() throws IOException {
        super.complete();
        if (this.completionListener != null) {
            ChannelListeners.invokeChannelListener(this, this.completionListener);
        }
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    public ChannelListener<Http2StreamSourceChannel> getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(ChannelListener<Http2StreamSourceChannel> completionListener) {
        this.completionListener = completionListener;
        if (this.isComplete()) {
            ChannelListeners.invokeChannelListener(this, completionListener);
        }
    }

    @Override
    void rstStream(int error) {
        if (this.rst) {
            return;
        }
        this.rst = true;
        this.markStreamBroken();
    }

    @Override
    protected void channelForciblyClosed() {
        if (this.completionListener != null) {
            this.completionListener.handleEvent(this);
        }
        if (!this.ignoreForceClose) {
            this.getHttp2Channel().sendRstStream(this.streamId, 8);
        }
        this.markStreamBroken();
    }

    public void setIgnoreForceClose(boolean ignoreForceClose) {
        this.ignoreForceClose = ignoreForceClose;
    }

    public boolean isIgnoreForceClose() {
        return this.ignoreForceClose;
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    boolean isHeadersEndStream() {
        return this.headersEndStream;
    }

    public String toString() {
        return "Http2StreamSourceChannel{headers=" + this.headers + '}';
    }
}

