/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.AggregateConnectorStatistics;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.AlpnOpenListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.SslConnection;

class JettyAlpnOpenListener
implements ChannelListener<StreamConnection>,
AlpnOpenListener.AlpnDelegateListener {
    private static final String PROTOCOL_KEY = JettyAlpnOpenListener.class.getName() + ".protocol";
    private final ByteBufferPool bufferPool;
    private final Map<String, ListenerEntry> listeners = new HashMap<String, ListenerEntry>();
    private final String fallbackProtocol;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile boolean statisticsEnabled;

    JettyAlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        this.bufferPool = bufferPool;
        this.fallbackProtocol = fallbackProtocol;
        if (fallbackProtocol != null && fallbackListener != null) {
            this.addProtocol(fallbackProtocol, fallbackListener, 0);
        }
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
        this.undertowOptions = undertowOptions;
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(rootHandler);
        }
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(this.rootHandler);
        }
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            ArrayList<ConnectorStatistics> stats = new ArrayList<ConnectorStatistics>();
            for (Map.Entry<String, ListenerEntry> l : this.listeners.entrySet()) {
                ConnectorStatistics c = l.getValue().listener.getConnectorStatistics();
                if (c == null) continue;
                stats.add(c);
            }
            return new AggregateConnectorStatistics(stats.toArray(new ConnectorStatistics[stats.size()]));
        }
        return null;
    }

    @Override
    public void addProtocol(String name, DelegateOpenListener listener, int weight) {
        this.listeners.put(name, new ListenerEntry(listener, weight));
    }

    @Override
    public void handleEvent(final StreamConnection channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        final AlpnConnectionListener potentialConnection = new AlpnConnectionListener(channel);
        channel.getSourceChannel().setReadListener(potentialConnection);
        final SSLEngine sslEngine = UndertowXnioSsl.getSslEngine((SslConnection)channel);
        ALPN.put((SSLEngine)sslEngine, (ALPN.Provider)new ALPN.ServerProvider(){

            public void unsupported() {
                ALPN.remove((SSLEngine)sslEngine);
                String existing = (String)sslEngine.getHandshakeSession().getValue(PROTOCOL_KEY);
                if (existing == null || !JettyAlpnOpenListener.this.listeners.containsKey(existing)) {
                    if (JettyAlpnOpenListener.this.fallbackProtocol == null) {
                        UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(channel.getPeerAddress());
                        IoUtils.safeClose((Closeable)channel);
                    }
                    potentialConnection.selected = JettyAlpnOpenListener.this.fallbackProtocol;
                } else {
                    potentialConnection.selected = existing;
                }
            }

            public String select(List<String> strings) {
                ALPN.remove((SSLEngine)sslEngine);
                String match = null;
                int lastWeight = -1;
                for (String s : strings) {
                    ListenerEntry listener = (ListenerEntry)JettyAlpnOpenListener.this.listeners.get(s);
                    if (listener == null || listener.weight <= lastWeight) continue;
                    match = s;
                    lastWeight = listener.weight;
                }
                if (match != null) {
                    sslEngine.getHandshakeSession().putValue(PROTOCOL_KEY, match);
                    return potentialConnection.selected = match;
                }
                if (JettyAlpnOpenListener.this.fallbackProtocol == null) {
                    UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(channel.getPeerAddress());
                    IoUtils.safeClose((Closeable)channel);
                    return null;
                }
                sslEngine.getHandshakeSession().putValue(PROTOCOL_KEY, JettyAlpnOpenListener.this.fallbackProtocol);
                potentialConnection.selected = JettyAlpnOpenListener.this.fallbackProtocol;
                return JettyAlpnOpenListener.this.fallbackProtocol;
            }
        });
        potentialConnection.handleEvent(channel.getSourceChannel());
    }

    private class AlpnConnectionListener
    implements ChannelListener<StreamSourceChannel> {
        private String selected;
        private final StreamConnection channel;

        private AlpnConnectionListener(StreamConnection channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(StreamSourceChannel source) {
            PooledByteBuffer buffer = JettyAlpnOpenListener.this.bufferPool.allocate();
            boolean free = true;
            try {
                while (true) {
                    int res;
                    if ((res = this.channel.getSourceChannel().read(buffer.getBuffer())) == -1) {
                        IoUtils.safeClose((Closeable)this.channel);
                        return;
                    }
                    buffer.getBuffer().flip();
                    if (this.selected != null) {
                        DelegateOpenListener listener = ((ListenerEntry)((JettyAlpnOpenListener)JettyAlpnOpenListener.this).listeners.get((Object)this.selected)).listener;
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res > 0) {
                        if (JettyAlpnOpenListener.this.fallbackProtocol == null) {
                            UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                            IoUtils.safeClose((Closeable)this.channel);
                            return;
                        }
                        DelegateOpenListener listener = ((ListenerEntry)((JettyAlpnOpenListener)JettyAlpnOpenListener.this).listeners.get((Object)((JettyAlpnOpenListener)JettyAlpnOpenListener.this).fallbackProtocol)).listener;
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res == 0) {
                        this.channel.getSourceChannel().resumeReads();
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            finally {
                if (free) {
                    buffer.close();
                }
            }
        }
    }

    private static class ListenerEntry {
        DelegateOpenListener listener;
        int weight;

        ListenerEntry(DelegateOpenListener listener, int weight) {
            this.listener = listener;
            this.weight = weight;
        }
    }
}

