/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyStreamStreamSinkChannel;
import io.undertow.server.protocol.framed.FramePriority;
import io.undertow.server.protocol.framed.SendFrameHeader;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

class SpdyFramePriority
implements FramePriority<SpdyChannel, SpdyStreamSourceChannel, SpdyStreamSinkChannel> {
    private int nextId;

    SpdyFramePriority(int nextId) {
        this.nextId = nextId;
    }

    @Override
    public boolean insertFrame(SpdyStreamSinkChannel newFrame, List<SpdyStreamSinkChannel> pendingFrames) {
        boolean incrementIfAccepted = false;
        if (((SpdyChannel)newFrame.getChannel()).isClient() && newFrame instanceof SpdyStreamStreamSinkChannel) {
            int streamId = ((SpdyStreamStreamSinkChannel)newFrame).getStreamId();
            if (streamId > this.nextId) {
                return false;
            }
            if (streamId == this.nextId) {
                incrementIfAccepted = true;
            }
        }
        if (newFrame instanceof SpdyStreamStreamSinkChannel) {
            if (newFrame.isBroken() || !newFrame.isOpen()) {
                return true;
            }
            SendFrameHeader header = ((SpdyStreamStreamSinkChannel)newFrame).generateSendFrameHeader();
            if (header.getByteBuffer() == null) {
                ((SpdyStreamStreamSinkChannel)newFrame).clearHeader();
                return false;
            }
        }
        pendingFrames.add(newFrame);
        if (incrementIfAccepted) {
            this.nextId += 2;
        }
        return true;
    }

    @Override
    public void frameAdded(SpdyStreamSinkChannel addedFrame, List<SpdyStreamSinkChannel> pendingFrames, Deque<SpdyStreamSinkChannel> holdFrames) {
        Iterator<SpdyStreamSinkChannel> it = holdFrames.iterator();
        while (it.hasNext()) {
            SpdyStreamSinkChannel pending = it.next();
            boolean incrementNextId = false;
            if (((SpdyChannel)pending.getChannel()).isClient() && pending instanceof SpdyStreamStreamSinkChannel) {
                int streamId = ((SpdyStreamStreamSinkChannel)pending).getStreamId();
                if (streamId > this.nextId) continue;
                if (streamId == this.nextId) {
                    incrementNextId = true;
                }
            }
            if (!(pending instanceof SpdyStreamStreamSinkChannel)) continue;
            SendFrameHeader header = ((SpdyStreamStreamSinkChannel)pending).generateSendFrameHeader();
            if (header.getByteBuffer() != null) {
                pendingFrames.add(pending);
                it.remove();
                it = holdFrames.iterator();
                if (!incrementNextId) continue;
                this.nextId += 2;
                continue;
            }
            ((SpdyStreamStreamSinkChannel)pending).clearHeader();
        }
    }
}

