/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.Version;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.session.PathParameterSessionConfig;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SslSessionConfig;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.SessionConfigWrapper;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.spec.ContentTypeInfo;
import io.undertow.servlet.spec.FilterRegistrationImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.SecurityActions;
import io.undertow.servlet.spec.ServletRegistrationImpl;
import io.undertow.servlet.spec.SessionCookieConfigImpl;
import io.undertow.servlet.util.EmptyEnumeration;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.util.IteratorEnumeration;
import io.undertow.util.AttachmentKey;
import io.undertow.util.CanonicalPathUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.descriptor.JspConfigDescriptor;

public class ServletContextImpl
implements ServletContext {
    private final ServletContainer servletContainer;
    private final Deployment deployment;
    private volatile DeploymentInfo deploymentInfo;
    private final ConcurrentMap<String, Object> attributes;
    private final SessionCookieConfigImpl sessionCookieConfig;
    private final AttachmentKey<HttpSessionImpl> sessionAttachmentKey = AttachmentKey.create(HttpSessionImpl.class);
    private volatile Set<SessionTrackingMode> sessionTrackingModes = new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL));
    private volatile Set<SessionTrackingMode> defaultSessionTrackingModes = new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL));
    private volatile SessionConfig sessionConfig;
    private volatile boolean initialized = false;
    private int filterMappingUrlPatternInsertPosition = 0;
    private int filterMappingServletNameInsertPosition = 0;
    private final LRUCache<String, ContentTypeInfo> contentTypeCache;

    public ServletContextImpl(ServletContainer servletContainer, Deployment deployment) {
        this.servletContainer = servletContainer;
        this.deployment = deployment;
        this.deploymentInfo = deployment.getDeploymentInfo();
        this.sessionCookieConfig = new SessionCookieConfigImpl(this);
        this.sessionCookieConfig.setPath(this.deploymentInfo.getContextPath());
        this.attributes = this.deploymentInfo.getServletContextAttributeBackingMap() == null ? new ConcurrentHashMap<String, Object>() : this.deploymentInfo.getServletContextAttributeBackingMap();
        this.attributes.putAll(deployment.getDeploymentInfo().getServletContextAttributes());
        this.contentTypeCache = new LRUCache(deployment.getDeploymentInfo().getContentTypeCacheSize(), -1, true);
    }

    public void initDone() {
        SessionConfigWrapper wrapper;
        this.initialized = true;
        Set<SessionTrackingMode> trackingMethods = this.sessionTrackingModes;
        SessionConfig sessionConfig = this.sessionCookieConfig;
        if (trackingMethods != null && !trackingMethods.isEmpty()) {
            if (this.sessionTrackingModes.contains((Object)SessionTrackingMode.SSL)) {
                sessionConfig = new SslSessionConfig(this.deployment.getSessionManager());
            } else if (this.sessionTrackingModes.contains((Object)SessionTrackingMode.COOKIE) && this.sessionTrackingModes.contains((Object)SessionTrackingMode.URL)) {
                this.sessionCookieConfig.setFallback(new PathParameterSessionConfig(this.sessionCookieConfig.getName().toLowerCase(Locale.ENGLISH)));
            } else if (this.sessionTrackingModes.contains((Object)SessionTrackingMode.URL)) {
                sessionConfig = new PathParameterSessionConfig(this.sessionCookieConfig.getName().toLowerCase(Locale.ENGLISH));
            }
        }
        if ((wrapper = this.deploymentInfo.getSessionConfigWrapper()) != null) {
            sessionConfig = wrapper.wrap(sessionConfig, this.deployment);
        }
        this.sessionConfig = new IgnoreInvalidatedSessionConfig(sessionConfig);
    }

    @Override
    public String getContextPath() {
        String contextPath = this.deploymentInfo.getContextPath();
        if (contextPath.equals("/")) {
            return "";
        }
        return contextPath;
    }

    @Override
    public ServletContext getContext(String uripath) {
        DeploymentManager deploymentByPath = this.servletContainer.getDeploymentByPath(uripath);
        if (deploymentByPath == null) {
            return null;
        }
        return deploymentByPath.getDeployment().getServletContext();
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.deploymentInfo.getMajorVersion();
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.deploymentInfo.getMinorVersion();
    }

    @Override
    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        String lower = file.toLowerCase(Locale.ENGLISH);
        int pos = lower.lastIndexOf(46);
        if (pos == -1) {
            return null;
        }
        return this.deployment.getMimeExtensionMappings().get(lower.substring(pos + 1));
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        Resource resource;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null || !resource.isDirectory()) {
            return null;
        }
        HashSet<String> resources = new HashSet<String>();
        for (Resource res : resource.list()) {
            Path file = res.getFilePath();
            if (file == null) continue;
            Path base = res.getResourceManagerRootPath();
            if (base == null) {
                resources.add(file.toString());
                continue;
            }
            String filePath = file.toAbsolutePath().toString().substring(base.toAbsolutePath().toString().length());
            filePath = filePath.replace('\\', '/');
            if (Files.isDirectory(file, new LinkOption[0])) {
                filePath = filePath + "/";
            }
            resources.add(filePath);
        }
        return resources;
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw UndertowServletMessages.MESSAGES.pathMustStartWithSlash(path);
        }
        Resource resource = null;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        return resource.getUrl();
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        Resource resource = null;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        try {
            if (resource.getFile() != null) {
                return new BufferedInputStream(new FileInputStream(resource.getFile()));
            }
            return new BufferedInputStream(resource.getUrl().openStream());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return new RequestDispatcherImpl(path, this);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        ServletChain chain = this.deployment.getServletPaths().getServletHandlerByName(name);
        if (chain != null) {
            return new RequestDispatcherImpl(chain, this);
        }
        return null;
    }

    @Override
    public Servlet getServlet(String name) throws ServletException {
        return this.deployment.getServletPaths().getServletHandlerByName(name).getManagedServlet().getServlet().getInstance();
    }

    @Override
    public Enumeration<Servlet> getServlets() {
        return EmptyEnumeration.instance();
    }

    @Override
    public Enumeration<String> getServletNames() {
        return EmptyEnumeration.instance();
    }

    @Override
    public void log(String msg) {
        UndertowServletLogger.ROOT_LOGGER.info(msg);
    }

    @Override
    public void log(Exception exception, String msg) {
        UndertowServletLogger.ROOT_LOGGER.error(msg, exception);
    }

    @Override
    public void log(String message, Throwable throwable) {
        UndertowServletLogger.ROOT_LOGGER.error(message, throwable);
    }

    @Override
    public String getRealPath(String path) {
        Resource resource;
        if (path == null) {
            return null;
        }
        String canonicalPath = CanonicalPathUtils.canonicalize(path);
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(canonicalPath);
            if (resource == null) {
                Resource deploymentRoot = this.deploymentInfo.getResourceManager().getResource("/");
                if (deploymentRoot == null) {
                    return null;
                }
                Path root = deploymentRoot.getFilePath();
                if (root == null) {
                    return null;
                }
                if (!canonicalPath.startsWith("/")) {
                    canonicalPath = "/" + canonicalPath;
                }
                if (File.separatorChar != '/') {
                    canonicalPath = canonicalPath.replace('/', File.separatorChar);
                }
                return root.toAbsolutePath().toString() + canonicalPath;
            }
        }
        catch (IOException e) {
            return null;
        }
        Path file = resource.getFilePath();
        if (file == null) {
            return null;
        }
        return file.toAbsolutePath().toString();
    }

    @Override
    public String getServerInfo() {
        return this.deploymentInfo.getServerName() + " - " + Version.getVersionString();
    }

    @Override
    public String getInitParameter(String name) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.nullName();
        }
        return this.deploymentInfo.getInitParameters().get(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return new IteratorEnumeration<String>(this.deploymentInfo.getInitParameters().keySet().iterator());
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.deploymentInfo.getInitParameters().containsKey(name)) {
            return false;
        }
        this.deploymentInfo.addInitParameter(name, value);
        return true;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    @Override
    public void setAttribute(String name, Object object) {
        if (object == null) {
            Object existing = this.attributes.remove(name);
            if (this.deployment.getApplicationListeners() != null && existing != null) {
                this.deployment.getApplicationListeners().servletContextAttributeRemoved(name, existing);
            }
        } else {
            Object existing = this.attributes.put(name, object);
            if (this.deployment.getApplicationListeners() != null) {
                if (existing != null) {
                    this.deployment.getApplicationListeners().servletContextAttributeReplaced(name, existing);
                } else {
                    this.deployment.getApplicationListeners().servletContextAttributeAdded(name, object);
                }
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        Object exiting = this.attributes.remove(name);
        this.deployment.getApplicationListeners().servletContextAttributeRemoved(name, exiting);
    }

    @Override
    public String getServletContextName() {
        return this.deploymentInfo.getDisplayName();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        try {
            if (this.deploymentInfo.getServlets().containsKey(servletName)) {
                return null;
            }
            Class<?> servletClass = this.deploymentInfo.getClassLoader().loadClass(className);
            ServletInfo servlet = new ServletInfo(servletName, servletClass, this.deploymentInfo.getClassIntrospecter().createInstanceFactory(servletClass));
            this.readServletAnnotations(servlet);
            this.deploymentInfo.addServlet(servlet);
            ServletHandler handler = this.deployment.getServlets().addServlet(servlet);
            return new ServletRegistrationImpl(servlet, handler.getManagedServlet(), this.deployment);
        }
        catch (ClassNotFoundException e) {
            throw UndertowServletMessages.MESSAGES.cannotLoadClass(className, e);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotCreateFactory(className, e);
        }
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getServlets().containsKey(servletName)) {
            return null;
        }
        ServletInfo s = new ServletInfo(servletName, servlet.getClass(), new ImmediateInstanceFactory<Servlet>(servlet));
        this.readServletAnnotations(s);
        this.deploymentInfo.addServlet(s);
        ServletHandler handler = this.deployment.getServlets().addServlet(s);
        return new ServletRegistrationImpl(s, handler.getManagedServlet(), this.deployment);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getServlets().containsKey(servletName)) {
            return null;
        }
        try {
            ServletInfo servlet = new ServletInfo(servletName, servletClass, this.deploymentInfo.getClassIntrospecter().createInstanceFactory(servletClass));
            this.readServletAnnotations(servlet);
            this.deploymentInfo.addServlet(servlet);
            ServletHandler handler = this.deployment.getServlets().addServlet(servlet);
            return new ServletRegistrationImpl(servlet, handler.getManagedServlet(), this.deployment);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotCreateFactory(servletClass.getName(), e);
        }
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        this.ensureNotProgramaticListener();
        try {
            return (T)((Servlet)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (Exception e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        this.ensureNotProgramaticListener();
        ManagedServlet servlet = this.deployment.getServlets().getManagedServlet(servletName);
        if (servlet == null) {
            return null;
        }
        return new ServletRegistrationImpl(servlet.getServletInfo(), servlet, this.deployment);
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        this.ensureNotProgramaticListener();
        HashMap<String, ServletRegistrationImpl> ret = new HashMap<String, ServletRegistrationImpl>();
        for (Map.Entry<String, ServletHandler> entry : this.deployment.getServlets().getServletHandlers().entrySet()) {
            ret.put(entry.getKey(), new ServletRegistrationImpl(entry.getValue().getManagedServlet().getServletInfo(), entry.getValue().getManagedServlet(), this.deployment));
        }
        return ret;
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getFilters().containsKey(filterName)) {
            return null;
        }
        try {
            Class<?> filterClass = this.deploymentInfo.getClassLoader().loadClass(className);
            FilterInfo filter = new FilterInfo(filterName, filterClass, this.deploymentInfo.getClassIntrospecter().createInstanceFactory(filterClass));
            this.deploymentInfo.addFilter(filter);
            this.deployment.getFilters().addFilter(filter);
            return new FilterRegistrationImpl(filter, this.deployment, this);
        }
        catch (ClassNotFoundException e) {
            throw UndertowServletMessages.MESSAGES.cannotLoadClass(className, e);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotCreateFactory(className, e);
        }
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getFilters().containsKey(filterName)) {
            return null;
        }
        FilterInfo f = new FilterInfo(filterName, filter.getClass(), new ImmediateInstanceFactory<Filter>(filter));
        this.deploymentInfo.addFilter(f);
        this.deployment.getFilters().addFilter(f);
        return new FilterRegistrationImpl(f, this.deployment, this);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getFilters().containsKey(filterName)) {
            return null;
        }
        try {
            FilterInfo filter = new FilterInfo(filterName, filterClass, this.deploymentInfo.getClassIntrospecter().createInstanceFactory(filterClass));
            this.deploymentInfo.addFilter(filter);
            this.deployment.getFilters().addFilter(filter);
            return new FilterRegistrationImpl(filter, this.deployment, this);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotCreateFactory(filterClass.getName(), e);
        }
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        this.ensureNotProgramaticListener();
        try {
            return (T)((Filter)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (Exception e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        this.ensureNotProgramaticListener();
        FilterInfo filterInfo = this.deploymentInfo.getFilters().get(filterName);
        if (filterInfo == null) {
            return null;
        }
        return new FilterRegistrationImpl(filterInfo, this.deployment, this);
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        this.ensureNotProgramaticListener();
        HashMap<String, FilterRegistrationImpl> ret = new HashMap<String, FilterRegistrationImpl>();
        for (Map.Entry<String, FilterInfo> entry : this.deploymentInfo.getFilters().entrySet()) {
            ret.put(entry.getKey(), new FilterRegistrationImpl(entry.getValue(), this.deployment, this));
        }
        return ret;
    }

    @Override
    public SessionCookieConfigImpl getSessionCookieConfig() {
        this.ensureNotProgramaticListener();
        return this.sessionCookieConfig;
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (sessionTrackingModes.size() > 1 && sessionTrackingModes.contains((Object)SessionTrackingMode.SSL)) {
            throw UndertowServletMessages.MESSAGES.sslCannotBeCombinedWithAnyOtherMethod();
        }
        this.sessionTrackingModes = new HashSet<SessionTrackingMode>(sessionTrackingModes);
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        this.ensureNotProgramaticListener();
        return this.defaultSessionTrackingModes;
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        this.ensureNotProgramaticListener();
        return Collections.unmodifiableSet(this.sessionTrackingModes);
    }

    @Override
    public void addListener(String className) {
        try {
            Class<?> clazz = this.deploymentInfo.getClassLoader().loadClass(className);
            this.addListener(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        this.ensureNotInitialized();
        this.ensureNotProgramaticListener();
        if (ApplicationListeners.listenerState() != ApplicationListeners.ListenerState.NO_LISTENER && ServletContextListener.class.isAssignableFrom(t.getClass())) {
            throw UndertowServletMessages.MESSAGES.cannotAddServletContextListener();
        }
        ListenerInfo listener = new ListenerInfo(t.getClass(), new ImmediateInstanceFactory<T>(t));
        this.deploymentInfo.addListener(listener);
        this.deployment.getApplicationListeners().addListener(new ManagedListener(listener, true));
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        this.ensureNotInitialized();
        this.ensureNotProgramaticListener();
        if (ApplicationListeners.listenerState() != ApplicationListeners.ListenerState.NO_LISTENER && ServletContextListener.class.isAssignableFrom(listenerClass)) {
            throw UndertowServletMessages.MESSAGES.cannotAddServletContextListener();
        }
        InstanceFactory<? extends EventListener> factory = null;
        try {
            factory = this.deploymentInfo.getClassIntrospecter().createInstanceFactory(listenerClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        ListenerInfo listener = new ListenerInfo(listenerClass, factory);
        this.deploymentInfo.addListener(listener);
        this.deployment.getApplicationListeners().addListener(new ManagedListener(listener, true));
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        this.ensureNotProgramaticListener();
        if (!ApplicationListeners.isListenerClass(clazz)) {
            throw UndertowServletMessages.MESSAGES.listenerMustImplementListenerClass(clazz);
        }
        try {
            return (T)((EventListener)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (Exception e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.deploymentInfo.getJspConfigDescriptor();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.deploymentInfo.getClassLoader();
    }

    @Override
    public void declareRoles(String ... roleNames) {
    }

    @Override
    public String getVirtualServerName() {
        return this.deployment.getDeploymentInfo().getHostName();
    }

    public HttpSessionImpl getSession(String sessionId) {
        SessionManager sessionManager = this.deployment.getSessionManager();
        Session session = sessionManager.getSession(sessionId);
        if (session != null) {
            return SecurityActions.forSession(session, this, false);
        }
        return null;
    }

    public HttpSessionImpl getSession(ServletContextImpl originalServletContext, HttpServerExchange exchange, boolean create) {
        SessionConfig c = originalServletContext.getSessionConfig();
        HttpSessionImpl httpSession = exchange.getAttachment(this.sessionAttachmentKey);
        if (httpSession != null && httpSession.isInvalid()) {
            exchange.removeAttachment(this.sessionAttachmentKey);
            httpSession = null;
        }
        if (httpSession == null) {
            SessionManager sessionManager = this.deployment.getSessionManager();
            Session session = sessionManager.getSession(exchange, c);
            if (session != null) {
                httpSession = SecurityActions.forSession(session, this, false);
                exchange.putAttachment(this.sessionAttachmentKey, httpSession);
            } else if (create) {
                String existing = c.findSessionId(exchange);
                if (originalServletContext != this) {
                    originalServletContext.getSession(originalServletContext, exchange, true);
                } else if (existing != null) {
                    c.clearSession(exchange, existing);
                }
                Session newSession = sessionManager.createSession(exchange, c);
                httpSession = SecurityActions.forSession(newSession, this, true);
                exchange.putAttachment(this.sessionAttachmentKey, httpSession);
            }
        }
        return httpSession;
    }

    public HttpSessionImpl getSession(HttpServerExchange exchange, boolean create) {
        return this.getSession(this, exchange, create);
    }

    public void updateSessionAccessTime(HttpServerExchange exchange) {
        HttpSessionImpl httpSession = this.getSession(exchange, false);
        if (httpSession != null) {
            Session underlyingSession = System.getSecurityManager() == null ? httpSession.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(httpSession));
            underlyingSession.requestDone(exchange);
        }
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    private void ensureNotInitialized() {
        if (this.initialized) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
    }

    private void ensureNotProgramaticListener() {
        if (ApplicationListeners.listenerState() == ApplicationListeners.ListenerState.PROGRAMATIC_LISTENER) {
            throw UndertowServletMessages.MESSAGES.cannotCallFromProgramaticListener();
        }
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void destroy() {
        this.attributes.clear();
        this.deploymentInfo = null;
    }

    private void readServletAnnotations(ServletInfo servlet) {
        if (System.getSecurityManager() == null) {
            new ReadServletAnnotationsTask(servlet, this.deploymentInfo).run();
        } else {
            AccessController.doPrivileged(new ReadServletAnnotationsTask(servlet, this.deploymentInfo));
        }
    }

    public void setDefaultSessionTrackingModes(HashSet<SessionTrackingMode> sessionTrackingModes) {
        this.defaultSessionTrackingModes = sessionTrackingModes;
        this.sessionTrackingModes = sessionTrackingModes;
    }

    void addMappingForServletNames(FilterInfo filterInfo, EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (String servlet : servletNames) {
            if (isMatchAfter) {
                if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                    deploymentInfo.addFilterServletNameMapping(filterInfo.getName(), servlet, DispatcherType.REQUEST);
                    continue;
                }
                for (DispatcherType dispatcher : dispatcherTypes) {
                    deploymentInfo.addFilterServletNameMapping(filterInfo.getName(), servlet, dispatcher);
                }
                continue;
            }
            if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                deploymentInfo.insertFilterServletNameMapping(this.filterMappingServletNameInsertPosition++, filterInfo.getName(), servlet, DispatcherType.REQUEST);
                continue;
            }
            for (DispatcherType dispatcher : dispatcherTypes) {
                deploymentInfo.insertFilterServletNameMapping(this.filterMappingServletNameInsertPosition++, filterInfo.getName(), servlet, dispatcher);
            }
        }
        this.deployment.getServletPaths().invalidate();
    }

    void addMappingForUrlPatterns(FilterInfo filterInfo, EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (String url : urlPatterns) {
            if (isMatchAfter) {
                if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                    deploymentInfo.addFilterUrlMapping(filterInfo.getName(), url, DispatcherType.REQUEST);
                    continue;
                }
                for (DispatcherType dispatcher : dispatcherTypes) {
                    deploymentInfo.addFilterUrlMapping(filterInfo.getName(), url, dispatcher);
                }
                continue;
            }
            if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                deploymentInfo.insertFilterUrlMapping(this.filterMappingUrlPatternInsertPosition++, filterInfo.getName(), url, DispatcherType.REQUEST);
                continue;
            }
            for (DispatcherType dispatcher : dispatcherTypes) {
                deploymentInfo.insertFilterUrlMapping(this.filterMappingUrlPatternInsertPosition++, filterInfo.getName(), url, dispatcher);
            }
        }
        this.deployment.getServletPaths().invalidate();
    }

    ContentTypeInfo parseContentType(String type) {
        ContentTypeInfo existing = this.contentTypeCache.get(type);
        if (existing != null) {
            return existing;
        }
        String contentType = type;
        String charset = null;
        int split = type.indexOf(";");
        if (split != -1) {
            char c;
            int i;
            int pos = type.indexOf("charset=");
            if (pos != -1) {
                i = pos + "charset=".length();
                while ((c = type.charAt(i)) != ' ' && c != '\t' && c != ';' && ++i < type.length()) {
                }
                charset = type.substring(pos + "charset=".length(), i);
                if (charset.startsWith("\"") && charset.endsWith("\"") && charset.length() > 1) {
                    charset = charset.substring(1, charset.length() - 1);
                }
                int charsetStart = pos;
                while (type.charAt(--charsetStart) != ';' && charsetStart > 0) {
                }
                StringBuilder contentTypeBuilder = new StringBuilder();
                contentTypeBuilder.append(type.substring(0, charsetStart));
                if (i != type.length()) {
                    contentTypeBuilder.append(type.substring(i));
                }
                contentType = contentTypeBuilder.toString();
            }
            for (i = contentType.length() - 1; i >= 0; --i) {
                c = contentType.charAt(i);
                if (c == ' ' || c == '\t') continue;
                if (c != ';') break;
                contentType = contentType.substring(0, i);
                break;
            }
        }
        existing = charset == null ? new ContentTypeInfo(contentType, null, contentType) : new ContentTypeInfo(contentType + ";charset=" + charset, charset, contentType);
        this.contentTypeCache.add(type, existing);
        return existing;
    }

    static final class IgnoreInvalidatedSessionConfig
    implements SessionConfig {
        private final AttachmentKey<String> INVALIDATED = AttachmentKey.create(String.class);
        private final SessionConfig delegate;

        private IgnoreInvalidatedSessionConfig(SessionConfig delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setSessionId(HttpServerExchange exchange, String sessionId) {
            this.delegate.setSessionId(exchange, sessionId);
        }

        @Override
        public void clearSession(HttpServerExchange exchange, String sessionId) {
            exchange.putAttachment(this.INVALIDATED, sessionId);
            this.delegate.clearSession(exchange, sessionId);
        }

        @Override
        public String findSessionId(HttpServerExchange exchange) {
            String invalidated = exchange.getAttachment(this.INVALIDATED);
            String current = this.delegate.findSessionId(exchange);
            if (invalidated == null) {
                return current;
            }
            if (invalidated.equals(current)) {
                return null;
            }
            return current;
        }

        @Override
        public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
            return this.delegate.sessionCookieSource(exchange);
        }

        @Override
        public String rewriteUrl(String originalUrl, String sessionId) {
            return this.delegate.rewriteUrl(originalUrl, sessionId);
        }

        public SessionConfig getDelegate() {
            return this.delegate;
        }
    }

    private static final class ReadServletAnnotationsTask
    implements PrivilegedAction<Void> {
        private final ServletInfo servletInfo;
        private final DeploymentInfo deploymentInfo;

        private ReadServletAnnotationsTask(ServletInfo servletInfo, DeploymentInfo deploymentInfo) {
            this.servletInfo = servletInfo;
            this.deploymentInfo = deploymentInfo;
        }

        @Override
        public Void run() {
            DeclareRoles declareRoles;
            RunAs runAs;
            MultipartConfig multipartConfig;
            ServletSecurity security = this.servletInfo.getServletClass().getAnnotation(ServletSecurity.class);
            if (security != null) {
                ServletSecurityInfo servletSecurityInfo = (ServletSecurityInfo)((ServletSecurityInfo)((ServletSecurityInfo)new ServletSecurityInfo().setEmptyRoleSemantic(security.value().value() == ServletSecurity.EmptyRoleSemantic.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(security.value().transportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE)).addRolesAllowed(security.value().rolesAllowed());
                for (HttpMethodConstraint constraint : security.httpMethodConstraints()) {
                    ((ServletSecurityInfo)((ServletSecurityInfo)servletSecurityInfo.addHttpMethodSecurityInfo(new HttpMethodSecurityInfo().setMethod(constraint.value())).setEmptyRoleSemantic(constraint.emptyRoleSemantic() == ServletSecurity.EmptyRoleSemantic.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(constraint.transportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE)).addRolesAllowed(constraint.rolesAllowed());
                }
                this.servletInfo.setServletSecurityInfo(servletSecurityInfo);
            }
            if ((multipartConfig = this.servletInfo.getServletClass().getAnnotation(MultipartConfig.class)) != null) {
                this.servletInfo.setMultipartConfig(new MultipartConfigElement(multipartConfig.location(), multipartConfig.maxFileSize(), multipartConfig.maxRequestSize(), multipartConfig.fileSizeThreshold()));
            }
            if ((runAs = this.servletInfo.getServletClass().getAnnotation(RunAs.class)) != null) {
                this.servletInfo.setRunAs(runAs.value());
            }
            if ((declareRoles = this.servletInfo.getServletClass().getAnnotation(DeclareRoles.class)) != null) {
                this.deploymentInfo.addSecurityRoles(declareRoles.value());
            }
            return null;
        }
    }
}

