/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import io.undertow.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ByteRange {
    private final List<Range> ranges;

    public ByteRange(List<Range> ranges) {
        this.ranges = ranges;
    }

    public int getRanges() {
        return this.ranges.size();
    }

    public long getStart(int range) {
        return this.ranges.get(range).getStart();
    }

    public long getEnd(int range) {
        return this.ranges.get(range).getEnd();
    }

    public static ByteRange parse(String rangeHeader) {
        String[] parts;
        if (rangeHeader == null || rangeHeader.length() < 7) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes=")) {
            return null;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String part : parts = rangeHeader.substring(6).split(",")) {
            try {
                int index = part.indexOf(45);
                if (index == 0) {
                    long val = Long.parseLong(part.substring(1));
                    if (val < 0L) {
                        UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", (Object)rangeHeader);
                        return null;
                    }
                    ranges.add(new Range(-1L, val));
                    continue;
                }
                if (index == -1) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", (Object)rangeHeader);
                    return null;
                }
                long start = Long.parseLong(part.substring(0, index));
                if (start < 0L) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", (Object)rangeHeader);
                    return null;
                }
                long end = index + 1 < part.length() ? Long.parseLong(part.substring(index + 1)) : -1L;
                ranges.add(new Range(start, end));
            }
            catch (NumberFormatException e) {
                UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", (Object)rangeHeader);
                return null;
            }
        }
        if (ranges.isEmpty()) {
            return null;
        }
        return new ByteRange(ranges);
    }

    public RangeResponseResult getResponseResult(long resourceContentLength, String ifRange, Date lastModified, String eTag) {
        long rangeLength;
        Date ifDate;
        if (this.ranges.isEmpty()) {
            return null;
        }
        long start = this.getStart(0);
        long end = this.getEnd(0);
        if (ifRange != null && !ifRange.isEmpty() && (ifRange.charAt(0) == '\"' ? eTag != null && !eTag.equals(ifRange) : (ifDate = DateUtils.parseDate(ifRange)) != null && lastModified != null && ifDate.getTime() < lastModified.getTime())) {
            return null;
        }
        if (start == -1L) {
            long toWrite = end;
            if (toWrite < 0L) {
                return new RangeResponseResult(0L, 0L, 0L, "bytes */" + resourceContentLength, 416);
            }
            rangeLength = toWrite;
            start = resourceContentLength - end;
            end = resourceContentLength - 1L;
        } else if (end == -1L) {
            long toWrite = resourceContentLength - start;
            if (toWrite < 0L) {
                return new RangeResponseResult(0L, 0L, 0L, "bytes */" + resourceContentLength, 416);
            }
            rangeLength = toWrite;
            end = resourceContentLength - 1L;
        } else {
            long toWrite;
            if (start >= resourceContentLength || start > end) {
                return new RangeResponseResult(0L, 0L, 0L, "bytes */" + resourceContentLength, 416);
            }
            rangeLength = toWrite = end - start + 1L;
        }
        return new RangeResponseResult(start, end, rangeLength, "bytes " + start + "-" + end + "/" + resourceContentLength, 206);
    }

    public static class Range {
        private final long start;
        private final long end;

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }

    public class RangeResponseResult {
        private final long start;
        private final long end;
        private final long contentLength;
        private final String contentRange;
        private final int statusCode;

        public RangeResponseResult(long start, long end, long contentLength, String contentRange, int statusCode) {
            this.start = start;
            this.end = end;
            this.contentLength = contentLength;
            this.contentRange = contentRange;
            this.statusCode = statusCode;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public String getContentRange() {
            return this.contentRange;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

