/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSourceConduit;

public final class EmptyStreamSourceConduit
implements StreamSourceConduit {
    private final XnioWorker worker;
    private final XnioIoThread readThread;
    private ReadReadyHandler readReadyHandler;
    private boolean shutdown;
    private boolean resumed;

    public EmptyStreamSourceConduit(XnioIoThread readThread) {
        this.worker = readThread.getWorker();
        this.readThread = readThread;
    }

    @Override
    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = handler;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return 0L;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        this.resumed = false;
        return -1L;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.resumed = false;
        return -1;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        this.resumed = false;
        return -1L;
    }

    @Override
    public boolean isReadShutdown() {
        return this.shutdown;
    }

    @Override
    public void resumeReads() {
        this.resumed = true;
        this.readThread.execute(new Runnable(){

            @Override
            public void run() {
                ReadReadyHandler handler = EmptyStreamSourceConduit.this.readReadyHandler;
                if (handler != null) {
                    handler.readReady();
                }
            }
        });
    }

    @Override
    public void suspendReads() {
        this.resumed = false;
    }

    @Override
    public void wakeupReads() {
        this.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.resumed;
    }

    @Override
    public void awaitReadable() throws IOException {
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
    }

    @Override
    public void terminateReads() throws IOException {
        if (!this.shutdown) {
            this.shutdown = true;
            if (this.readReadyHandler != null) {
                this.readReadyHandler.terminated();
            }
        }
    }

    @Override
    public XnioIoThread getReadThread() {
        return this.readThread;
    }

    @Override
    public XnioWorker getWorker() {
        return this.worker;
    }
}

