/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.alpn;

import io.undertow.protocols.alpn.ALPNProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.alpn.ALPN;

public class JettyAlpnProvider
implements ALPNProvider {
    private static final String PROTOCOL_KEY = JettyAlpnProvider.class.getName() + ".protocol";
    private static final boolean ENABLED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                Class.forName("org.eclipse.jetty.alpn.ALPN", true, JettyAlpnProvider.class.getClassLoader());
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    });

    @Override
    public boolean isEnabled(SSLEngine sslEngine) {
        return ENABLED;
    }

    @Override
    public SSLEngine setProtocols(SSLEngine engine, String[] protocols) {
        return Impl.setProtocols(engine, protocols);
    }

    @Override
    public String getSelectedProtocol(SSLEngine engine) {
        SSLSession handshake = engine.getHandshakeSession();
        if (handshake != null) {
            return (String)handshake.getValue(PROTOCOL_KEY);
        }
        handshake = engine.getSession();
        if (handshake != null) {
            return (String)handshake.getValue(PROTOCOL_KEY);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    public String toString() {
        return "JettyAlpnProvider{}";
    }

    private static class ALPNClientSelectionProvider
    implements ALPN.ClientProvider {
        final List<String> protocols;
        private String selected;
        private final SSLEngine sslEngine;

        private ALPNClientSelectionProvider(List<String> protocols, SSLEngine sslEngine) {
            this.protocols = protocols;
            this.sslEngine = sslEngine;
        }

        public boolean supports() {
            return true;
        }

        public List<String> protocols() {
            return this.protocols;
        }

        public void unsupported() {
            ALPN.remove((SSLEngine)this.sslEngine);
            this.selected = "";
        }

        public void selected(String s) {
            ALPN.remove((SSLEngine)this.sslEngine);
            this.selected = s;
            this.sslEngine.getHandshakeSession().putValue(PROTOCOL_KEY, this.selected);
        }
    }

    private static class Impl {
        private Impl() {
        }

        static SSLEngine setProtocols(final SSLEngine engine, final String[] protocols) {
            if (engine.getUseClientMode()) {
                ALPN.put((SSLEngine)engine, (ALPN.Provider)new ALPNClientSelectionProvider(Arrays.asList(protocols), engine));
            } else {
                ALPN.put((SSLEngine)engine, (ALPN.Provider)new ALPN.ServerProvider(){

                    public void unsupported() {
                        ALPN.remove((SSLEngine)engine);
                    }

                    public String select(List<String> strings) {
                        ALPN.remove((SSLEngine)engine);
                        for (String p : protocols) {
                            if (!strings.contains(p)) continue;
                            engine.getHandshakeSession().putValue(PROTOCOL_KEY, p);
                            return p;
                        }
                        return null;
                    }
                });
            }
            return engine;
        }
    }
}

