/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.http2.AbstractHttp2StreamSinkChannel;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.ConnectionErrorException;
import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.HpackEncoder;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2FramePriority;
import io.undertow.protocols.http2.Http2GoAwayParser;
import io.undertow.protocols.http2.Http2GoAwayStreamSinkChannel;
import io.undertow.protocols.http2.Http2GoAwayStreamSourceChannel;
import io.undertow.protocols.http2.Http2HeadersParser;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2PingParser;
import io.undertow.protocols.http2.Http2PingStreamSinkChannel;
import io.undertow.protocols.http2.Http2PingStreamSourceChannel;
import io.undertow.protocols.http2.Http2PrefaceStreamSinkChannel;
import io.undertow.protocols.http2.Http2PriorityParser;
import io.undertow.protocols.http2.Http2PushPromiseParser;
import io.undertow.protocols.http2.Http2PushPromiseStreamSinkChannel;
import io.undertow.protocols.http2.Http2PushPromiseStreamSourceChannel;
import io.undertow.protocols.http2.Http2RstStreamParser;
import io.undertow.protocols.http2.Http2RstStreamSinkChannel;
import io.undertow.protocols.http2.Http2RstStreamStreamSourceChannel;
import io.undertow.protocols.http2.Http2Setting;
import io.undertow.protocols.http2.Http2SettingsParser;
import io.undertow.protocols.http2.Http2SettingsStreamSinkChannel;
import io.undertow.protocols.http2.Http2SettingsStreamSourceChannel;
import io.undertow.protocols.http2.Http2StreamSinkChannel;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.protocols.http2.Http2WindowUpdateParser;
import io.undertow.protocols.http2.Http2WindowUpdateStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSession;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.ssl.SslConnection;

public class Http2Channel
extends AbstractFramedChannel<Http2Channel, AbstractHttp2StreamSourceChannel, AbstractHttp2StreamSinkChannel>
implements Attachable {
    public static final String CLEARTEXT_UPGRADE_STRING = "h2c";
    static final int FRAME_TYPE_DATA = 0;
    static final int FRAME_TYPE_HEADERS = 1;
    static final int FRAME_TYPE_PRIORITY = 2;
    static final int FRAME_TYPE_RST_STREAM = 3;
    static final int FRAME_TYPE_SETTINGS = 4;
    static final int FRAME_TYPE_PUSH_PROMISE = 5;
    static final int FRAME_TYPE_PING = 6;
    static final int FRAME_TYPE_GOAWAY = 7;
    static final int FRAME_TYPE_WINDOW_UPDATE = 8;
    static final int FRAME_TYPE_CONTINUATION = 9;
    public static final int ERROR_NO_ERROR = 0;
    public static final int ERROR_PROTOCOL_ERROR = 1;
    public static final int ERROR_INTERNAL_ERROR = 2;
    public static final int ERROR_FLOW_CONTROL_ERROR = 3;
    public static final int ERROR_SETTINGS_TIMEOUT = 4;
    public static final int ERROR_STREAM_CLOSED = 5;
    public static final int ERROR_FRAME_SIZE_ERROR = 6;
    public static final int ERROR_REFUSED_STREAM = 7;
    public static final int ERROR_CANCEL = 8;
    public static final int ERROR_COMPRESSION_ERROR = 9;
    public static final int ERROR_CONNECT_ERROR = 10;
    public static final int ERROR_ENHANCE_YOUR_CALM = 11;
    public static final int ERROR_INADEQUATE_SECURITY = 12;
    static final int DATA_FLAG_END_STREAM = 1;
    static final int DATA_FLAG_END_SEGMENT = 2;
    static final int DATA_FLAG_PADDED = 8;
    static final int PING_FRAME_LENGTH = 8;
    static final int PING_FLAG_ACK = 1;
    static final int HEADERS_FLAG_END_STREAM = 1;
    static final int HEADERS_FLAG_END_SEGMENT = 2;
    static final int HEADERS_FLAG_END_HEADERS = 4;
    static final int HEADERS_FLAG_PADDED = 8;
    static final int HEADERS_FLAG_PRIORITY = 32;
    static final int SETTINGS_FLAG_ACK = 1;
    static final int CONTINUATION_FLAG_END_HEADERS = 4;
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    public static final byte[] PREFACE_BYTES = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    public static final int MAX_FRAME_SIZE = 0xFFFFFF;
    private Http2FrameHeaderParser frameParser;
    private final Map<Integer, Http2StreamSourceChannel> incomingStreams = new ConcurrentHashMap<Integer, Http2StreamSourceChannel>();
    private final Map<Integer, Http2StreamSinkChannel> outgoingStreams = new ConcurrentHashMap<Integer, Http2StreamSinkChannel>();
    private final String protocol;
    private int encoderHeaderTableSize;
    private boolean pushEnabled;
    private volatile int initialSendWindowSize = 65535;
    private volatile int initialReceiveWindowSize = 65535;
    private int maxConcurrentStreams = -1;
    private int sendMaxFrameSize = 16384;
    private int receiveMaxFrameSize = 16384;
    private int unackedReceiveMaxFrameSize = 16384;
    private int maxHeaderListSize = -1;
    private volatile int receiveWindowSize = this.initialReceiveWindowSize;
    private volatile int sendWindowSize = this.initialSendWindowSize;
    private boolean thisGoneAway = false;
    private boolean peerGoneAway = false;
    private boolean lastDataRead = false;
    private int streamIdCounter;
    private int lastGoodStreamId;
    private final HpackDecoder decoder;
    private final HpackEncoder encoder;
    private int prefaceCount;
    private boolean initialSettingsReceived;
    private Http2HeadersParser continuationParser = null;
    private boolean initialSettingsSent = false;
    private final Map<AttachmentKey<?>, Object> attachments = Collections.synchronizedMap(new HashMap());

    public Http2Channel(StreamConnection connectedStreamChannel, String protocol, ByteBufferPool bufferPool, PooledByteBuffer data, boolean clientSide, boolean fromUpgrade, OptionMap settings) {
        this(connectedStreamChannel, protocol, bufferPool, data, clientSide, fromUpgrade, true, null, settings);
    }

    public Http2Channel(StreamConnection connectedStreamChannel, String protocol, ByteBufferPool bufferPool, PooledByteBuffer data, boolean clientSide, boolean fromUpgrade, boolean prefaceRequired, OptionMap settings) {
        this(connectedStreamChannel, protocol, bufferPool, data, clientSide, fromUpgrade, prefaceRequired, null, settings);
    }

    public Http2Channel(StreamConnection connectedStreamChannel, String protocol, ByteBufferPool bufferPool, PooledByteBuffer data, boolean clientSide, boolean fromUpgrade, boolean prefaceRequired, ByteBuffer initialOtherSideSettings, OptionMap settings) {
        super(connectedStreamChannel, bufferPool, Http2FramePriority.INSTANCE, data, settings);
        this.streamIdCounter = clientSide ? (fromUpgrade ? 3 : 1) : 2;
        this.pushEnabled = settings.get(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH, true);
        this.initialReceiveWindowSize = settings.get(UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE, 65535);
        this.protocol = protocol == null ? "h2" : protocol;
        this.encoderHeaderTableSize = settings.get(UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE, 4096);
        this.receiveMaxFrameSize = settings.get(UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE, 16384);
        this.decoder = new HpackDecoder(4096);
        this.encoder = new HpackEncoder(this.encoderHeaderTableSize);
        if (!prefaceRequired) {
            this.prefaceCount = PREFACE_BYTES.length;
        }
        if (clientSide) {
            this.sendPreface();
            this.prefaceCount = PREFACE_BYTES.length;
            this.sendSettings();
            this.initialSettingsSent = true;
        } else if (fromUpgrade) {
            this.sendSettings();
            this.initialSettingsSent = true;
        }
        if (initialOtherSideSettings != null) {
            Http2SettingsParser parser = new Http2SettingsParser(initialOtherSideSettings.remaining());
            try {
                Http2FrameHeaderParser headerParser = new Http2FrameHeaderParser(this, null);
                headerParser.length = initialOtherSideSettings.remaining();
                parser.parse(initialOtherSideSettings, headerParser);
                this.updateSettings(parser.getSettings());
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)connectedStreamChannel);
                throw new RuntimeException(e);
            }
        }
    }

    private void sendSettings() {
        ArrayList<Http2Setting> settings = new ArrayList<Http2Setting>();
        settings.add(new Http2Setting(1, this.encoderHeaderTableSize));
        if (this.isClient()) {
            settings.add(new Http2Setting(2, this.pushEnabled ? 1 : 0));
        }
        settings.add(new Http2Setting(5, this.receiveMaxFrameSize));
        settings.add(new Http2Setting(4, this.initialReceiveWindowSize));
        Http2SettingsStreamSinkChannel stream = new Http2SettingsStreamSinkChannel(this, settings);
        this.flushChannelIgnoreFailure(stream);
    }

    private void sendSettingsAck() {
        if (!this.initialSettingsSent) {
            this.sendSettings();
            this.initialSettingsSent = true;
        }
        Http2SettingsStreamSinkChannel stream = new Http2SettingsStreamSinkChannel(this);
        this.flushChannelIgnoreFailure(stream);
    }

    private void flushChannelIgnoreFailure(StreamSinkChannel stream) {
        try {
            this.flushChannel(stream);
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        }
    }

    private void flushChannel(StreamSinkChannel stream) throws IOException {
        stream.shutdownWrites();
        if (!stream.flush()) {
            stream.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, this.writeExceptionHandler()));
            stream.resumeWrites();
        }
    }

    private void sendPreface() {
        Http2PrefaceStreamSinkChannel preface = new Http2PrefaceStreamSinkChannel(this);
        this.flushChannelIgnoreFailure(preface);
    }

    @Override
    protected AbstractHttp2StreamSourceChannel createChannel(FrameHeaderData frameHeaderData, PooledByteBuffer frameData) throws IOException {
        AbstractHttp2StreamSourceChannel channel;
        Http2FrameHeaderParser frameParser = (Http2FrameHeaderParser)frameHeaderData;
        if (frameParser.type == 0) {
            if (frameParser.streamId == 0) {
                this.sendGoAway(1);
            } else {
                this.sendRstStream(frameParser.streamId, 5);
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Dropping Frame of length %s for stream %s", frameParser.getFrameLength(), (long)frameParser.streamId);
            return null;
        }
        switch (frameParser.type) {
            case 5: 
            case 9: {
                if (frameParser.parser instanceof Http2PushPromiseParser) {
                    if (!this.isClient()) {
                        this.sendGoAway(1);
                        throw UndertowMessages.MESSAGES.serverReceivedPushPromise();
                    }
                    Http2PushPromiseParser pushPromiseParser = (Http2PushPromiseParser)frameParser.parser;
                    channel = new Http2PushPromiseStreamSourceChannel(this, frameData, frameParser.getFrameLength(), pushPromiseParser.getHeaderMap(), pushPromiseParser.getPromisedStreamId(), frameParser.streamId);
                    break;
                }
            }
            case 1: {
                Http2HeadersParser parser = (Http2HeadersParser)frameParser.parser;
                channel = new Http2StreamSourceChannel(this, frameData, frameHeaderData.getFrameLength(), parser.getHeaderMap(), frameParser.streamId);
                this.lastGoodStreamId = Math.max(this.lastGoodStreamId, frameParser.streamId);
                if (parser.isHeadersEndStream() && Bits.allAreSet(frameParser.flags, 4)) {
                    channel.lastFrame();
                } else {
                    this.incomingStreams.put(frameParser.streamId, (Http2StreamSourceChannel)channel);
                }
                if (parser.isInvalid()) {
                    channel.rstStream(1);
                    this.sendRstStream(frameParser.streamId, 8);
                    channel = null;
                }
                if (parser.getDependentStreamId() != frameParser.streamId) break;
                this.sendRstStream(frameParser.streamId, 1);
                return null;
            }
            case 3: {
                Http2RstStreamParser parser = (Http2RstStreamParser)frameParser.parser;
                if (frameParser.streamId == 0) {
                    if (frameData != null) {
                        frameData.close();
                    }
                    throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustNotBeZeroForFrameType(3));
                }
                channel = new Http2RstStreamStreamSourceChannel(this, frameData, parser.getErrorCode(), frameParser.streamId);
                this.handleRstStream(frameParser.streamId);
                break;
            }
            case 4: {
                if (!Bits.anyAreSet(frameParser.flags, 1)) {
                    this.updateSettings(((Http2SettingsParser)frameParser.parser).getSettings());
                    this.sendSettingsAck();
                }
                channel = new Http2SettingsStreamSourceChannel(this, frameData, frameParser.getFrameLength(), ((Http2SettingsParser)frameParser.parser).getSettings());
                this.unackedReceiveMaxFrameSize = this.receiveMaxFrameSize;
                break;
            }
            case 6: {
                Http2PingParser pingParser = (Http2PingParser)frameParser.parser;
                frameData.close();
                boolean ack = Bits.anyAreSet(frameParser.flags, 1);
                channel = new Http2PingStreamSourceChannel(this, pingParser.getData(), ack);
                if (ack) break;
                this.sendPing(pingParser.getData(), null, true);
                break;
            }
            case 7: {
                Http2GoAwayParser http2GoAwayParser = (Http2GoAwayParser)frameParser.parser;
                channel = new Http2GoAwayStreamSourceChannel(this, frameData, frameParser.getFrameLength(), http2GoAwayParser.getStatusCode(), http2GoAwayParser.getLastGoodStreamId());
                this.peerGoneAway = true;
                for (Http2StreamSourceChannel http2StreamSourceChannel : this.incomingStreams.values()) {
                    http2StreamSourceChannel.rstStream();
                }
                for (Http2StreamSinkChannel http2StreamSinkChannel : this.outgoingStreams.values()) {
                    http2StreamSinkChannel.rstStream();
                }
                break;
            }
            case 8: {
                Http2WindowUpdateParser parser = (Http2WindowUpdateParser)frameParser.parser;
                this.handleWindowUpdate(frameParser.streamId, parser.getDeltaWindowSize());
                frameData.close();
                return null;
            }
            case 2: {
                Http2PriorityParser parser = (Http2PriorityParser)frameParser.parser;
                if (parser.getStreamDependency() == frameParser.streamId) {
                    this.sendRstStream(frameParser.streamId, 1);
                    return null;
                }
                frameData.close();
                return null;
            }
            default: {
                UndertowLogger.REQUEST_LOGGER.tracef("Dropping frame of length %s and type %s for stream %s as we do not understand this type of frame", frameParser.getFrameLength(), (long)frameParser.type, (long)frameParser.streamId);
                return null;
            }
        }
        return channel;
    }

    @Override
    protected FrameHeaderData parseFrame(ByteBuffer data) throws IOException {
        Http2FrameHeaderParser frameParser;
        if (this.prefaceCount < PREFACE_BYTES.length) {
            while (data.hasRemaining() && this.prefaceCount < PREFACE_BYTES.length) {
                if (data.get() != PREFACE_BYTES[this.prefaceCount]) {
                    IoUtils.safeClose((Closeable)this.getUnderlyingConnection());
                    throw UndertowMessages.MESSAGES.incorrectHttp2Preface();
                }
                ++this.prefaceCount;
            }
        }
        if ((frameParser = this.frameParser) == null) {
            this.frameParser = frameParser = new Http2FrameHeaderParser(this, this.continuationParser);
            this.continuationParser = null;
        }
        if (!frameParser.handle(data)) {
            return null;
        }
        if (!this.initialSettingsReceived) {
            if (frameParser.type != 4) {
                UndertowLogger.REQUEST_IO_LOGGER.remoteEndpointFailedToSendInitialSettings(frameParser.type);
                this.markReadsBroken(new IOException());
            } else {
                this.initialSettingsReceived = true;
            }
        }
        this.frameParser = null;
        if (frameParser.getFrameLength() > (long)this.receiveMaxFrameSize && frameParser.getFrameLength() > (long)this.unackedReceiveMaxFrameSize) {
            this.sendGoAway(6);
            throw UndertowMessages.MESSAGES.http2FrameTooLarge();
        }
        if (frameParser.getContinuationParser() != null) {
            this.continuationParser = frameParser.getContinuationParser();
            return null;
        }
        return frameParser;
    }

    @Override
    protected void lastDataRead() {
        this.lastDataRead = true;
        if (!this.peerGoneAway && !this.thisGoneAway) {
            if (this.incomingStreams.size() > 0) {
                this.sendGoAway(10);
            } else {
                IoUtils.safeClose((Closeable)this);
            }
            this.peerGoneAway = true;
        }
    }

    @Override
    protected boolean isLastFrameReceived() {
        return this.lastDataRead;
    }

    @Override
    protected boolean isLastFrameSent() {
        return this.thisGoneAway;
    }

    @Override
    protected void handleBrokenSourceChannel(Throwable e) {
        UndertowLogger.REQUEST_LOGGER.debugf(e, "Closing HTTP2 channel to %s due to broken read side", (Object)this.getPeerAddress());
        if (e instanceof ConnectionErrorException) {
            this.sendGoAway(((ConnectionErrorException)e).getCode(), new Http2ControlMessageExceptionHandler());
        } else {
            this.sendGoAway(e instanceof ClosedChannelException ? 10 : 1, new Http2ControlMessageExceptionHandler());
        }
    }

    @Override
    protected void handleBrokenSinkChannel(Throwable e) {
        UndertowLogger.REQUEST_LOGGER.debugf(e, "Closing HTTP2 channel to %s due to broken write side", (Object)this.getPeerAddress());
        IoUtils.safeClose((Closeable)this);
    }

    @Override
    protected void closeSubChannels() {
        CloseableChannel receiver;
        for (Map.Entry<Integer, Http2StreamSourceChannel> entry : this.incomingStreams.entrySet()) {
            receiver = entry.getValue();
            if (((AbstractFramedStreamSourceChannel)receiver).isReadResumed()) {
                ChannelListeners.invokeChannelListener(((AbstractFramedStreamSourceChannel)receiver).getIoThread(), receiver, ((ChannelListener.SimpleSetter)((AbstractFramedStreamSourceChannel)receiver).getReadSetter()).get());
            }
            IoUtils.safeClose((Closeable)receiver);
        }
        this.incomingStreams.clear();
        for (Map.Entry<Integer, CloseableChannel> entry : this.outgoingStreams.entrySet()) {
            receiver = (Http2StreamSinkChannel)entry.getValue();
            if (((AbstractFramedStreamSinkChannel)receiver).isWritesShutdown()) {
                ChannelListeners.invokeChannelListener(((AbstractFramedStreamSinkChannel)receiver).getIoThread(), receiver, ((ChannelListener.SimpleSetter)((AbstractFramedStreamSinkChannel)receiver).getWriteSetter()).get());
            }
            IoUtils.safeClose((Closeable)receiver);
        }
        this.outgoingStreams.clear();
    }

    synchronized void updateSettings(List<Http2Setting> settings) {
        for (Http2Setting setting : settings) {
            if (setting.getId() == 4) {
                int old = this.initialSendWindowSize;
                this.initialSendWindowSize = setting.getValue();
                int difference = this.initialSendWindowSize - old;
                this.sendWindowSize += difference;
                continue;
            }
            if (setting.getId() == 5) {
                if (this.sendMaxFrameSize > 0xFFFFFF) {
                    UndertowLogger.REQUEST_IO_LOGGER.debug("Invalid value received for SETTINGS_MAX_FRAME_SIZE " + setting.getValue());
                    this.sendGoAway(1);
                    return;
                }
                this.sendMaxFrameSize = setting.getValue();
                continue;
            }
            if (setting.getId() == 1) {
                this.encoder.setMaxTableSize(setting.getValue());
                continue;
            }
            if (setting.getId() != 2) continue;
            int result = setting.getValue();
            if (result == 0) {
                this.pushEnabled = false;
                continue;
            }
            if (result == 1) continue;
            UndertowLogger.REQUEST_IO_LOGGER.debug("Invalid value received for SETTINGS_ENABLE_PUSH " + result);
            this.sendGoAway(1);
            return;
        }
    }

    public int getHttp2Version() {
        return 3;
    }

    public int getInitialSendWindowSize() {
        return this.initialSendWindowSize;
    }

    public int getInitialReceiveWindowSize() {
        return this.initialReceiveWindowSize;
    }

    public synchronized void handleWindowUpdate(int streamId, int deltaWindowSize) throws IOException {
        if (streamId == 0) {
            if (deltaWindowSize == 0) {
                UndertowLogger.REQUEST_IO_LOGGER.debug("Invalid flow-control window increment of 0 received with WINDOW_UPDATE frame for connection");
                this.sendGoAway(1);
                return;
            }
            boolean exhausted = this.sendWindowSize == 0;
            this.sendWindowSize += deltaWindowSize;
            if (exhausted) {
                this.notifyFlowControlAllowed();
            }
        } else {
            if (deltaWindowSize == 0) {
                UndertowLogger.REQUEST_IO_LOGGER.debug("Invalid flow-control window increment of 0 received with WINDOW_UPDATE frame for stream " + streamId);
                this.sendRstStream(streamId, 1);
                return;
            }
            Http2StreamSinkChannel stream = this.outgoingStreams.get(streamId);
            if (stream != null) {
                stream.updateFlowControlWindow(deltaWindowSize);
            }
        }
    }

    synchronized void notifyFlowControlAllowed() throws IOException {
        super.recalculateHeldFrames();
    }

    public void sendPing(byte[] data) {
        this.sendPing(data, new Http2ControlMessageExceptionHandler());
    }

    public void sendPing(byte[] data, ChannelExceptionHandler<AbstractHttp2StreamSinkChannel> exceptionHandler) {
        this.sendPing(data, exceptionHandler, false);
    }

    void sendPing(byte[] data, ChannelExceptionHandler<AbstractHttp2StreamSinkChannel> exceptionHandler, boolean ack) {
        Http2PingStreamSinkChannel ping = new Http2PingStreamSinkChannel(this, data, ack);
        try {
            ping.shutdownWrites();
            if (!ping.flush()) {
                ping.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, exceptionHandler));
                ping.resumeWrites();
            }
        }
        catch (IOException e) {
            exceptionHandler.handleException(ping, e);
        }
    }

    public void sendGoAway(int status) {
        this.sendGoAway(status, new Http2ControlMessageExceptionHandler());
    }

    public void sendGoAway(int status, ChannelExceptionHandler<AbstractHttp2StreamSinkChannel> exceptionHandler) {
        if (this.thisGoneAway) {
            return;
        }
        this.thisGoneAway = true;
        Http2GoAwayStreamSinkChannel goAway = new Http2GoAwayStreamSinkChannel(this, status, this.lastGoodStreamId);
        try {
            goAway.shutdownWrites();
            if (!goAway.flush()) {
                goAway.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<Channel>(){

                    @Override
                    public void handleEvent(Channel channel) {
                        IoUtils.safeClose((Closeable)Http2Channel.this);
                    }
                }, exceptionHandler));
                goAway.resumeWrites();
            } else {
                IoUtils.safeClose((Closeable)this);
            }
        }
        catch (IOException e) {
            exceptionHandler.handleException(goAway, e);
        }
    }

    public void sendUpdateWindowSize(int streamId, int delta) throws IOException {
        Http2WindowUpdateStreamSinkChannel windowUpdateStreamSinkChannel = new Http2WindowUpdateStreamSinkChannel(this, streamId, delta);
        this.flushChannel(windowUpdateStreamSinkChannel);
    }

    public SSLSession getSslSession() {
        StreamConnection con = this.getUnderlyingConnection();
        if (con instanceof SslConnection) {
            return ((SslConnection)con).getSslSession();
        }
        return null;
    }

    public synchronized void updateReceiveFlowControlWindow(int read) throws IOException {
        if (read <= 0) {
            return;
        }
        this.receiveWindowSize -= read;
        int initialWindowSize = this.initialReceiveWindowSize;
        if (this.receiveWindowSize < initialWindowSize / 2) {
            int delta = initialWindowSize - this.receiveWindowSize;
            this.receiveWindowSize += delta;
            this.sendUpdateWindowSize(0, delta);
        }
    }

    public synchronized Http2HeadersStreamSinkChannel createStream(HeaderMap requestHeaders) throws IOException {
        if (!this.isClient()) {
            throw UndertowMessages.MESSAGES.headersStreamCanOnlyBeCreatedByClient();
        }
        if (!this.isOpen()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        int streamId = this.streamIdCounter;
        this.streamIdCounter += 2;
        Http2HeadersStreamSinkChannel http2SynStreamStreamSinkChannel = new Http2HeadersStreamSinkChannel(this, streamId, requestHeaders);
        this.outgoingStreams.put(streamId, http2SynStreamStreamSinkChannel);
        return http2SynStreamStreamSinkChannel;
    }

    public synchronized Http2HeadersStreamSinkChannel sendPushPromise(int associatedStreamId, HeaderMap requestHeaders, HeaderMap responseHeaders) throws IOException {
        if (!this.isOpen()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        if (this.isClient()) {
            throw UndertowMessages.MESSAGES.pushPromiseCanOnlyBeCreatedByServer();
        }
        int streamId = this.streamIdCounter;
        this.streamIdCounter += 2;
        Http2PushPromiseStreamSinkChannel pushPromise = new Http2PushPromiseStreamSinkChannel(this, requestHeaders, associatedStreamId, streamId);
        this.flushChannel(pushPromise);
        Http2HeadersStreamSinkChannel http2SynStreamStreamSinkChannel = new Http2HeadersStreamSinkChannel(this, streamId, responseHeaders);
        this.outgoingStreams.put(streamId, http2SynStreamStreamSinkChannel);
        return http2SynStreamStreamSinkChannel;
    }

    synchronized int grabFlowControlBytes(int bytesToGrab) {
        int min = Math.min(bytesToGrab, this.sendWindowSize);
        min = Math.min(this.sendMaxFrameSize, min);
        this.sendWindowSize -= min;
        return min;
    }

    void registerStreamSink(Http2HeadersStreamSinkChannel synResponse) {
        this.outgoingStreams.put(synResponse.getStreamId(), synResponse);
    }

    void removeStreamSink(int streamId) {
        this.outgoingStreams.remove(streamId);
        if (this.isLastFrameReceived() && this.outgoingStreams.isEmpty()) {
            this.sendGoAway(0);
        }
    }

    Map<Integer, Http2StreamSourceChannel> getIncomingStreams() {
        return this.incomingStreams;
    }

    public boolean isClient() {
        return this.streamIdCounter % 2 == 1;
    }

    HpackEncoder getEncoder() {
        return this.encoder;
    }

    HpackDecoder getDecoder() {
        return this.decoder;
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        return (T)this.attachments.get(key);
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        Object o = this.attachments.get(key);
        if (o == null) {
            return Collections.emptyList();
        }
        return (List)o;
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        return key.cast(this.attachments.put(key, key.cast(value)));
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        return key.cast(this.attachments.remove(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        Map<AttachmentKey<?>, Object> attachments;
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            List list = key.cast(attachments.get(key));
            if (list == null) {
                AttachmentList<Object> newList = new AttachmentList<Object>(Object.class);
                attachments.put(key, newList);
                newList.add(value);
            } else {
                list.add(value);
            }
        }
    }

    public void sendRstStream(int streamId, int statusCode) {
        this.handleRstStream(streamId);
        Http2RstStreamSinkChannel channel = new Http2RstStreamSinkChannel(this, streamId, statusCode);
        this.flushChannelIgnoreFailure(channel);
    }

    private void handleRstStream(int streamId) {
        Http2StreamSinkChannel outgoing;
        AbstractHttp2StreamSourceChannel incoming = this.incomingStreams.remove(streamId);
        if (incoming != null) {
            incoming.rstStream();
        }
        if ((outgoing = this.outgoingStreams.remove(streamId)) != null) {
            outgoing.rstStream();
        }
    }

    public Http2HeadersStreamSinkChannel createInitialUpgradeResponseStream() {
        if (this.lastGoodStreamId != 0) {
            throw new IllegalStateException();
        }
        this.lastGoodStreamId = 1;
        Http2HeadersStreamSinkChannel stream = new Http2HeadersStreamSinkChannel(this, 1);
        this.outgoingStreams.put(1, stream);
        return stream;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public boolean isPeerGoneAway() {
        return this.peerGoneAway;
    }

    public boolean isThisGoneAway() {
        return this.thisGoneAway;
    }

    public int getReceiveMaxFrameSize() {
        return this.receiveMaxFrameSize;
    }

    public int getSendMaxFrameSize() {
        return this.sendMaxFrameSize;
    }

    public String getProtocol() {
        return this.protocol;
    }

    private class Http2ControlMessageExceptionHandler
    implements ChannelExceptionHandler<AbstractHttp2StreamSinkChannel> {
        private Http2ControlMessageExceptionHandler() {
        }

        @Override
        public void handleException(AbstractHttp2StreamSinkChannel channel, IOException exception) {
            IoUtils.safeClose((Closeable)channel);
            Http2Channel.this.handleBrokenSinkChannel(exception);
        }
    }
}

