/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.Headers;
import io.undertow.util.NetworkUtils;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ProxyPeerAddressHandler
implements HttpHandler {
    private final HttpHandler next;

    public ProxyPeerAddressHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String forwardedProto;
        String forwardedFor = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR);
        if (forwardedFor != null) {
            int index = forwardedFor.indexOf(44);
            String value = index == -1 ? forwardedFor : forwardedFor.substring(0, index);
            exchange.setSourceAddress(InetSocketAddress.createUnresolved(value, 0));
        }
        if ((forwardedProto = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PROTO)) != null) {
            exchange.setRequestScheme(forwardedProto);
        }
        String forwardedHost = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_HOST);
        String forwardedPort = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PORT);
        if (forwardedHost != null) {
            int index = forwardedHost.indexOf(44);
            String value = index == -1 ? forwardedHost : forwardedHost.substring(0, index);
            if (value.startsWith("[")) {
                int end = value.lastIndexOf("]");
                if (end == -1) {
                    end = 0;
                }
                if ((index = value.indexOf(":", end)) != -1) {
                    forwardedPort = value.substring(index + 1);
                    value = value.substring(0, index);
                }
            } else {
                index = value.lastIndexOf(":");
                if (index != -1) {
                    forwardedPort = value.substring(index + 1);
                    value = value.substring(0, index);
                }
            }
            int port = 0;
            String hostHeader = NetworkUtils.formatPossibleIpv6Address(value);
            if (forwardedPort != null) {
                try {
                    port = Integer.parseInt(forwardedPort);
                    hostHeader = hostHeader + ":" + port;
                }
                catch (NumberFormatException ignore) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Cannot parse port: %s", (Object)forwardedPort);
                }
            }
            exchange.getRequestHeaders().put(Headers.HOST, hostHeader);
            exchange.setDestinationAddress(InetSocketAddress.createUnresolved(value, port));
        }
        this.next.handleRequest(exchange);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new ProxyPeerAddressHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "proxy-peer-address";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

