/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.PushBuilder;

public class PushBuilderImpl
implements PushBuilder {
    private static final Set<HttpString> IGNORE;
    private final HttpServletRequestImpl servletRequest;
    private String method;
    private String queryString;
    private String sessionId;
    private boolean conditional;
    private final HeaderMap headers = new HeaderMap();
    private String path;
    private String etag;
    private String lastModified;

    public PushBuilderImpl(HttpServletRequestImpl servletRequest) {
        this.servletRequest = servletRequest;
        this.method = "GET";
        this.queryString = servletRequest.getQueryString();
        HttpSession session = servletRequest.getSession(false);
        this.sessionId = session != null ? session.getId() : servletRequest.getRequestedSessionId();
        this.conditional = servletRequest.getHeader("If-None-Match") != null || servletRequest.getHeader("If-Modified-Since") != null;
        for (HeaderValues headerValues : servletRequest.getExchange().getRequestHeaders()) {
            if (IGNORE.contains(headerValues.getHeaderName())) continue;
            this.headers.addAll(headerValues.getHeaderName(), headerValues);
        }
        if (servletRequest.getQueryString() == null) {
            this.headers.add(Headers.REFERER, servletRequest.getRequestURL().toString());
        } else {
            this.headers.add(Headers.REFERER, servletRequest.getRequestURL() + "?" + servletRequest.getQueryString());
        }
        this.path = null;
        this.etag = servletRequest.getHeader("ETag");
        for (Map.Entry entry : servletRequest.getExchange().getResponseCookies().entrySet()) {
            if (Objects.equals(0, ((Cookie)entry.getValue()).getMaxAge())) {
                HeaderValues existing = this.headers.get(Headers.COOKIE);
                if (existing == null) continue;
                Iterator<String> it = existing.iterator();
                while (it.hasNext()) {
                    String val = it.next();
                    if (!val.startsWith((String)entry.getKey() + "=")) continue;
                    it.remove();
                }
                continue;
            }
            this.headers.add(Headers.COOKIE, (String)entry.getKey() + "=" + entry.getValue());
        }
        this.lastModified = null;
        this.etag = null;
    }

    @Override
    public PushBuilder method(String method) {
        this.method = method;
        return this;
    }

    @Override
    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @Override
    public PushBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Override
    public PushBuilder conditional(boolean conditional) {
        this.conditional = conditional;
        return this;
    }

    @Override
    public PushBuilder setHeader(String name, String value) {
        this.headers.put(new HttpString(name), value);
        return this;
    }

    @Override
    public PushBuilder addHeader(String name, String value) {
        this.headers.add(new HttpString(name), value);
        return this;
    }

    @Override
    public PushBuilder removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public PushBuilder path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public PushBuilder etag(String etag) {
        this.etag = etag;
        return this;
    }

    @Override
    public PushBuilder lastModified(String lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Override
    public void push() {
        if (this.path == null) {
            throw UndertowServletMessages.MESSAGES.pathWasNotSet();
        }
        ServerConnection con = this.servletRequest.getExchange().getConnection();
        if (con.isPushSupported()) {
            HeaderMap newHeaders = new HeaderMap();
            for (HeaderValues entry : this.headers) {
                newHeaders.addAll(entry.getHeaderName(), entry);
            }
            if (this.conditional) {
                if (this.etag != null) {
                    newHeaders.put(Headers.IF_NONE_MATCH, this.etag);
                } else if (this.lastModified != null) {
                    newHeaders.put(Headers.IF_MODIFIED_SINCE, this.lastModified);
                }
            }
            if (this.sessionId != null) {
                newHeaders.put(Headers.COOKIE, "JSESSIONID=" + this.sessionId);
            }
            String path = this.path;
            if (this.queryString != null && !this.queryString.isEmpty()) {
                path = path + "?" + this.queryString;
            }
            con.pushResource(path, new HttpString(this.method), newHeaders);
        }
        this.path = null;
        this.etag = null;
        this.lastModified = null;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isConditional() {
        return this.conditional;
    }

    @Override
    public Set<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (HeaderValues name : this.headers) {
            names.add(name.getHeaderName().toString());
        }
        return names;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    static {
        HashSet<HttpString> ignore = new HashSet<HttpString>();
        ignore.add(Headers.IF_MATCH);
        ignore.add(Headers.IF_NONE_MATCH);
        ignore.add(Headers.IF_MODIFIED_SINCE);
        ignore.add(Headers.IF_UNMODIFIED_SINCE);
        ignore.add(Headers.IF_RANGE);
        ignore.add(Headers.RANGE);
        ignore.add(Headers.ACCEPT_RANGES);
        ignore.add(Headers.EXPECT);
        ignore.add(Headers.AUTHORIZATION);
        ignore.add(Headers.REFERER);
        IGNORE = Collections.unmodifiableSet(ignore);
    }
}

