/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.http2.tests.framework;

import io.undertow.client.ClientConnection;
import io.undertow.client.UndertowClient;
import io.undertow.http2.tests.framework.Http2Client;
import io.undertow.http2.tests.framework.Http2TestRunner;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.xnio.OptionMap;

public class TestEnvironment {
    public static Http2Client connectViaUpgrade() throws IOException {
        return new Http2Client((ClientConnection)UndertowClient.getInstance().connect(TestEnvironment.getHttp2UpgradeURL(), Http2TestRunner.getWorker(), Http2TestRunner.getBufferPool(), OptionMap.EMPTY).get());
    }

    public static Http2Client connectViaAlpn() throws IOException {
        return new Http2Client((ClientConnection)UndertowClient.getInstance().connect(TestEnvironment.getHttp2AlpnURL(), Http2TestRunner.getWorker(), Http2TestRunner.getClientXnioSsl(), Http2TestRunner.getBufferPool(), OptionMap.EMPTY).get());
    }

    public static int getPort() {
        return 7777;
    }

    public static String getHost() {
        return "localhost";
    }

    public static String getBasePath() {
        return "/";
    }

    public static URI getHttp2UpgradeURL() {
        try {
            return new URI("h2c", null, TestEnvironment.getHost(), TestEnvironment.getPort(), TestEnvironment.getBasePath(), "", "");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI getHttp2AlpnURL() {
        try {
            return new URI("h2", null, TestEnvironment.getHost(), TestEnvironment.getPort(), TestEnvironment.getBasePath(), "", "");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

