/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.http2.tests.framework;

import io.undertow.UndertowOptions;
import io.undertow.http2.tests.framework.Http2TestRunner;
import io.undertow.http2.tests.framework.ServerController;
import io.undertow.http2.tests.framework.TestEnvironment;
import io.undertow.http2.tests.framework.UndertowTestHandler;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.server.protocol.http2.Http2OpenListener;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.jboss.logging.Logger;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.JsseXnioSsl;

public class UndertowTestServer
implements ServerController {
    private static OpenListener openListener;
    private static ChannelListener acceptListener;
    private static XnioWorker worker;
    private static AcceptingChannel<? extends StreamConnection> server;
    private static Xnio xnio;
    private static final Logger log;

    @Override
    public void start(String host, int httpPort, int httpsPort) {
        xnio = Xnio.getInstance((String)"nio", (ClassLoader)UndertowTestServer.class.getClassLoader());
        try {
            worker = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
            OptionMap serverOptions = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).set(Options.BALANCING_TOKENS, 1).set(Options.BALANCING_CONNECTIONS, 2).getMap();
            ByteBufferSlicePool pool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 2 * Http2TestRunner.BUFFER_SIZE, 100 * Http2TestRunner.BUFFER_SIZE);
            openListener = new Http2OpenListener((Pool)pool, OptionMap.create((Option)UndertowOptions.ENABLE_SPDY, (Object)true));
            acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)new AlpnOpenListener((Pool)pool).addProtocol("h2-14", (DelegateOpenListener)openListener, 10));
            SSLContext serverContext = Http2TestRunner.getServerSslContext();
            JsseXnioSsl xnioSsl = new JsseXnioSsl(xnio, OptionMap.EMPTY, serverContext);
            server = xnioSsl.createSslConnectionServer(worker, new InetSocketAddress(TestEnvironment.getHost(), TestEnvironment.getPort()), acceptListener, serverOptions);
            server.resumeAccepts();
            openListener.setRootHandler((HttpHandler)new UndertowTestHandler());
            server.resumeAccepts();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
    }

    static {
        log = Logger.getLogger(UndertowTestServer.class);
    }
}

