/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.jakartaee9;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

class TransformConstants {
    private static final String MAVEN_PROJECT_DIR_PROPERTY = "maven.multiModuleProjectDirectory";
    private static final String JAKARTAEE9_DIR_NAME = File.separator + "jakartaee9";
    private static final String INPUT_DIR_NAME = File.separator + "target" + File.separator + "input";
    private static final String OUTPUT_DIR_NAME = File.separator + "target" + File.separator + "output";
    static final File INPUT_DIR;
    static final File OUTPUT_DIR;
    static final String JAR_TYPE = "jar";
    static final String JAR_EXTENSION = ".jar";
    static final String POM_TYPE = "pom";
    static final String POM_EXTENSION = ".pom";
    static final String SERVLET_SPEC_VERSION_PROPERTY = "version.jakarta.servlet-api";
    static final String WEBSOCKETS_SPEC_VERSION_PROPERTY = "version.jakarta.websocket-client-api";
    static final String SERVLET_SPEC_VERSION;
    static final String WEBSOCKETS_SPEC_VERSION;
    static final String SERVLET_SPEC_JAKARTAEE8_GROUP = "org.jboss.spec.javax.servlet";
    static final String SERVLET_SPEC_JAKARTAEE9_GROUP = "jakarta.servlet";
    static final String SERVLET_SPEC_JAKARTAEE8_ARTIFACT = "jboss-servlet-api_4.0_spec";
    static final String SERVLET_SPEC_JAKARTAEE9_ARTIFACT = "jakarta.servlet-api";
    static final String WEBSOCKETS_SPEC_JAKARTAEE8_GROUP = "org.jboss.spec.javax.websocket";
    static final String WEBSOCKETS_SPEC_JAKARTAEE9_GROUP = "jakarta.websocket";
    static final String WEBSOCKETS_SPEC_JAKARTAEE8_ARTIFACT = "jboss-websocket-api_1.1_spec";
    static final String WEBSOCKETS_SPEC_JAKARTAEE9_ARTIFACT = "jakarta.websocket-client-api";
    static final String VERSION_STRING;

    TransformConstants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        SERVLET_SPEC_VERSION = System.getProperty(SERVLET_SPEC_VERSION_PROPERTY);
        WEBSOCKETS_SPEC_VERSION = System.getProperty(WEBSOCKETS_SPEC_VERSION_PROPERTY);
        Properties versionProps = new Properties();
        String versionString = "(unknown)";
        try {
            InputStream stream = TransformConstants.class.getClassLoader().getResourceAsStream("Version.properties");
            try {
                InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                try {
                    versionProps.load(reader);
                    versionString = versionProps.getProperty("version", versionString);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException stream) {
            // empty catch block
        }
        VERSION_STRING = versionString;
        String projectDirectoryPath = System.getProperty(MAVEN_PROJECT_DIR_PROPERTY);
        assert (projectDirectoryPath != null);
        if (!projectDirectoryPath.endsWith(JAKARTAEE9_DIR_NAME)) {
            projectDirectoryPath = projectDirectoryPath + JAKARTAEE9_DIR_NAME;
        }
        INPUT_DIR = new File(projectDirectoryPath + INPUT_DIR_NAME);
        OUTPUT_DIR = new File(projectDirectoryPath + OUTPUT_DIR_NAME);
        assert (INPUT_DIR.exists());
        if (!OUTPUT_DIR.exists()) {
            OUTPUT_DIR.mkdir();
        }
    }
}

