/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.jakartaee9;

import io.undertow.jakartaee9.TransformConstants;
import io.undertow.jakartaee9.UndertowJakartaEE9Logger;
import java.io.File;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class JakartaEE9Deployer {
    public static void main(String[] args) throws MavenInvocationException {
        File[] pomFiles = TransformConstants.OUTPUT_DIR.listFiles((dir, name) -> name.endsWith(".pom"));
        if (pomFiles == null) {
            throw UndertowJakartaEE9Logger.LOGGER.pomFilesNotFoundInOutputDir(TransformConstants.OUTPUT_DIR.getAbsolutePath());
        }
        for (File pomFile : pomFiles) {
            String pomFileName = pomFile.getAbsolutePath();
            String jarFileName = pomFile.getAbsolutePath().substring(0, pomFileName.length() - ".pom".length()) + ".jar";
            UndertowJakartaEE9Logger.LOGGER.installingFile(jarFileName, pomFile.getAbsolutePath());
            Properties properties = new Properties();
            properties.put("file", jarFileName);
            properties.put("pomFile", pomFileName);
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setGoals(Collections.singletonList("deploy:deploy-file"));
            request.setProperties(properties);
            DefaultInvoker invoker = new DefaultInvoker();
            invoker.execute((InvocationRequest)request);
        }
    }
}

