/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.annotationprocessor;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.code.CodeLocation;
import org.jboss.classfilewriter.code.LookupSwitchBuilder;
import org.jboss.classfilewriter.code.TableSwitchBuilder;
import org.jboss.classfilewriter.util.DescriptorUtils;

public abstract class AbstractParserGenerator {
    public final String parseStateClass;
    public final String resultClass;
    public final String parseStateDescriptor;
    public final String httpExchangeDescriptor;
    public static final String HTTP_STRING_CLASS = "io.undertow.util.HttpString";
    public static final String HTTP_STRING_DESCRIPTOR = DescriptorUtils.makeDescriptor((String)"io.undertow.util.HttpString");
    public static final int NO_STATE = -1;
    public static final int PREFIX_MATCH = -2;
    private static final int CONSTRUCTOR_HTTP_STRING_MAP_VAR = 1;
    protected static final int BYTE_BUFFER_VAR = 1;
    protected static final int BYTES_REMAINING_VAR = 2;
    protected static final int PARSE_STATE_VAR = 3;
    protected static final int HTTP_RESULT = 4;
    protected static final int CURRENT_STATE_VAR = 5;
    protected static final int STATE_POS_VAR = 6;
    protected static final int STATE_CURRENT_VAR = 7;
    protected static final int STATE_STRING_BUILDER_VAR = 8;
    protected static final int STATE_CURRENT_BYTES_VAR = 9;
    public static final String HANDLE_HTTP_VERB = "handleHttpVerb";
    public static final String HANDLE_PATH = "handlePath";
    public static final String HANDLE_HTTP_VERSION = "handleHttpVersion";
    public static final String HANDLE_AFTER_VERSION = "handleAfterVersion";
    public static final String HANDLE_HEADER = "handleHeader";
    public static final String HANDLE_HEADER_VALUE = "handleHeaderValue";
    public static final String CLASS_NAME_SUFFIX = "$$generated";

    public AbstractParserGenerator(String parseStateClass, String resultClass) {
        this.parseStateClass = parseStateClass;
        this.resultClass = resultClass;
        this.parseStateDescriptor = DescriptorUtils.makeDescriptor((String)parseStateClass);
        this.httpExchangeDescriptor = DescriptorUtils.makeDescriptor((String)resultClass);
    }

    public byte[] createTokenizer(String existingClassName, String[] httpVerbs, String[] httpVersions, String[] standardHeaders) {
        String className = existingClassName + CLASS_NAME_SUFFIX;
        ClassFile file = new ClassFile(className, existingClassName, new String[0]);
        ClassMethod ctor = file.addMethod(1, "<init>", "V", new String[0]);
        ctor.getCodeAttribute().aload(0);
        ctor.getCodeAttribute().invokespecial(existingClassName, "<init>", "()V");
        ctor.getCodeAttribute().returnInstruction();
        ClassMethod sctor = file.addMethod(9, "<clinit>", "V", new String[0]);
        AtomicInteger fieldCounter = new AtomicInteger(1);
        sctor.getCodeAttribute().invokestatic(existingClassName, "httpStrings", "()" + DescriptorUtils.makeDescriptor(Map.class));
        sctor.getCodeAttribute().astore(1);
        this.createStateMachines(httpVerbs, httpVersions, standardHeaders, className, file, sctor, fieldCounter);
        sctor.getCodeAttribute().returnInstruction();
        return file.toBytecode();
    }

    protected abstract void createStateMachines(String[] var1, String[] var2, String[] var3, String var4, ClassFile var5, ClassMethod var6, AtomicInteger var7);

    protected void createStateMachine(String[] originalItems, String className, ClassFile file, ClassMethod sctor, AtomicInteger fieldCounter, String methodName, CustomStateMachine stateMachine) {
        ArrayList<State> allStates = new ArrayList<State>();
        State initial = new State(0, "");
        for (String value : originalItems) {
            AbstractParserGenerator.addStates(initial, value, allStates);
        }
        AtomicInteger stateCounter = new AtomicInteger(-1);
        this.setupStateNo(initial, stateCounter, fieldCounter);
        for (State state : allStates) {
            this.setupStateNo(state, stateCounter, fieldCounter);
            this.createStateField(state, file, sctor.getCodeAttribute());
        }
        int noStates = stateCounter.get();
        ClassMethod handle = file.addMethod(4, methodName, "I", new String[]{DescriptorUtils.makeDescriptor(ByteBuffer.class), "I", this.parseStateDescriptor, this.httpExchangeDescriptor});
        this.writeStateMachine(className, file, handle.getCodeAttribute(), initial, allStates, noStates, stateMachine, sctor);
    }

    private void createStateField(State state, ClassFile file, CodeAttribute sc) {
        if (state.fieldName != null) {
            file.addField(26, state.fieldName, "[B");
            sc.ldc(state.terminalState);
            sc.ldc("ISO-8859-1");
            sc.invokevirtual(String.class.getName(), "getBytes", "(Ljava/lang/String;)[B");
            sc.putstatic(file.getName(), state.fieldName, "[B");
        }
        if (state.httpStringFieldName != null) {
            file.addField(26, state.httpStringFieldName, HTTP_STRING_DESCRIPTOR);
            sc.aload(1);
            if (state.terminalState != null) {
                sc.ldc(state.terminalState);
            } else {
                sc.ldc(state.soFar);
            }
            sc.invokeinterface(Map.class.getName(), "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            sc.dup();
            BranchEnd end = sc.ifnull();
            sc.checkcast(HTTP_STRING_CLASS);
            sc.putstatic(file.getName(), state.httpStringFieldName, HTTP_STRING_DESCRIPTOR);
            BranchEnd done = sc.gotoInstruction();
            sc.branchEnd(end);
            sc.pop();
            sc.newInstruction(HTTP_STRING_CLASS);
            sc.dup();
            if (state.terminalState != null) {
                sc.ldc(state.terminalState);
            } else {
                sc.ldc(state.soFar);
            }
            sc.invokespecial(HTTP_STRING_CLASS, "<init>", "(Ljava/lang/String;)V");
            sc.putstatic(file.getName(), state.httpStringFieldName, HTTP_STRING_DESCRIPTOR);
            sc.branchEnd(done);
        }
    }

    private void setupStateNo(State state, AtomicInteger stateCounter, AtomicInteger fieldCounter) {
        if (state.next.isEmpty()) {
            state.stateno = -2;
            state.terminalState = state.soFar;
            state.fieldName = "STATE_BYTES_" + fieldCounter.incrementAndGet();
        } else if (state.next.size() == 1) {
            String terminal = null;
            State s = state.next.values().iterator().next();
            while (s.next.size() <= 1) {
                if (s.next.isEmpty()) {
                    terminal = s.soFar;
                    break;
                }
                s = s.next.values().iterator().next();
            }
            if (terminal != null) {
                state.stateno = -2;
                state.terminalState = terminal;
                state.fieldName = "STATE_BYTES_" + fieldCounter.incrementAndGet();
            } else {
                state.stateno = stateCounter.incrementAndGet();
            }
        } else {
            state.stateno = stateCounter.incrementAndGet();
        }
        state.httpStringFieldName = "HTTP_STRING_" + fieldCounter.incrementAndGet();
    }

    private void writeStateMachine(String className, ClassFile file, CodeAttribute c, State initial, List<State> allStates, int noStates, CustomStateMachine stateMachine, ClassMethod sctor) {
        ArrayList<State> states = new ArrayList<State>();
        states.add(initial);
        states.addAll(allStates);
        Collections.sort(states);
        c.aload(3);
        c.dup();
        c.dup();
        c.dup();
        c.dup();
        c.getfield(this.parseStateClass, "parseState", "I");
        c.istore(5);
        c.getfield(this.parseStateClass, "pos", "I");
        c.istore(6);
        c.getfield(this.parseStateClass, "current", HTTP_STRING_DESCRIPTOR);
        c.astore(7);
        c.getfield(this.parseStateClass, "currentBytes", "[B");
        c.astore(9);
        c.getfield(this.parseStateClass, "stringBuilder", DescriptorUtils.makeDescriptor(StringBuilder.class));
        c.astore(8);
        c.iload(2);
        BranchEnd nonZero = c.ifne();
        c.iconst(0);
        c.returnInstruction();
        c.branchEnd(nonZero);
        c.iload(5);
        TableSwitchBuilder builder = new TableSwitchBuilder(-2, noStates);
        IdentityHashMap<State, AtomicReference> ends = new IdentityHashMap<State, AtomicReference>();
        AtomicReference prefixMatch = builder.add();
        AtomicReference noState = builder.add();
        ends.put(initial, builder.add());
        for (State s : states) {
            if (s.stateno <= 0) continue;
            ends.put(s, builder.add());
        }
        c.tableswitch(builder);
        AbstractParserGenerator.stateNotFound(c, builder);
        this.setupLocalVariables(c);
        CodeLocation returnIncompleteCode = c.mark();
        c.aload(3);
        c.dup();
        c.dup();
        c.dup();
        c.dup();
        c.iload(6);
        c.putfield(this.parseStateClass, "pos", "I");
        c.aload(7);
        c.putfield(this.parseStateClass, "current", HTTP_STRING_DESCRIPTOR);
        c.aload(9);
        c.putfield(this.parseStateClass, "currentBytes", "[B");
        c.aload(8);
        c.putfield(this.parseStateClass, "stringBuilder", DescriptorUtils.makeDescriptor(StringBuilder.class));
        c.iload(5);
        c.putfield(this.parseStateClass, "parseState", "I");
        c.iload(2);
        c.returnInstruction();
        this.setupLocalVariables(c);
        CodeLocation returnCompleteCode = c.mark();
        c.aload(3);
        c.dup();
        c.dup();
        c.dup();
        c.dup();
        c.iconst(0);
        c.putfield(this.parseStateClass, "pos", "I");
        c.aconstNull();
        c.putfield(this.parseStateClass, "current", HTTP_STRING_DESCRIPTOR);
        c.aconstNull();
        c.putfield(this.parseStateClass, "currentBytes", "[B");
        c.aconstNull();
        c.putfield(this.parseStateClass, "stringBuilder", DescriptorUtils.makeDescriptor(StringBuilder.class));
        c.iconst(0);
        c.putfield(this.parseStateClass, "parseState", "I");
        c.iload(2);
        c.returnInstruction();
        c.branchEnd((BranchEnd)prefixMatch.get());
        CodeLocation prefixLoop = c.mark();
        this.handleReturnIfNoMoreBytes(c, returnIncompleteCode);
        c.aload(1);
        c.invokevirtual(ByteBuffer.class.getName(), "get", "()B");
        c.dup();
        c.dup();
        c.iinc(2, -1);
        HashSet<BranchEnd> prefixHandleSpace = new HashSet<BranchEnd>();
        if (stateMachine.isHeader()) {
            c.iconst(58);
            prefixHandleSpace.add(c.ifIcmpeq());
            c.dup();
        }
        c.iconst(32);
        prefixHandleSpace.add(c.ifIcmpeq());
        c.dup();
        c.iconst(9);
        prefixHandleSpace.add(c.ifIcmpeq());
        c.dup();
        c.iconst(13);
        prefixHandleSpace.add(c.ifIcmpeq());
        c.dup();
        c.iconst(10);
        prefixHandleSpace.add(c.ifIcmpeq());
        c.aload(9);
        c.arraylength();
        c.iload(6);
        BranchEnd overrun = c.ifIcmpeq();
        c.dup();
        c.aload(9);
        c.iload(6);
        c.baload();
        c.isub();
        BranchEnd noMatch = c.ifne();
        c.pop2();
        c.iinc(6, 1);
        this.handleReturnIfNoMoreBytes(c, returnIncompleteCode);
        c.gotoInstruction(prefixLoop);
        c.branchEnd(overrun);
        c.branchEnd(noMatch);
        c.iconst(-1);
        c.istore(5);
        c.newInstruction(StringBuilder.class);
        c.dup();
        c.aload(7);
        c.invokevirtual(HTTP_STRING_CLASS, "toString", "()Ljava/lang/String;");
        c.iconst(0);
        c.iload(6);
        c.invokevirtual(String.class.getName(), "substring", "(II)Ljava/lang/String;");
        c.invokespecial(StringBuilder.class.getName(), "<init>", "(Ljava/lang/String;)V");
        c.swap();
        c.invokevirtual(StringBuilder.class.getName(), "append", "(C)Ljava/lang/StringBuilder;");
        c.astore(8);
        c.pop();
        BranchEnd prefixToNoState = c.gotoInstruction();
        for (BranchEnd b : prefixHandleSpace) {
            c.branchEnd(b);
        }
        c.iconst(0);
        c.istore(5);
        c.aload(9);
        c.arraylength();
        c.iload(6);
        BranchEnd correctLength = c.ifIcmpeq();
        c.newInstruction(HTTP_STRING_CLASS);
        c.dup();
        c.aload(9);
        c.iconst(0);
        c.iload(6);
        c.invokespecial(HTTP_STRING_CLASS, "<init>", "([BII)V");
        stateMachine.handleOtherToken(c);
        c.pop();
        this.tokenDone(c, returnCompleteCode, stateMachine);
        c.branchEnd(correctLength);
        c.aload(7);
        stateMachine.handleStateMachineMatchedToken(c);
        c.pop();
        this.tokenDone(c, returnCompleteCode, stateMachine);
        c.branchEnd((BranchEnd)noState.get());
        c.branchEnd(prefixToNoState);
        CodeLocation noStateLoop = c.mark();
        this.handleReturnIfNoMoreBytes(c, returnIncompleteCode);
        c.aload(1);
        c.invokevirtual(ByteBuffer.class.getName(), "get", "()B");
        c.dup();
        c.iinc(2, -1);
        HashSet<BranchEnd> nostateHandleSpace = new HashSet<BranchEnd>();
        if (stateMachine.isHeader()) {
            c.iconst(58);
            nostateHandleSpace.add(c.ifIcmpeq());
            c.dup();
        }
        c.iconst(32);
        nostateHandleSpace.add(c.ifIcmpeq());
        c.dup();
        c.iconst(9);
        nostateHandleSpace.add(c.ifIcmpeq());
        c.dup();
        c.iconst(13);
        nostateHandleSpace.add(c.ifIcmpeq());
        c.dup();
        c.iconst(10);
        nostateHandleSpace.add(c.ifIcmpeq());
        c.aload(8);
        c.swap();
        c.invokevirtual(StringBuilder.class.getName(), "append", "(C)Ljava/lang/StringBuilder;");
        c.pop();
        c.iload(2);
        c.ifne(noStateLoop);
        c.aload(3);
        c.dup();
        c.aload(8);
        c.putfield(this.parseStateClass, "stringBuilder", DescriptorUtils.makeDescriptor(StringBuilder.class));
        c.iload(5);
        c.putfield(this.parseStateClass, "parseState", "I");
        c.iconst(0);
        c.returnInstruction();
        for (BranchEnd b : nostateHandleSpace) {
            c.branchEnd(b);
        }
        c.aload(8);
        c.invokevirtual(StringBuilder.class.getName(), "toString", "()Ljava/lang/String;");
        c.aconstNull();
        c.astore(8);
        c.newInstruction(HTTP_STRING_CLASS);
        c.dupX1();
        c.swap();
        c.invokespecial(HTTP_STRING_CLASS, "<init>", "(Ljava/lang/String;)V");
        stateMachine.handleOtherToken(c);
        this.tokenDone(c, returnCompleteCode, stateMachine);
        this.invokeState(className, file, c, (BranchEnd)((AtomicReference)ends.get(initial)).get(), initial, initial, noStateLoop, prefixLoop, returnIncompleteCode, returnCompleteCode, stateMachine);
        for (State s : allStates) {
            if (s.stateno < 0) continue;
            this.invokeState(className, file, c, (BranchEnd)((AtomicReference)ends.get(s)).get(), s, initial, noStateLoop, prefixLoop, returnIncompleteCode, returnCompleteCode, stateMachine);
        }
    }

    private void setupLocalVariables(CodeAttribute c) {
        c.setupFrame(new String[]{DescriptorUtils.makeDescriptor((String)"fakeclass"), "[B", "I", this.parseStateDescriptor, this.httpExchangeDescriptor, "I", "I", DescriptorUtils.makeDescriptor(String.class), DescriptorUtils.makeDescriptor(StringBuilder.class), "[B"});
    }

    private void handleReturnIfNoMoreBytes(CodeAttribute c, CodeLocation returnCode) {
        c.iload(2);
        c.ifEq(returnCode);
    }

    private void tokenDone(CodeAttribute c, CodeLocation returnCode, CustomStateMachine stateMachine) {
        stateMachine.updateParseState(c);
        c.gotoInstruction(returnCode);
    }

    private void invokeState(String className, ClassFile file, CodeAttribute c, BranchEnd methodState, State currentState, State initialState, CodeLocation noStateStart, CodeLocation prefixStart, CodeLocation returnIncompleteCode, CodeLocation returnCompleteCode, CustomStateMachine stateMachine) {
        c.branchEnd(methodState);
        currentState.mark(c);
        BranchEnd parseDone = null;
        if (currentState == initialState) {
            c.aload(3);
            c.getfield(this.parseStateClass, "leftOver", "B");
            c.dup();
            BranchEnd end = c.ifne();
            c.pop();
            this.handleReturnIfNoMoreBytes(c, returnIncompleteCode);
            c.aload(1);
            c.invokevirtual(ByteBuffer.class.getName(), "get", "()B");
            c.iinc(2, -1);
            BranchEnd cont = c.gotoInstruction();
            c.branchEnd(end);
            c.aload(3);
            c.iconst(0);
            c.putfield(this.parseStateClass, "leftOver", "B");
            c.branchEnd(cont);
        } else {
            this.handleReturnIfNoMoreBytes(c, returnIncompleteCode);
            c.aload(1);
            c.invokevirtual(ByteBuffer.class.getName(), "get", "()B");
            c.iinc(2, -1);
        }
        c.dup();
        HashSet<AtomicReference<BranchEnd>> tokenEnds = new HashSet<AtomicReference<BranchEnd>>();
        IdentityHashMap<State, AtomicReference<BranchEnd>> ends = new IdentityHashMap<State, AtomicReference<BranchEnd>>();
        if (currentState.next.size() > 6) {
            LookupSwitchBuilder s = new LookupSwitchBuilder();
            if (stateMachine.isHeader()) {
                tokenEnds.add(s.add(58));
            }
            tokenEnds.add(s.add(32));
            tokenEnds.add(s.add(9));
            tokenEnds.add(s.add(13));
            tokenEnds.add(s.add(10));
            for (State state : currentState.next.values()) {
                ends.put(state, s.add((int)state.value));
            }
            c.lookupswitch(s);
            BranchEnd branchEnd = (BranchEnd)s.getDefaultBranchEnd().get();
            c.branchEnd(branchEnd);
        } else {
            for (State state : currentState.next.values()) {
                c.iconst((int)state.value);
                ends.put(state, new AtomicReference<BranchEnd>(c.ifIcmpeq()));
                c.dup();
            }
            if (stateMachine.isHeader()) {
                c.iconst(58);
                tokenEnds.add(new AtomicReference<BranchEnd>(c.ifIcmpeq()));
                c.dup();
            }
            c.iconst(32);
            tokenEnds.add(new AtomicReference<BranchEnd>(c.ifIcmpeq()));
            c.dup();
            c.iconst(9);
            tokenEnds.add(new AtomicReference<BranchEnd>(c.ifIcmpeq()));
            c.dup();
            c.iconst(13);
            tokenEnds.add(new AtomicReference<BranchEnd>(c.ifIcmpeq()));
            c.dup();
            c.iconst(10);
            tokenEnds.add(new AtomicReference<BranchEnd>(c.ifIcmpeq()));
        }
        c.iconst(-1);
        c.istore(5);
        c.newInstruction(StringBuilder.class);
        c.dup();
        c.ldc(currentState.soFar);
        c.invokespecial(StringBuilder.class.getName(), "<init>", "(Ljava/lang/String;)V");
        c.swap();
        c.invokevirtual(StringBuilder.class.getName(), "append", "(C)Ljava/lang/StringBuilder;");
        c.astore(8);
        c.gotoInstruction(noStateStart);
        for (AtomicReference atomicReference : tokenEnds) {
            c.branchEnd((BranchEnd)atomicReference.get());
        }
        if (!currentState.soFar.equals("")) {
            c.getstatic(file.getName(), currentState.httpStringFieldName, HTTP_STRING_DESCRIPTOR);
            stateMachine.handleStateMachineMatchedToken(c);
            this.tokenDone(c, returnCompleteCode, stateMachine);
        } else {
            if (stateMachine.initialNewlineMeansRequestDone()) {
                c.iconst(10);
                parseDone = c.ifIcmpeq();
            } else {
                c.pop();
            }
            this.setupLocalVariables(c);
            this.handleReturnIfNoMoreBytes(c, returnIncompleteCode);
        }
        initialState.jumpTo(c);
        for (Map.Entry entry : ends.entrySet()) {
            State state;
            c.branchEnd((BranchEnd)((AtomicReference)entry.getValue()).get());
            c.pop();
            state = (State)entry.getKey();
            if (state.stateno < 0) {
                c.iconst(state.stateno.intValue());
                c.istore(5);
                c.getstatic(className, state.httpStringFieldName, HTTP_STRING_DESCRIPTOR);
                c.astore(7);
                c.getstatic(className, state.fieldName, "[B");
                c.astore(9);
                c.iconst(state.soFar.length());
                c.istore(6);
                c.gotoInstruction(prefixStart);
                continue;
            }
            c.iconst(state.stateno.intValue());
            c.istore(5);
            state.jumpTo(c);
        }
        if (parseDone != null) {
            c.branchEnd(parseDone);
            c.aload(3);
            c.invokevirtual(this.parseStateClass, "parseComplete", "()V");
            c.iconst(0);
            c.returnInstruction();
        }
    }

    private static void stateNotFound(CodeAttribute c, TableSwitchBuilder builder) {
        c.branchEnd((BranchEnd)builder.getDefaultBranchEnd().get());
        c.newInstruction(RuntimeException.class);
        c.dup();
        c.ldc("Could not find state");
        c.invokespecial(RuntimeException.class.getName(), "<init>", "(Ljava/lang/String;)V");
        c.athrow();
    }

    private static void addStates(State initial, String value, List<State> allStates) {
        AbstractParserGenerator.addStates(initial, value, 0, allStates);
    }

    private static void addStates(State current, String value, int i, List<State> allStates) {
        if (i == value.length()) {
            current.finalState = true;
            return;
        }
        byte[] bytes = value.getBytes();
        byte currentByte = bytes[i];
        State newState = current.next.get(currentByte);
        if (newState == null) {
            newState = new State(currentByte, value.substring(0, i + 1));
            current.next.put(currentByte, newState);
            allStates.add(newState);
        }
        AbstractParserGenerator.addStates(newState, value, i + 1, allStates);
    }

    public static interface CustomStateMachine {
        public boolean isHeader();

        public void handleStateMachineMatchedToken(CodeAttribute var1);

        public void handleOtherToken(CodeAttribute var1);

        public void updateParseState(CodeAttribute var1);

        public boolean initialNewlineMeansRequestDone();
    }

    private static class State
    implements Comparable<State> {
        Integer stateno;
        String terminalState;
        String fieldName;
        String httpStringFieldName;
        boolean finalState;
        final byte value;
        final String soFar;
        final Map<Byte, State> next = new HashMap<Byte, State>();
        private final Set<BranchEnd> branchEnds = new HashSet<BranchEnd>();
        private CodeLocation location;

        private State(byte value, String soFar) {
            this.value = value;
            this.soFar = soFar;
        }

        @Override
        public int compareTo(State o) {
            return this.stateno.compareTo(o.stateno);
        }

        void mark(CodeAttribute ca) {
            this.location = ca.mark();
            for (BranchEnd br : this.branchEnds) {
                ca.branchEnd(br);
            }
        }

        void jumpTo(CodeAttribute ca) {
            if (this.location == null) {
                this.branchEnds.add(ca.gotoInstruction());
            } else {
                ca.gotoInstruction(this.location);
            }
        }

        void ifne(CodeAttribute ca) {
            if (this.location == null) {
                this.branchEnds.add(ca.ifne());
            } else {
                ca.ifne(this.location);
            }
        }
    }
}

