/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.annotationprocessor;

import io.undertow.annotationprocessor.AbstractParserGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.CodeAttribute;

public class ResponseParserGenerator
extends AbstractParserGenerator {
    public static final String PARSE_STATE_CLASS = "io.undertow.client.ResponseParseState";
    public static final String HTTP_RESPONSE_CLASS = "io.undertow.client.PendingHttpRequest";
    public static final int VERSION = 0;
    public static final int STATUS_CODE = 1;
    public static final int REASON_PHRASE = 2;
    public static final int AFTER_REASON_PHRASE = 3;
    public static final int HEADER = 4;
    public static final int HEADER_VALUE = 5;
    public static final int PARSE_COMPLETE = 6;

    public ResponseParserGenerator() {
        super(PARSE_STATE_CLASS, HTTP_RESPONSE_CLASS, "()V");
    }

    @Override
    protected void createStateMachines(String[] httpVerbs, String[] httpVersions, String[] standardHeaders, String className, ClassFile file, ClassMethod sctor, AtomicInteger fieldCounter) {
        this.createStateMachine(httpVersions, className, file, sctor, fieldCounter, "handleHttpVersion", new VersionStateMachine());
        this.createStateMachine(standardHeaders, className, file, sctor, fieldCounter, "handleHeader", new HeaderStateMachine());
    }

    private static class VersionStateMachine
    implements AbstractParserGenerator.CustomStateMachine {
        private VersionStateMachine() {
        }

        @Override
        public boolean isHeader() {
            return false;
        }

        @Override
        public void handleOtherToken(CodeAttribute c) {
            c.aload(3);
            c.swap();
            c.invokevirtual(ResponseParserGenerator.HTTP_RESPONSE_CLASS, "setProtocol", "(" + AbstractParserGenerator.HTTP_STRING_DESCRIPTOR + ")V");
        }

        @Override
        public void handleStateMachineMatchedToken(CodeAttribute c) {
            c.aload(3);
            c.swap();
            c.invokevirtual(ResponseParserGenerator.HTTP_RESPONSE_CLASS, "setProtocol", "(" + AbstractParserGenerator.HTTP_STRING_DESCRIPTOR + ")V");
        }

        @Override
        public void updateParseState(CodeAttribute c) {
            c.aload(2);
            c.swap();
            c.putfield(ResponseParserGenerator.PARSE_STATE_CLASS, "leftOver", "B");
            c.aload(2);
            c.iconst(1);
            c.putfield(ResponseParserGenerator.PARSE_STATE_CLASS, "state", "I");
        }

        @Override
        public boolean initialNewlineMeansRequestDone() {
            return false;
        }
    }

    private static class HeaderStateMachine
    implements AbstractParserGenerator.CustomStateMachine {
        private HeaderStateMachine() {
        }

        @Override
        public boolean isHeader() {
            return true;
        }

        @Override
        public void handleOtherToken(CodeAttribute c) {
            c.aload(2);
            c.swap();
            c.putfield(ResponseParserGenerator.PARSE_STATE_CLASS, "nextHeader", AbstractParserGenerator.HTTP_STRING_DESCRIPTOR);
        }

        @Override
        public void handleStateMachineMatchedToken(CodeAttribute c) {
            c.aload(2);
            c.swap();
            c.putfield(ResponseParserGenerator.PARSE_STATE_CLASS, "nextHeader", AbstractParserGenerator.HTTP_STRING_DESCRIPTOR);
        }

        @Override
        public void updateParseState(CodeAttribute c) {
            c.pop();
            c.aload(2);
            c.iconst(5);
            c.putfield(ResponseParserGenerator.PARSE_STATE_CLASS, "state", "I");
        }

        @Override
        public boolean initialNewlineMeansRequestDone() {
            return true;
        }
    }
}

