/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.jsr.JsrWebSocketMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.websocket.DeploymentException;

public class PathTemplate
implements Comparable<PathTemplate> {
    private final boolean template;
    private final String base;
    private final List<Part> parts;

    private PathTemplate(boolean template, String base, List<Part> parts) {
        this.template = template;
        this.base = base;
        this.parts = parts;
    }

    public static PathTemplate create(String path) throws DeploymentException {
        int state = 0;
        String base = "";
        ArrayList<Part> parts = new ArrayList<Part>();
        int stringStart = 0;
        block13: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '/') {
                        state = 1;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 1: {
                    if (c == '{') {
                        base = path.substring(0, i);
                        stringStart = i + 1;
                        state = 2;
                        continue block13;
                    }
                    if (c == '/') continue block13;
                    state = 0;
                    continue block13;
                }
                case 2: {
                    if (c != '}') continue block13;
                    Part part = new Part(true, path.substring(stringStart, i));
                    parts.add(part);
                    stringStart = i;
                    state = 3;
                    continue block13;
                }
                case 3: {
                    if (c == '/') {
                        state = 4;
                        continue block13;
                    }
                    throw JsrWebSocketMessages.MESSAGES.couldNotParseUriTemplate(path, i);
                }
                case 4: {
                    if (c == '{') {
                        stringStart = i + 1;
                        state = 2;
                        continue block13;
                    }
                    if (c == '/') continue block13;
                    stringStart = i;
                    state = 5;
                    continue block13;
                }
                case 5: {
                    if (c != '/') continue block13;
                    Part part = new Part(false, path.substring(stringStart, i));
                    parts.add(part);
                    stringStart = i + 1;
                    state = 4;
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: {
                base = path;
                break;
            }
            case 2: {
                throw JsrWebSocketMessages.MESSAGES.couldNotParseUriTemplate(path, path.length());
            }
            case 5: {
                Part part = new Part(false, path.substring(stringStart));
                parts.add(part);
                break;
            }
        }
        return new PathTemplate(state > 1, base, parts);
    }

    public boolean matches(String path, Map<String, String> pathParameters) {
        char c;
        int i;
        if (!path.startsWith(this.base)) {
            return false;
        }
        int baseLength = this.base.length();
        if (!this.template) {
            return path.length() == baseLength;
        }
        int cp = 0;
        Part current = this.parts.get(cp);
        int stringStart = baseLength;
        for (i = baseLength; i < path.length() && (c = path.charAt(i)) != '?'; ++i) {
            if (c != '/') continue;
            String result = path.substring(stringStart, i);
            if (current.template) {
                pathParameters.put(current.part, result);
            } else if (!result.equals(current.part)) {
                pathParameters.clear();
                return false;
            }
            if (++cp == this.parts.size()) {
                return true;
            }
            current = this.parts.get(cp);
            stringStart = i + 1;
        }
        if (cp + 1 != this.parts.size()) {
            pathParameters.clear();
            return false;
        }
        String result = path.substring(stringStart, i);
        if (current.template) {
            pathParameters.put(current.part, result);
        } else if (!result.equals(current.part)) {
            pathParameters.clear();
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(PathTemplate o) {
        if (this.template && !o.template) {
            return 1;
        }
        if (o.template && !this.template) {
            return -1;
        }
        int res = this.base.compareTo(o.base);
        if (res > 0) {
            return -1;
        }
        if (res < 0) {
            return 1;
        }
        if (!this.template) {
            return 0;
        }
        int i = 0;
        while (true) {
            int r;
            if (this.parts.size() == i) {
                if (o.parts.size() == i) {
                    return this.base.compareTo(o.base);
                }
                return 1;
            }
            if (o.parts.size() == i) {
                return -1;
            }
            Part thisPath = this.parts.get(i);
            Part otherPart = o.parts.get(i);
            if (thisPath.template && !otherPart.template) {
                return 1;
            }
            if (!thisPath.template && otherPart.template) {
                return -1;
            }
            if (!thisPath.template && (r = thisPath.part.compareTo(otherPart.part)) != 0) {
                return r;
            }
            ++i;
        }
    }

    public String toString() {
        return "PathTemplate{template=" + this.template + ", base='" + this.base + '\'' + ", parts=" + this.parts + '}';
    }

    private static class Part {
        final boolean template;
        final String part;

        private Part(boolean template, String part) {
            this.template = template;
            this.part = part;
        }

        public String toString() {
            return "Part{template=" + this.template + ", part='" + this.part + '\'' + '}';
        }
    }
}

