/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.jsr.AbstractFrameHandler;
import io.undertow.websockets.jsr.AsyncFrameHandler;
import io.undertow.websockets.jsr.DefaultPongMessage;
import io.undertow.websockets.jsr.UndertowSession;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;

class MixedFrameHandler
extends AsyncFrameHandler {
    final List<ByteBuffer> textFrame = new ArrayList<ByteBuffer>();
    final List<ByteBuffer> binaryFrame = new ArrayList<ByteBuffer>();

    public MixedFrameHandler(UndertowSession session, Endpoint endpoint) {
        super(session, endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTextFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.TEXT);
        if (handler == null) {
            return;
        }
        MessageHandler mHandler = handler.getHandler();
        if (mHandler instanceof MessageHandler.Async) {
            super.onTextFrame(s, header, payload);
        } else if (this.textFrame.isEmpty() && header.isLastFragement()) {
            ((MessageHandler.Basic)mHandler).onMessage((Object)MixedFrameHandler.toString(payload));
        } else {
            for (ByteBuffer buf : payload) {
                if (!buf.hasRemaining()) continue;
                this.textFrame.add(buf);
            }
            if (header.isLastFragement()) {
                try {
                    ((MessageHandler.Basic)mHandler).onMessage((Object)MixedFrameHandler.toString(this.textFrame.toArray(new ByteBuffer[0])));
                }
                finally {
                    this.textFrame.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBinaryFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.BYTE);
        if (handler == null) {
            return;
        }
        MessageHandler mHandler = handler.getHandler();
        if (mHandler instanceof AsyncFrameHandler) {
            super.onBinaryFrame(s, header, payload);
        } else if (this.binaryFrame.isEmpty() && header.isLastFragement()) {
            ((MessageHandler.Basic)mHandler).onMessage((Object)MixedFrameHandler.toBuffer(payload));
        } else {
            for (ByteBuffer buf : payload) {
                if (!buf.hasRemaining()) continue;
                this.binaryFrame.add(buf);
            }
            if (header.isLastFragement()) {
                try {
                    ((MessageHandler.Basic)mHandler).onMessage((Object)MixedFrameHandler.toBuffer(this.binaryFrame.toArray(new ByteBuffer[0])));
                }
                finally {
                    this.binaryFrame.clear();
                }
            }
        }
    }

    @Override
    public void onPongFrame(WebSocketSession s, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.PONG);
        if (handler != null) {
            PongMessage message = payload.length == 1 ? DefaultPongMessage.create(payload[0]) : DefaultPongMessage.create(MixedFrameHandler.toBuffer(payload));
            ((MessageHandler.Basic)handler.getHandler()).onMessage((Object)message);
        }
    }
}

