/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.util;

import io.undertow.websockets.jsr.JsrWebSocketMessages;
import java.lang.reflect.Method;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.MessageHandler;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Class<?> getHandlerType(Class<? extends MessageHandler> clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!"onMessage".equals(m.getName())) continue;
            return m.getParameterTypes()[0];
        }
        throw JsrWebSocketMessages.MESSAGES.unkownHandlerType(clazz);
    }

    public static Class<?> getEncoderType(Class<? extends Encoder> clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!"encode".equals(m.getName())) continue;
            return m.getParameterTypes()[0];
        }
        throw JsrWebSocketMessages.MESSAGES.unknownEncoderType(clazz);
    }

    public static Class<?> getDecoderType(Class<? extends Decoder> clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!"decode".equals(m.getName())) continue;
            return m.getReturnType();
        }
        throw JsrWebSocketMessages.MESSAGES.couldNotDetermineDecoderTypeFor(clazz);
    }
}

