/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.CloseReason;
import io.undertow.websockets.api.FrameHandler;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.jsr.DefaultPongMessage;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.util.ClassUtils;
import java.io.InputStream;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.xnio.Buffers;

abstract class AbstractFrameHandler<E extends MessageHandler>
implements FrameHandler {
    private final Endpoint endpoint;
    private final UndertowSession session;
    protected static final byte[] EMPTY = new byte[0];
    private final ConcurrentMap<FrameType, HandlerWrapper> handlers = new ConcurrentHashMap<FrameType, HandlerWrapper>();

    protected AbstractFrameHandler(UndertowSession session, Endpoint endpoint) {
        this.session = session;
        this.endpoint = endpoint;
    }

    public final void onPingFrame(WebSocketSession session, ByteBuffer ... payload) {
    }

    public final void onCloseFrame(WebSocketSession s, CloseReason reason) {
        try {
            if (reason == null) {
                this.session.close();
            } else {
                this.session.close(new javax.websocket.CloseReason(CloseReason.CloseCodes.getCloseCode((int)reason.getStatusCode()), reason.getReasonText()));
            }
        }
        catch (Throwable e) {
            this.endpoint.onError((Session)this.session, e);
        }
    }

    public void onPongFrame(WebSocketSession session, ByteBuffer ... payload) {
        HandlerWrapper handler = this.getHandler(FrameType.PONG);
        if (handler != null) {
            PongMessage message = payload.length == 1 ? DefaultPongMessage.create(payload[0]) : DefaultPongMessage.create(AbstractFrameHandler.toBuffer(payload));
            ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)message);
        }
    }

    public final void onError(WebSocketSession s, Throwable cause) {
        this.endpoint.onError((Session)this.session, cause);
    }

    protected static ByteBuffer toBuffer(ByteBuffer ... payload) {
        if (payload.length == 1) {
            return payload[0];
        }
        int size = (int)Buffers.remaining((Buffer[])payload);
        if (size == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer buf : payload) {
            buffer.put(buf);
        }
        buffer.flip();
        return buffer;
    }

    protected static byte[] toArray(ByteBuffer ... payload) {
        ByteBuffer buf;
        if (payload.length == 1 && (buf = payload[0]).hasArray() && buf.arrayOffset() == 0 && buf.position() == 0) {
            return buf.array();
        }
        int size = (int)Buffers.remaining((Buffer[])payload);
        byte[] data = new byte[size];
        for (ByteBuffer buf2 : payload) {
            buf2.get(data);
        }
        return data;
    }

    private static Class<?> type(MessageHandler handler, Encoding encoding) {
        Class<?> typeClazz = ClassUtils.getHandlerType(handler.getClass());
        return typeClazz;
    }

    public final void addHandler(E handler) {
        Class<?> type = ClassUtils.getHandlerType(handler.getClass());
        this.verify(type, handler);
        HandlerWrapper handlerWrapper = this.createHandlerWrapper(type, handler);
        if (this.handlers.containsKey((Object)handlerWrapper.getFrameType())) {
            throw JsrWebSocketMessages.MESSAGES.handlerAlreadyRegistered(handlerWrapper.getFrameType());
        }
        if (this.handlers.putIfAbsent(handlerWrapper.getFrameType(), handlerWrapper) != null) {
            throw JsrWebSocketMessages.MESSAGES.handlerAlreadyRegistered(handlerWrapper.getFrameType());
        }
    }

    protected HandlerWrapper createHandlerWrapper(Class<?> type, E handler) {
        if (type == byte[].class || type == ByteBuffer.class || type == InputStream.class) {
            return new HandlerWrapper(FrameType.BYTE, (MessageHandler)handler, type, false);
        }
        if (type == String.class || type == Reader.class) {
            return new HandlerWrapper(FrameType.TEXT, (MessageHandler)handler, type, false);
        }
        if (type == PongMessage.class) {
            return new HandlerWrapper(FrameType.PONG, (MessageHandler)handler, type, false);
        }
        Encoding encoding = this.session.getEncoding();
        if (encoding.canDecodeText(type)) {
            return new HandlerWrapper(FrameType.TEXT, (MessageHandler)handler, type, true);
        }
        if (encoding.canDecodeBinary(type)) {
            return new HandlerWrapper(FrameType.BYTE, (MessageHandler)handler, type, true);
        }
        throw JsrWebSocketMessages.MESSAGES.unsupportedFrameType(type);
    }

    protected void verify(Class<?> type, E handler) {
    }

    public final void removeHandler(E handler) {
        Class<?> type = ClassUtils.getHandlerType(handler.getClass());
        FrameType frameType = this.createHandlerWrapper(type, handler).getFrameType();
        HandlerWrapper wrapper = (HandlerWrapper)this.handlers.get((Object)frameType);
        if (wrapper != null && wrapper.getMessageType() == type) {
            this.handlers.remove((Object)frameType, wrapper);
        }
    }

    public final Set<MessageHandler> getHandlers() {
        HashSet<MessageHandler> msgHandlers = new HashSet<MessageHandler>();
        for (HandlerWrapper handler : this.handlers.values()) {
            msgHandlers.add(handler.getHandler());
        }
        return msgHandlers;
    }

    protected final HandlerWrapper getHandler(FrameType type) {
        return (HandlerWrapper)this.handlers.get((Object)type);
    }

    UndertowSession getSession() {
        return this.session;
    }

    Endpoint getEndpoint() {
        return this.endpoint;
    }

    static final class HandlerWrapper {
        private final FrameType frameType;
        private final MessageHandler handler;
        private final Class<?> msgType;
        private final boolean decodingNeeded;

        private HandlerWrapper(FrameType frameType, MessageHandler handler, Class<?> msgType, boolean decodingNeeded) {
            this.frameType = frameType;
            this.handler = handler;
            this.msgType = msgType;
            this.decodingNeeded = decodingNeeded;
        }

        public MessageHandler getHandler() {
            return this.handler;
        }

        public Class<?> getMessageType() {
            return this.msgType;
        }

        FrameType getFrameType() {
            return this.frameType;
        }

        boolean isDecodingNeeded() {
            return this.decodingNeeded;
        }
    }

    static enum FrameType {
        PONG,
        BYTE,
        TEXT;

    }
}

