/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.FragmentedFrameHandler;
import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.jsr.AbstractFrameHandler;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UTF8Output;
import io.undertow.websockets.jsr.UndertowSession;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.websocket.DecodeException;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.xnio.Buffers;

class PartialFrameHandler
extends AbstractFrameHandler<MessageHandler>
implements FragmentedFrameHandler {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private UTF8Output utf8Output;

    public PartialFrameHandler(UndertowSession session, Endpoint endpoint) {
        super(session, endpoint);
    }

    public void onTextFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.TEXT);
        if (handler != null) {
            String text;
            boolean last = header.isLastFragement();
            if (this.utf8Output == null && last) {
                text = PartialFrameHandler.toString(payload);
            } else {
                if (this.utf8Output == null) {
                    this.utf8Output = new UTF8Output(payload);
                } else {
                    this.utf8Output.write(payload);
                }
                text = this.utf8Output.extract();
                if (last) {
                    this.utf8Output = null;
                }
            }
            if (handler.getMessageType() == String.class) {
                ((MessageHandler.Partial)handler.getHandler()).onMessage((Object)text, last);
            } else if (handler.getMessageType() == Reader.class) {
                ((MessageHandler.Partial)handler.getHandler()).onMessage((Object)new StringReader(text), last);
            } else {
                try {
                    Object object = this.getSession().getEncoding().decodeText(handler.getMessageType(), text);
                    ((MessageHandler.Whole)handler.getHandler()).onMessage(object);
                }
                catch (DecodeException e) {
                    this.getEndpoint().onError((Session)this.getSession(), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void verify(Class<?> type, MessageHandler handler) {
        if (handler instanceof MessageHandler.Partial && type == PongMessage.class) {
            throw JsrWebSocketMessages.MESSAGES.pongMessageNotSupported();
        }
    }

    public void onBinaryFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.BYTE);
        if (handler != null) {
            MessageHandler.Partial mHandler = (MessageHandler.Partial)handler.getHandler();
            if (handler.getMessageType() == ByteBuffer.class) {
                mHandler.onMessage((Object)PartialFrameHandler.toBuffer(payload), header.isLastFragement());
            } else if (handler.getMessageType() == byte[].class) {
                long size = Buffers.remaining((Buffer[])payload);
                if (size == 0L) {
                    mHandler.onMessage((Object)EMPTY, header.isLastFragement());
                } else {
                    byte[] data = PartialFrameHandler.toArray(payload);
                    mHandler.onMessage((Object)data, header.isLastFragement());
                }
            } else if (handler.getMessageType() == InputStream.class) {
                long size = Buffers.remaining((Buffer[])payload);
                if (size == 0L) {
                    mHandler.onMessage((Object)new ByteArrayInputStream(EMPTY), header.isLastFragement());
                } else {
                    byte[] data = PartialFrameHandler.toArray(payload);
                    mHandler.onMessage((Object)new ByteArrayInputStream(data), header.isLastFragement());
                }
            } else {
                try {
                    Object object = this.getSession().getEncoding().decodeBinary(handler.getMessageType(), PartialFrameHandler.toArray(payload));
                    mHandler.onMessage(object, header.isLastFragement());
                }
                catch (DecodeException e) {
                    this.getEndpoint().onError((Session)this.getSession(), (Throwable)e);
                }
            }
        }
    }

    protected static String toString(ByteBuffer ... payload) {
        ByteBuffer buffer = PartialFrameHandler.toBuffer(payload);
        if (buffer.hasArray()) {
            return new String(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), UTF_8);
        }
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return new String(data, UTF_8);
    }
}

