/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.UndertowLogger;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JsrWebSocketServlet
extends HttpServlet {
    private final Set<Handshake> handshakes;
    private final WebSocketConnectionCallback callback;

    public JsrWebSocketServlet(WebSocketConnectionCallback callback, ConfiguredServerEndpoint ... configs) {
        this.callback = callback;
        this.handshakes = this.handshakes(configs);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(req, resp);
        Handshake handshaker = null;
        for (Handshake method : this.handshakes) {
            if (!method.matches((WebSocketHttpExchange)facade)) continue;
            handshaker = method;
            break;
        }
        if (handshaker == null) {
            UndertowLogger.REQUEST_LOGGER.debug((Object)"Could not find hand shaker for web socket request");
            resp.sendError(400);
            return;
        }
        handshaker.handshake((WebSocketHttpExchange)facade, this.callback);
    }

    protected Set<Handshake> handshakes(ConfiguredServerEndpoint ... configs) {
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        for (ConfiguredServerEndpoint config : configs) {
            handshakes.add((Handshake)new JsrHybi07Handshake(config));
            handshakes.add((Handshake)new JsrHybi08Handshake(config));
            handshakes.add((Handshake)new JsrHybi13Handshake(config));
        }
        return handshakes;
    }
}

