/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JsrWebSocketFilter
implements Filter {
    private final Set<Handshake> handshakes;
    private final WebSocketConnectionCallback callback;

    public JsrWebSocketFilter(WebSocketConnectionCallback callback, ConfiguredServerEndpoint ... configs) {
        this.callback = callback;
        this.handshakes = this.handshakes(configs);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange((HttpServletRequest)request, (HttpServletResponse)response);
        Handshake handshaker = null;
        for (Handshake method : this.handshakes) {
            if (!method.matches((WebSocketHttpExchange)facade)) continue;
            handshaker = method;
            break;
        }
        if (handshaker == null) {
            chain.doFilter(request, response);
        } else {
            handshaker.handshake((WebSocketHttpExchange)facade, this.callback);
        }
    }

    public void destroy() {
    }

    protected Set<Handshake> handshakes(ConfiguredServerEndpoint ... configs) {
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        for (ConfiguredServerEndpoint config : configs) {
            handshakes.add((Handshake)new JsrHybi07Handshake(config));
            handshakes.add((Handshake)new JsrHybi08Handshake(config));
            handshakes.add((Handshake)new JsrHybi13Handshake(config));
        }
        return handshakes;
    }
}

