/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.annotated.BoundParameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.DeploymentException;

final class BoundMethod {
    private final Method method;
    private final List<BoundParameter> parameters = new ArrayList<BoundParameter>();
    private final Set<Class> paramTypes = new HashSet<Class>();

    public BoundMethod(Method method, BoundParameter ... params) throws DeploymentException {
        this.method = method;
        HashSet<Integer> allParams = new HashSet<Integer>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            allParams.add(i);
        }
        for (BoundParameter param : params) {
            this.parameters.add(param);
            allParams.removeAll(param.positions());
            this.paramTypes.add(param.getType());
        }
        if (!allParams.isEmpty()) {
            throw JsrWebSocketMessages.MESSAGES.invalidParamers(method, allParams);
        }
    }

    public Object invoke(Object instance, Map<Class<?>, Object> values) {
        Object[] params = new Object[this.method.getParameterTypes().length];
        for (BoundParameter param : this.parameters) {
            param.populate(params, values);
        }
        try {
            return this.method.invoke(instance, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasParameterType(Class<?> type) {
        return this.paramTypes.contains(type);
    }
}

