/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.util.PathTemplate;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.jsr.ConfiguredClientEndpoint;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpointFactory;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.XnioWorker;

public class ServerWebSocketContainer
implements ServerContainer {
    private final ClassIntrospecter classIntrospecter;
    private final Map<Class<?>, ConfiguredClientEndpoint> clientEndpoints = new HashMap();
    private final List<ConfiguredServerEndpoint> configuredServerEndpoints = new ArrayList<ConfiguredServerEndpoint>();
    private final TreeSet<PathTemplate> seenPaths = new TreeSet();
    private final XnioWorker xnioWorker;
    private final Pool<ByteBuffer> bufferPool;
    private final ThreadSetupAction threadSetupAction;
    private volatile long defaultAsyncSendTimeout;
    private volatile long maxSessionIdleTimeout;
    private volatile int defaultMaxBinaryMessageBufferSize;
    private volatile int defaultMaxTextMessageBufferSize;
    private volatile boolean deploymentComplete = false;

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, XnioWorker xnioWorker, Pool<ByteBuffer> bufferPool, ThreadSetupAction threadSetupAction) {
        this.classIntrospecter = classIntrospecter;
        this.bufferPool = bufferPool;
        this.xnioWorker = xnioWorker;
        this.threadSetupAction = threadSetupAction;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long defaultAsyncSendTimeout) {
        this.defaultAsyncSendTimeout = defaultAsyncSendTimeout;
    }

    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        ConfiguredClientEndpoint config = this.getClientEndpoint(annotatedEndpointInstance.getClass());
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(annotatedEndpointInstance.getClass());
        }
        Endpoint instance = config.getFactory().createInstanceForExisting(annotatedEndpointInstance);
        return this.connectToServerInternal(instance, config, path);
    }

    public Session connectToServer(Class<?> aClass, URI uri) throws DeploymentException, IOException {
        ConfiguredClientEndpoint config = this.getClientEndpoint(aClass);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(aClass);
        }
        try {
            InstanceHandle<Endpoint> instance = config.getFactory().createInstance();
            return this.connectToServerInternal((Endpoint)instance.getInstance(), config, uri);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        IoFuture session = WebSocketClient.connect((XnioWorker)this.xnioWorker, this.bufferPool, (OptionMap)OptionMap.EMPTY, (URI)path, (WebSocketVersion)WebSocketVersion.V13);
        WebSocketChannel channel = (WebSocketChannel)session.get();
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, cec.getDecoders(), cec.getEncoders());
        UndertowSession undertowSession = new UndertowSession(channel, path, Collections.<String, String>emptyMap(), Collections.<String, List<String>>emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec, path.getQuery(), encodingFactory.createEncoding((EndpointConfig)cec), new HashSet<Session>());
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec);
        channel.resumeReceives();
        return undertowSession;
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            Endpoint endpoint = endpointClass.newInstance();
            return this.connectToServer(endpoint, cec, path);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Session connectToServerInternal(Endpoint endpointInstance, ConfiguredClientEndpoint cec, URI path) throws DeploymentException, IOException {
        IoFuture session = WebSocketClient.connect((XnioWorker)this.xnioWorker, this.bufferPool, (OptionMap)OptionMap.EMPTY, (URI)path, (WebSocketVersion)WebSocketVersion.V13);
        WebSocketChannel channel = (WebSocketChannel)session.get();
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        UndertowSession undertowSession = new UndertowSession(channel, path, Collections.<String, String>emptyMap(), Collections.<String, List<String>>emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec.getConfig(), path.getQuery(), cec.getEncodingFactory().createEncoding((EndpointConfig)cec.getConfig()), new HashSet<Session>());
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec.getConfig());
        channel.resumeReceives();
        return undertowSession;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.maxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.defaultMaxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int defaultMaxBinaryMessageBufferSize) {
        this.defaultMaxBinaryMessageBufferSize = defaultMaxBinaryMessageBufferSize;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.defaultMaxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int defaultMaxTextMessageBufferSize) {
        this.defaultMaxTextMessageBufferSize = defaultMaxTextMessageBufferSize;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    public void invokeEndpointMethod(final WebSocketChannel channel, final Runnable invocation) {
        channel.suspendReceives();
        this.xnioWorker.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ThreadSetupAction.Handle handle = ServerWebSocketContainer.this.threadSetupAction.setup(null);
                    try {
                        invocation.run();
                    }
                    finally {
                        handle.tearDown();
                    }
                }
                finally {
                    channel.resumeReceives();
                }
            }
        });
    }

    public void addEndpoint(Class<?> endpoint) throws DeploymentException {
        block9: {
            if (this.deploymentComplete) {
                throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
            }
            try {
                ServerEndpoint serverEndpoint = endpoint.getAnnotation(ServerEndpoint.class);
                ClientEndpoint clientEndpoint = endpoint.getAnnotation(ClientEndpoint.class);
                if (serverEndpoint != null) {
                    JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedServerEndpoint(endpoint, serverEndpoint.value());
                    PathTemplate template = PathTemplate.create((String)serverEndpoint.value());
                    if (this.seenPaths.contains(template)) {
                        PathTemplate existing = null;
                        for (PathTemplate p : this.seenPaths) {
                            if (p.compareTo(template) != 0) continue;
                            existing = p;
                            break;
                        }
                        throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
                    }
                    this.seenPaths.add(template);
                    EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, serverEndpoint.decoders(), serverEndpoint.encoders());
                    AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, this.classIntrospecter.createInstanceFactory(endpoint), encodingFactory);
                    Class configuratorClass = serverEndpoint.configurator();
                    Object configurator = configuratorClass != ServerEndpointConfig.Configurator.class ? (ServerEndpointConfig.Configurator)configuratorClass.newInstance() : new ServerInstanceFactoryConfigurator(factory);
                    ServerEndpointConfig config = ServerEndpointConfig.Builder.create(endpoint, (String)serverEndpoint.value()).decoders(Arrays.asList(serverEndpoint.decoders())).encoders(Arrays.asList(serverEndpoint.encoders())).subprotocols(Arrays.asList(serverEndpoint.subprotocols())).configurator(configurator).build();
                    ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(config, factory, template, encodingFactory);
                    this.configuredServerEndpoints.add(confguredServerEndpoint);
                    break block9;
                }
                if (clientEndpoint != null) {
                    JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedClientEndpoint(endpoint);
                    EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, clientEndpoint.decoders(), clientEndpoint.encoders());
                    AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, this.classIntrospecter.createInstanceFactory(endpoint), encodingFactory);
                    ClientEndpointConfig config = ClientEndpointConfig.Builder.create().decoders(Arrays.asList(clientEndpoint.decoders())).encoders(Arrays.asList(clientEndpoint.encoders())).preferredSubprotocols(Arrays.asList(clientEndpoint.subprotocols())).configurator((ClientEndpointConfig.Configurator)clientEndpoint.configurator().newInstance()).build();
                    ConfiguredClientEndpoint configuredClientEndpoint = new ConfiguredClientEndpoint(config, factory, encodingFactory);
                    this.clientEndpoints.put(endpoint, configuredClientEndpoint);
                    break block9;
                }
                throw JsrWebSocketMessages.MESSAGES.classWasNotAnnotated(endpoint);
            }
            catch (NoSuchMethodException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
            catch (InstantiationException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
            catch (IllegalAccessException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
        }
    }

    public void addEndpoint(ServerEndpointConfig endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        JsrWebSocketLogger.ROOT_LOGGER.addingProgramaticEndpoint(endpoint.getEndpointClass(), endpoint.getPath());
        PathTemplate template = PathTemplate.create((String)endpoint.getPath());
        if (this.seenPaths.contains(template)) {
            PathTemplate existing = null;
            for (PathTemplate p : this.seenPaths) {
                if (p.compareTo(template) != 0) continue;
                existing = p;
                break;
            }
            throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
        }
        this.seenPaths.add(template);
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, endpoint.getDecoders(), endpoint.getEncoders());
        ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(endpoint, null, template, encodingFactory);
        this.configuredServerEndpoints.add(confguredServerEndpoint);
    }

    public ConfiguredClientEndpoint getClientEndpoint(Class<?> type) {
        return this.clientEndpoints.get(type);
    }

    public void deploymentComplete() {
        this.deploymentComplete = true;
    }

    public List<ConfiguredServerEndpoint> getConfiguredServerEndpoints() {
        return this.configuredServerEndpoints;
    }

    private static final class ServerInstanceFactoryConfigurator
    extends ServerEndpointConfig.Configurator {
        private final InstanceFactory<?> factory;

        private ServerInstanceFactoryConfigurator(InstanceFactory<?> factory) {
            this.factory = factory;
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            return (T)this.factory.createInstance().getInstance();
        }
    }
}

