/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;

public class UndertowContainerProvider
extends ContainerProvider {
    private static final RuntimePermission PERMISSION = new RuntimePermission("io.undertow.websockets.jsr.MODIFY_WEBSOCKET_CONTAINER");
    private static final Map<ClassLoader, WebSocketContainer> webSocketContainers = new ConcurrentHashMap<ClassLoader, WebSocketContainer>();

    protected WebSocketContainer getContainer() {
        ClassLoader tccl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return webSocketContainers.get(tccl);
    }

    public static void addContainer(ClassLoader classLoader, WebSocketContainer webSocketContainer) {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(PERMISSION);
        }
        webSocketContainers.put(classLoader, webSocketContainer);
    }

    public static void removeContainer(ClassLoader classLoader) {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(PERMISSION);
        }
        webSocketContainers.remove(classLoader);
    }
}

