/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.websockets.jsr.JsrWebSocketFilter;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowContainerProvider;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;

public class Bootstrap
implements ServletExtension {
    public static final String FILTER_NAME = "Undertow Web Socket Filter";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)deploymentInfo.getServletContextAttributes().get("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        if (info == null) {
            return;
        }
        ArrayList<ContextClassLoaderSetupAction> setup = new ArrayList<ContextClassLoaderSetupAction>();
        setup.add(new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()));
        setup.addAll(deploymentInfo.getThreadSetupActions());
        CompositeThreadSetupAction threadSetupAction = new CompositeThreadSetupAction(setup);
        ServerWebSocketContainer container = new ServerWebSocketContainer(deploymentInfo.getClassIntrospecter(), info.getWorker(), info.getBuffers(), (ThreadSetupAction)threadSetupAction, false);
        try {
            for (Class<?> annotation : info.getAnnotatedEndpoints()) {
                container.addEndpoint(annotation);
            }
            for (ServerEndpointConfig programatic : info.getProgramaticEndpoints()) {
                container.addEndpoint(programatic);
            }
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
        servletContext.setAttribute(ServerContainer.class.getName(), (Object)container);
        info.containerReady(container);
        UndertowContainerProvider.addContainer(deploymentInfo.getClassLoader(), (WebSocketContainer)container);
        deploymentInfo.addListener(Servlets.listener(WebSocketListener.class));
    }

    private static final class WebSocketListener
    implements ServletContextListener {
        private WebSocketListener() {
        }

        public void contextInitialized(ServletContextEvent sce) {
            ServerWebSocketContainer container = (ServerWebSocketContainer)sce.getServletContext().getAttribute(ServerContainer.class.getName());
            FilterRegistration.Dynamic filter = sce.getServletContext().addFilter(Bootstrap.FILTER_NAME, JsrWebSocketFilter.class);
            filter.setAsyncSupported(true);
            if (!container.getConfiguredServerEndpoints().isEmpty()) {
                filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
            } else {
                container.setContextToAddFilter((ServletContextImpl)sce.getServletContext());
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
            UndertowContainerProvider.removeContainer(sce.getServletContext().getClassLoader());
        }
    }
}

